% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{commboot}
\alias{commboot}
\title{Bootstrapped Communities Likelihood}
\usage{
commboot(data, normal = FALSE, n = nrow(data), iter = 100,
  filter = c("TMFG", "threshold"), method = c("louvain", "walktrap"),
  na.data = c("pairwise", "listwise", "fiml", "none"), steps = 4,
  seeds = NULL, ...)
}
\arguments{
\item{data}{A set of data}

\item{normal}{Should data be transformed to a normal distribution?
Defaults to FALSE.
Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal}

\item{n}{Number of people to use in the bootstrap.
Defaults to full sample size}

\item{iter}{Number of bootstrap iterations.
Defaults to 100 iterations}

\item{filter}{Set filter method.
Defaults to "TMFG"}

\item{method}{Defaults to "walktrap".
Set to "louvain" for the louvain community detection algorithm}

\item{na.data}{How should missing data be handled?
For "listwise" deletion the \emph{na.omit} function is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\emph{psych} package).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{steps}{Number of steps to use in the walktrap algorithm.
Defaults to 4.
Use a larger number of steps for smaller networks}

\item{seeds}{Seeds to use for random number generation.
Defaults to NULL.
Input seeds from previous run (\strong{see examples})}

\item{...}{Additional arguments for network filtering methods}
}
\value{
Returns a list with the factors and their proportion found across bootstrapped samples
(proportion; i.e., their likelihood) and the seeds used in the random number generator (Seeds)
}
\description{
Bootstraps the sample with replace to compute walktrap reliability
}
\examples{
\dontrun{
commTMFG<-commboot(neoOpen)

#Replicates previous analysis
repcommTMFG<-commboot(neoOpen, seeds = commTMFG$Seeds)

commThreshold<-commboot(neoOpen,filter="threshold")
}
}
\references{
Blondel, V. D., Guillaume, J. L., Lambiotte, R., & Lefebvre, E. (2008).
Fast unfolding of communities in large networks.
\emph{Journal of Statistical Mechanics: Theory and Experiment}, \emph{2008}(10), P10008.

Csardi, G., & Nepusz, T. (2006).
The igraph software package for complex network research.
\emph{InterJournal, Complex Systems}, \emph{1695}(5), 1-9.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
