% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMrelate.R
\name{NMrelate}
\alias{NMrelate}
\title{Relate parameter names and variables based on control stream code
sections.}
\usage{
NMrelate(file, lines, modelname, par.type, col.model, sections, as.fun)
}
\arguments{
\item{file}{Path to a control stream to process. See `lines` too.}

\item{lines}{If the control stream has been read already, the text
can be provided here instead of using the `file`
argument. Character vector of text lines.}

\item{modelname}{Either a model name (like "Base") or a function
that derives the model name from the control stream file
path. The default is dropping the file name extension on the
control stream file name.}

\item{par.type}{Parameter type(s) to include. Default is all three
possible which is \code{c("THETA","OMEGA","SIGMA")}.}

\item{col.model}{Name of the column containing the model name.}

\item{sections}{Sections of the control stream to
consider. Default is all of \code{c("PRED","PK","ERROR")}.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say tibble::as_tibble) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\description{
Relate parameter names and variables based on control stream code
sections.
}
\details{
`NMrelate()` processes $PRED, $PK and $ERROR sections. It
    does not read ext files or $THETA, $OMEGA, $SIGMA sections to
    gain information but only extracts what it can from the model
    code. You can then merge with information from functions such
    as `NMreadExt()` and `NMreadParText()`.
}
