% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flagsCount.R
\name{flagsCount}
\alias{flagsCount}
\title{Create an overview of number of retained and discarded datapoints.}
\usage{
flagsCount(
  data,
  tab.flags,
  file,
  col.id = "ID",
  col.flagn,
  col.flagc,
  by = NULL,
  flags.increasing = FALSE,
  flagc.0 = "Analysis set",
  name.all.data = "All available data",
  grp.incomp = "EVID",
  save = TRUE,
  as.fun = NULL
)
}
\arguments{
\item{data}{The dataset including both FLAG and flag columns.}

\item{tab.flags}{A data.frame containing at least these named
columns: FLAG, flag, condition. Condition is disregarded for
FLAG==0.}

\item{file}{A file to write the table of flag counts to. Will
probably be removed and put in a separate function.}

\item{col.id}{The name of the subject ID column. Default is "ID".}

\item{col.flagn}{The name of the column containing the numerical
flag values in tab.flags. This will be added to data. Use the
same as when flagsAssign was called (if that was
used). Default value is FLAG and can be configured using
NMdataConf.}

\item{col.flagc}{The name of the column containing the character
flag values in data and tab.flags. Use the same as when
flagsAssign was called (if that was used). Default value is
flag and can be configured using NMdataConf.}

\item{by}{An optional column to group the counting by. This could
be "STUDY", "DRUG", "EVID", or a combination of multiple
columns.}

\item{flags.increasing}{The flags are applied by either decreasing
(default) or increasing value of col.flagn. By using
decreasing order, you can easily adjust the Nonmem IGNORE
statement from IGNORE(FLAG.NE.0) to say IGNORE(FLAG.GT.10) if
BLQ's have FLAG=10, and you decide to include these in the
analysis.}

\item{flagc.0}{The character flag to assign to rows that are not
matched by exclusion conditions (numerical flag 0).}

\item{name.all.data}{What to call the total set of data before
applying exclusion flags. Default is "All available data".}

\item{grp.incomp}{Column(s) that distinct incompatible subsets of
data. Default is "EVID" meaning that if different values of
EVID are found in data, the function will return an
error. This is a safeguard not to mix data unintentionally
when counting flags.}

\item{save}{Save file? Default is TRUE, meaning that a file will
be written if file argument is supplied.}

\item{as.fun}{The default is to return a data.table if input data
is a data.table, and return a data.frame for all other input
classes. Pass a function in as.fun to convert to something
else. If data is not a data.table, default can be configured
using NMdataConf.}
}
\value{
A summary table with number of discarded and retained
    subjects and observations when applying each condition in the
    flag table. "discarded" means that the reduction of number of
    observations and subjects resulting from the flag, "retained"
    means the numbers that are left after application of the
    flag. The default is "both" which will report both. Class as
    defined by as.fun.
}
\description{
Generate an overview of number of observations disregarded due to
different reasons. And how many are left after each exclusion
flag.
}
\details{
This function is used to count flags as assigned by the
    flagsAssign function.

Notice that the character flags reported in the output table are
taken from tab.flags. The data column named by the value of
col.flagc (default is flag) is not used.

In the returned table, N.discarded is the difference in number of
    subjects since previous step. If two is reported, it can mean
    that the remaining one observation of these two subjects are
    discarded due to this flag. The majority of the samples can
    have been discarded by earlier flags.
}
\examples{
\dontrun{
pk <- readRDS(file=system.file("examples/data/xgxr2.rds",package="NMdata"))
dt.flags <- data.frame(
       flagn=10,
       flagc="Below LLOQ",
       condition=c("BLQ==1")
)
pk <- flagsAssign(pk,dt.flags,subset.data="EVID==0",col.flagn="flagn",col.flagc="flagc")
pk <- flagsAssign(pk,subset.data="EVID==1",flagc.0="Dosing",
        col.flagn="flagn",col.flagc="flagc")
unique(pk[,c("EVID","flagn","flagc","BLQ")])
flagsCount(pk[EVID==0],dt.flags,col.flagn="flagn",col.flagc="flagc")
}
}
\seealso{
Other DataCreate: 
\code{\link{NMorderColumns}()},
\code{\link{NMstamp}()},
\code{\link{NMwriteData}()},
\code{\link{addTAPD}()},
\code{\link{findCovs}()},
\code{\link{findVars}()},
\code{\link{flagsAssign}()},
\code{\link{mergeCheck}()},
\code{\link{tmpcol}()}
}
\concept{DataCreate}
