% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editCharCols.R
\name{editCharCols}
\alias{editCharCols}
\title{Replace strings in character character columns of a data set}
\usage{
editCharCols(data, pattern, replacement, as.fun, ...)
}
\arguments{
\item{data}{The data set to edit.}

\item{pattern}{Pattern to search for in character columns. Passed
to `gsub()`. By default, `gsub()` works with regular
expressions. See ... for how to disable this if you want to
replace a specific string.}

\item{replacement}{pattern or string to replace with. Passed to
`gsub()`.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say tibble::as_tibble) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}

\item{...}{Additional arguments passed to `gsub()`. Especially,
notice fixed=TRUE will disable interpretation of `pattern` and
`replace` as regular expressions.}
}
\description{
Replace strings in character character columns of a data set
}
\examples{
### remove commas from character columns 
dat <- data.frame(A=1:3,text=cc(a,"a,d","g"))
editCharCols(dat,pattern=",","")
### factors are not edited but result in an error
\dontrun{
dat <- data.frame(A=1:3,text=cc(a,"a,d",g),fac=cl("a","a,d","g"))
editCharCols(dat,pattern=",","")
}

}
