% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getContent.R
\name{getContentDatetime}
\alias{getContentDatetime}
\title{Get Content datetime}
\usage{
getContentDatetime(
  html_obj,
  datetime_node_info = "span._ARTICLE_DATE_TIME",
  datetime_attr = "data-date-time"
)
}
\arguments{
\item{html_obj}{"xml_document" "xml_node" using read_html function.}

\item{datetime_node_info}{Information about node names like tag with class or id. Default is "div.article_info h3" for naver news title.}

\item{datetime_attr}{if you want to get attribution text, please write down here.}
}
\value{
Get POSIXlt type datetime.
}
\description{
Get naver news published datetime from link.
}
\examples{
\dontrun{
  hobj <- rvest::read_html("https://n.news.naver.com/mnews/article/214/0001195110?sid=103")
  getContentDatetime(hobj)
  }
}
