% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createModels.R
\name{.convertData}
\alias{.convertData}
\title{Convert a matrix or data frame to numeric or integer for Mplus}
\usage{
.convertData(df)
}
\arguments{
\item{df}{A matrix or data frame}
}
\value{
An error if it cannot be converted or
  a matrix or data frame with all variables converted to
  numeric or integer classes
}
\description{
Primarily an internal utility function, for \code{prepareMplusData}.
}
\examples{

\dontrun{
df1 <- df2 <- df3 <- df4 <- mtcars

df2$cyl <- factor(df2$cyl)
df2$am <- as.logical(df2$am)

df3$mpg <- as.character(df3$mpg)

df4$vs <- as.Date(df4$vs, origin = "1989-01-01")

df5 <- as.matrix(cars)

df6 <- matrix(c(TRUE, TRUE, FALSE, FALSE), ncol = 2)

df7 <- as.list(mtcars)


MplusAutomation:::.convertData(df1)

MplusAutomation:::.convertData(df2)

MplusAutomation:::.convertData(df3)

MplusAutomation:::.convertData(df4)

MplusAutomation:::.convertData(df5)

MplusAutomation:::.convertData(df6)

MplusAutomation:::.convertData(df7)

rm(df1, df2, df3, df4, df5, df6, df7)
}
}
\keyword{internal}
