% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractStateFit.R
\name{ExtractStateFit}
\alias{ExtractStateFit}
\alias{ExtractStateFit.MSGARCH_ML_FIT}
\alias{ExtractStateFit.MSGARCH_MCMC_FIT}
\title{Single-regime model extractor.}
\usage{
ExtractStateFit(object)

\method{ExtractStateFit}{MSGARCH_ML_FIT}(object)

\method{ExtractStateFit}{MSGARCH_MCMC_FIT}(object)
}
\arguments{
\item{object}{Fit object of type \code{MSGARCH_ML_FIT}
created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT}
created with \code{\link{FitMCMC}}.}
}
\value{
A list of with \code{K} element where each element is a fit object of type \code{MSGARCH_ML_FIT} or
\code{MSGARCH_MCMC_FIT}.
}
\description{
Extracts each regime from a fitted multiple regime specificaton
and creates a fitted object for each extracted regime.
}
\examples{
# load data
data("SMI", package = "MSGARCH")

# create model specification
# MS(2)-GARCH(1,1)-Normal (default)
spec <- CreateSpec()

# fit the model on the data with ML estimation
fit <- FitML(spec = spec, data = SMI)
SR.fit <- ExtractStateFit(fit)
}
