% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMT.R
\name{HMT}
\alias{HMT}
\title{Hierarchical Multiple Testing procedure

Apply Hierarchical Multiple Testing procedure on a \code{\link{MLGL}} object}
\usage{
HMT(
  res,
  X,
  y,
  control = c("FWER", "FDR"),
  alpha = 0.05,
  test = partialFtest,
  addRoot = FALSE,
  Shaffer = FALSE,
  ...
)
}
\arguments{
\item{res}{\code{\link{MLGL}} object}

\item{X}{matrix of size n*p}

\item{y}{vector of size n.}

\item{control}{either "FDR" or "FWER"}

\item{alpha}{control level for testing procedure}

\item{test}{test used in the testing procedure. Default is \link{partialFtest}}

\item{addRoot}{If TRUE, add a common root containing all the groups}

\item{Shaffer}{If TRUE, a Shaffer correction is performed (only if control = "FWER")}

\item{...}{extra parameters for \link{selFDR}}
}
\value{
a list containing:
\describe{
  \item{lambdaOpt}{lambda values maximizing the number of rejects}
  \item{var}{A vector containing the index of selected variables for the first \code{lambdaOpt} value}
  \item{group}{A vector containing the values index of selected groups for the first \code{lambdaOpt} value}
  \item{selectedGroups}{Selected groups for the first \code{lambdaOpt} value}
  \item{indLambdaOpt}{indices associated with optimal lambdas}
  \item{reject}{Selected groups for all lambda values}
  \item{alpha}{Control level}
  \item{test}{Test used in the testing procedure}
  \item{control}{"FDR" or "FWER"}
  \item{time}{Elapsed time}
  \item{hierTest}{list containing the output of the testing function for each lambda. Each element can be used 
  with the \link{selFWER} or \link{selFDR} functions.}
  \item{lambda}{lambda path}
  \item{nGroup}{Number of groups before testing}
  \item{nSelectedGroup}{Numer of groups after testing}
}
}
\description{
Hierarchical Multiple Testing procedure

Apply Hierarchical Multiple Testing procedure on a \code{\link{MLGL}} object
}
\examples{
set.seed(42)
X <- simuBlockGaussian(50, 12, 5, 0.7)
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
res <- MLGL(X, y)

# perform hierarchical testing with FWER control
out <- HMT(res, X, y, alpha = 0.05)

# test a new value of alpha for a specific lambda
selFWER(out$hierTest[[60]], alpha = 0.1)
}
\seealso{
\link{hierarchicalFWER} \link{hierarchicalFDR} \link{selFWER} \link{selFDR}
}
