
/* static char whatssi[] = "@(#) $File: //depot/Research/ifultools/pkg/ifultools/src/wav_look.c $: $Revision: #1 $, $Date: 2008/03/21 $ "; */
/* This is a self-documenting doc++ file. */

/* This file contains global lookup table variables for wavelet
   functions */


/* The FDP_SDF_TABLE rows correspond to fractionally differenced (FD)
   parameters (delta). The following three variables define the
   relation of the FDP_SDF_TABLE rows to the FD deltas */
double FDP_SDF_TABLE_dDELTA    = 0.1;
double FDP_SDF_TABLE_DELTA_MIN = -15.0;
double FDP_SDF_TABLE_DELTA_MAX = 15.0;

/** Mid-octave SDF value table for FD processes.
 *
 * Defines mid-octave spectral density function values under a
 * fractionally differenced (FD) process model for various
 * FD parameters (delta as rows) and wavelet decomposition levels
 * (j as colummns). The rows span -15 <= delta <= 15 with a resolution
 * of 0.1 while the columns are j = 1, ..., 20. The total size of this
 * table (denoted as FDP\_SDF\_TABLE) is 301x20.
 *
 * @author Copyright (c), 1988, 2006 Insightful Corp.  All rights reserved.
 * @include wav\_look.h
 * @source wav\_look.c
 * @library wavelets
 * @private
 */
double FDP_SDF_TABLE[][20] = {
  {310233731.834993,2616.3299895201,2.22172949682185e-05,3.57069350486763e-14,3.80977965540182e-23,3.67070645532432e-32,3.44775537479329e-41,3.21779365871191e-50,2.99839415711402e-59,2.79284255416345e-68,2.60112356280623e-77,2.42250517424241e-86,2.25613843135289e-95,2.10119374116783e-104,1.95688941824785e-113,1.82249535025305e-122,1.69733107556237e-131,1.58076275046669e-140,1.47220003536572e-149,1.37109312745923e-158},
  {270963691.307593,2456.57200627747,2.35892846674308e-05,4.33817681123969e-14,5.31182371462984e-23,5.87753664207106e-32,6.34106367246687e-41,6.79803437387069e-50,7.27642840841947e-59,7.78541170336598e-68,8.32917546604149e-77,8.91069779799545e-86,9.53276172700217e-95,1.01982367667288e-103,1.09101639170184e-112,1.16717887550285e-121,1.24865813651507e-130,1.33582535223177e-139,1.42907759681607e-148,1.52883965972057e-157},
  {236669681.303323,2306.66201068646,2.50470458598538e-05,5.27084442440924e-14,7.40637592749282e-23,9.41151080901548e-32,1.16628877587482e-40,1.43623939032442e-49,1.76590001901088e-58,2.17037624180239e-67,2.66723543262901e-76,3.27775908200503e-85,4.02800540877822e-94,4.94996804395191e-103,6.08295465455768e-112,7.47526720519442e-121,9.18626253596977e-130,1.12888832677465e-138,1.38727675965179e-147,1.70480707569066e-156},
  {206720582.483425,2165.98846029499,2.65960191497981e-05,6.40429989070822e-14,1.03272904944709e-22,1.50709939616604e-31,2.1452041592467e-40,3.03451202971818e-49,4.28580605941414e-58,6.05071953332581e-67,8.54160030765985e-76,1.20576006715237e-84,1.70207975079471e-93,2.40269283213722e-102,3.39169222080009e-111,4.7877843030806e-120,6.75853718310512e-129,9.54049340831255e-138,1.34675613779798e-146,1.90110932044934e-155},
  {180565389.849927,2033.97801641878,2.8241996267877e-05,7.78183253242123e-14,1.44007736011908e-22,2.41347742897912e-31,3.94593531557531e-40,6.41164828893109e-49,1.04020207448478e-57,1.68693293169218e-66,2.73549507130923e-75,4.43571425634683e-84,7.1926439571021e-93,1.16630706952533e-101,1.89119838950337e-110,3.06662893871268e-119,4.9726209994731e-128,8.06323815260613e-137,1.30747566357129e-145,2.12010680801769e-154},
  {157723035.086942,1910.0931455282,2.99911432052372e-05,9.45607933790874e-14,2.00818763956551e-22,3.86512578941093e-31,7.25855781016578e-40,1.35478246253192e-48,2.52477083115841e-57,4.70335389621296e-66,8.7609595559226e-75,1.6318689317099e-83,3.03959882663064e-92,5.66169683976591e-101,1.05457334727043e-109,1.96429599116162e-118,3.65878642816404e-127,6.81502080579716e-136,1.26939654520219e-144,2.36443531765991e-153},
  {137773502.7907,1793.82987187594,3.18500249101791e-05,1.14910468434984e-13,2.8005417321954e-22,6.19018064729458e-31,1.33527285484286e-39,2.86278506851778e-48,6.12837757951537e-57,1.31140489818319e-65,2.80599386204681e-74,6.00380100468717e-83,1.28458627028133e-91,2.74852452360394e-100,5.88079167631623e-109,1.258264469754e-117,2.69220459789517e-126,5.76028786396831e-135,1.23248122573937e-143,2.63703829933524e-152},
  {120350075.986975,1684.71567179375,3.38256316558501e-05,1.39645711375764e-13,3.90570429773285e-22,9.91431181141562e-31,2.45645754160475e-39,6.04961146187666e-48,1.48760842158767e-56,3.65666780035832e-65,8.98755001676709e-74,2.20895498893936e-82,5.42912506387058e-91,1.33435744763643e-99,3.27955079216093e-108,8.06039822704843e-117,1.98106454804812e-125,4.86901094751451e-134,1.19669334329202e-142,2.9412029933798e-151},
  {105132567.287069,1582.30750069456,3.59254071955258e-05,1.6971311109682e-13,5.44723971416758e-22,1.58796764372161e-30,4.51927043841243e-39,1.2784567773107e-47,3.61120022782689e-56,1.0196568500243e-64,2.87882822173157e-73,8.12769263357383e-82,2.29464889705438e-90,6.47835256120386e-99,1.82899599908513e-107,5.16369868180389e-116,1.45783716743054e-124,4.11582728879244e-133,1.16199769256569e-141,3.28060081802099e-150},
  {91841410.3174227,1486.18994438506,3.81572788304102e-05,2.06263907637767e-13,7.59755237799227e-22,2.54355316749498e-30,8.31471747982029e-39,2.70187165261429e-47,8.76666897704676e-56,2.84343086371871e-64,9.22168495311374e-73,2.9906650451201e-81,9.69890576760547e-90,3.14540862141174e-98,1.02007298890662e-106,3.30815144637354e-115,1.07285124322103e-123,3.47931405860605e-132,1.12836018764926e-140,3.65933253271633e-149},
  {80232502.0132459,1395.97348682676,4.05296895239436e-05,2.50698316246129e-13,1.05972036802151e-21,4.07436903794714e-30,1.52984361232239e-38,5.71036349498987e-47,2.12832536959417e-55,7.92960729003648e-64,2.95409994883522e-72,1.10049646674592e-80,4.09967670753761e-89,1.52724932195966e-97,5.68944776734011e-106,2.11948452091513e-114,7.89569518291192e-123,2.94137567198409e-131,1.09574782601269e-139,4.0819787462857e-148},
  {70092700.2900861,1311.29288698243,4.30516322063385e-05,3.0471946975992e-13,1.47818743297331e-21,6.52680382631281e-30,2.81492762849726e-38,1.20693380088196e-46,5.16728114993461e-55,2.21147147894852e-63,9.46369523008431e-72,4.04976839678776e-80,1.73299431345881e-88,7.41589318362672e-97,3.17343522555388e-105,1.35798749780631e-113,5.81114745320492e-122,2.48672646753581e-130,1.06412865367496e-138,4.55365640716346e-147},
  {61235893.7577924,1231.80565785188,4.5732686423547e-05,3.70399070827102e-13,2.06200000881577e-21,1.0455906660482e-29,5.1797449251843e-38,2.55108007222821e-46,1.25460526742036e-54,6.16782368325332e-63,3.03191660050545e-71,1.49036507847396e-79,7.32597798603744e-88,3.60112283039852e-96,1.77015014950913e-104,8.70126185849959e-113,4.27714882085876e-121,2.10245390054984e-129,1.03347173150465e-137,5.0800819897593e-146},
  {53499570.7448374,1157.19064123848,4.85830574961303e-05,4.50257301310651e-13,2.87653091944561e-21,1.67511285458172e-29,9.53170847763027e-38,5.39244803511253e-46,3.0463048333328e-54,1.72029844272889e-62,9.71393055702386e-71,5.48499685800529e-79,3.09710065040658e-87,1.74877381808539e-95,9.87442493059086e-104,5.57557861963088e-112,3.14824169270438e-120,1.77764970726603e-128,1.00374710261586e-136,5.66764217688313e-145},
  {46741824.1544628,1087.14667219744,5.16136183656433e-05,5.47360091647476e-13,4.01301660693791e-21,2.68378660332973e-29,1.75410128498329e-37,1.13990690786246e-45,7.39709422933294e-54,4.7984080916099e-62,3.11239190175938e-70,2.0187458136344e-78,1.30938260816141e-86,8.49279984338464e-95,5.50852160949237e-103,3.57288623602322e-111,2.31741230789949e-119,1.5030984533659e-127,9.74925760823392e-136,6.32347293461453e-144},
  {40838736.7496098,1021.39132750043,5.48359543192104e-05,6.65437529754293e-13,5.5987967312895e-21,4.30005224482167e-29,3.22819995158548e-37,2.4097647507012e-45,1.796266571678e-53,1.3384816160245e-61,9.97276083599963e-70,7.43034091363267e-78,5.53604564260128e-86,4.12467733566726e-94,3.07312444848788e-102,2.28965620507859e-110,1.70592682186688e-118,1.2710145301774e-126,9.46979620123222e-135,7.05554798417037e-143},
  {35682098.5111393,959.659752810049,5.82624107970419e-05,8.09028013912748e-13,7.8116106663232e-21,6.89003834736925e-29,5.94139387623161e-37,5.09450587548739e-45,4.36216996214843e-53,3.73378923064149e-61,3.19564619000938e-69,2.73500421373383e-77,2.34074936590975e-85,2.00332416735442e-93,1.71453911064825e-101,1.46738314073905e-109,1.25585542024841e-117,1.07482005502541e-125,9.19881485163918e-134,7.87277779667519e-142},
  {31177413.8643428,901.703563594295,6.19061445028036e-05,9.83653759379098e-13,1.08995594572114e-20,1.10405833581741e-28,1.09355023806568e-36,1.07708993037996e-44,1.05939240802963e-52,1.04162085184189e-60,1.02405776275824e-68,1.0067687757351e-76,9.89766260070068e-85,9.73049555322075e-93,9.56614861025902e-101,9.4045766641054e-109,9.24573346537871e-117,9.08957307800205e-125,8.93605022677223e-133,8.78512037292304e-141},
  {27242161.9364588,847.289815125783,6.57811780530885e-05,1.19603449384888e-12,1.52089801208054e-20,1.76923370867918e-28,2.01285244374438e-36,2.27732319296262e-44,2.57296533463767e-52,2.90597810102587e-60,3.28180689853143e-68,3.70616099471281e-76,4.18536348734562e-84,4.72651991547578e-92,5.33764462763376e-100,6.02778540325127e-108,6.80715908083903e-116,7.68730328077762e-124,8.68124733836283e-132,9.80370522304169e-140},
  {23804277.6925174,796.200037205621,6.99024584198487e-05,1.45434767067876e-12,2.12233710007424e-20,2.83531637188162e-28,3.70517118270079e-36,4.81526853793584e-44,6.24933999680903e-52,8.10770892311818e-60,1.05177957459742e-67,1.36440079515671e-75,1.76993312302816e-83,2.29599620185972e-91,2.97841580368271e-99,3.86366490771341e-107,5.01202894058327e-115,6.50171134639999e-123,8.43415927511041e-131,1.09409721325053e-138},
  {20800825.8853166,748.229329527841,7.42859194386377e-05,1.76854534988056e-12,2.96177530128519e-20,4.54403139898069e-28,6.82068662212009e-36,1.01821580836417e-43,1.51795134864819e-51,2.26218147168477e-59,3.37100908291133e-67,5.0232307390557e-75,7.48521041959425e-83,1.11538376667835e-90,1.66205151493454e-98,2.47664982253508e-106,3.69049584829195e-114,5.49926736162187e-122,8.19454694392044e-130,1.22108264935177e-137},
  {18176843.3236024,703.185513859028,7.89485486759886e-05,2.15074011730186e-12,4.13345929099971e-20,7.28291008964417e-28,1.25565908777543e-35,2.15319314712638e-43,3.68727375016933e-51,6.31219727739329e-59,1.08048549969929e-66,1.84947353725028e-74,3.16573822572626e-82,5.41877731268912e-90,9.27528928517607e-98,1.58764568536092e-105,2.71756350944797e-113,4.6516369853687e-121,7.96217881953632e-129,1.36288131969856e-136},
  {15884328.0768006,660.888339449886,8.39084589713525e-05,2.61567511990494e-12,5.76898481080207e-20,1.16732760789519e-27,2.31174314475693e-35,4.553552304048e-43,8.9572995488666e-51,1.76139951872781e-58,3.46339599499296e-66,6.8098461907728e-74,1.33896792713948e-81,2.63270668009938e-89,5.17648111473413e-97,1.01781010146683e-104,2.00123859902493e-112,3.93487537990874e-120,7.73683070229654e-128,1.5212311323109e-135},
  {13881356.9527361,621.168738322378,8.91849649928665e-05,3.18129659683659e-12,8.05210935066301e-20,1.87113496417805e-27,4.25629738351059e-35,9.63035334443873e-43,2.17607253066601e-50,4.91540984943505e-58,1.11022220740595e-65,2.50755828492859e-73,5.663565148359e-81,1.27916980490111e-88,2.88912516096755e-96,6.52536002993546e-104,1.47381370766427e-111,3.32874634332136e-119,7.51828548375039e-127,1.69807521413009e-134},
  {12131314.9571005,583.868127288399,9.47986651719611e-05,3.86945131289792e-12,1.12394444134685e-19,2.999455294205e-27,7.83698967369109e-35,2.0368499654461e-42,5.28682044758705e-50,1.37178649532558e-57,3.5591197094003e-65,9.23399628763665e-73,2.39571169298176e-80,6.21553975784508e-88,1.61258644450089e-95,4.18376349028376e-103,1.0854535364087e-110,2.81614717585171e-118,7.30633291987466e-126,1.89558632364698e-133},
  {10602222.5140091,548.837753754935,0.000100771529409623,4.70673621284028e-12,1.56893631755607e-19,4.80844858312358e-27,1.44308493098622e-34,4.30825266652294e-42,1.28452056885387e-49,3.82858786503818e-57,1.14103926291892e-64,3.40058521679483e-72,1.0134550993904e-79,3.02033284871006e-87,9.00129428789169e-95,2.68259481429444e-102,7.99475560242647e-110,2.38262284271539e-117,7.10076941164841e-125,2.1161941922868e-132},
  {9266148.03422278,515.938082556907,0.000107126992977154,5.7255336067167e-12,2.19023881746289e-19,7.70891495174463e-27,2.65742004440177e-34,9.11315987403372e-42,3.12114009918147e-49,1.06860305734137e-56,3.65834180833601e-64,1.25240077565088e-71,4.28746088028922e-79,1.46776477817729e-86,5.02472866940209e-94,1.72015956326841e-101,5.88877342260507e-109,2.01595555385257e-116,6.90139779273996e-124,2.3626161493419e-131},
  {8098694.9950145,485.038221233396,0.000113890057066728,6.96527250656047e-12,3.05776221720199e-19,1.23596913866688e-26,4.8938946797054e-34,1.92780415196248e-41,7.58423117385375e-49,2.98277369763479e-56,1.17298935381174e-63,4.61274123013844e-71,1.81393586275109e-78,7.13319696344694e-86,2.8050872115503e-93,1.1030837485447e-100,4.33781070110046e-108,1.70581804064393e-115,6.70802712407945e-123,2.63789142871154e-130},
  {7078554.07248091,456.015381326342,0.00012108739648212,8.4739656539466e-12,4.26916008538374e-19,1.98174834058329e-26,9.01312798337972e-34,4.07833917414048e-41,1.84304682363795e-48,8.3262741255446e-56,3.76123413107625e-63,1.69903123739628e-70,7.67485522294192e-78,3.46687735442805e-85,1.56605362487623e-92,7.07415784882765e-100,3.19552967406595e-107,1.44348063278931e-114,6.52047249509132e-122,2.94541960456629e-129},
  {6187112.06886148,428.754373433839,0.000128747474997945,1.03100826619996e-11,5.96084846143793e-19,3.17772493972195e-26,1.66005846304392e-33,8.62840848648826e-41,4.47907260564107e-48,2.32438482930318e-55,1.20612853811093e-62,6.25850440692972e-70,3.24747176136886e-77,1.68507667564781e-84,8.74367118084533e-92,4.53699115982422e-99,2.35419287400908e-106,1.22156377784968e-113,6.33855483136906e-121,3.28900365798889e-128},
  {5408110.42639883,403.147133893479,0.000136900668956744,1.25448329784537e-11,8.32340565879144e-19,5.09578919495283e-26,3.05772612033758e-33,1.82559908523746e-40,1.08859714740005e-47,6.48922324916119e-55,3.86797959539852e-62,2.3055105674687e-69,1.37419362956024e-76,8.19083566040499e-84,4.88211899813585e-91,2.90996976065022e-98,1.73447714997834e-105,1.03382894560469e-112,6.16210070858677e-120,3.67289823842129e-127},
  {4727347.03489744,379.092281105453,0.000145579399717723,1.5264948589131e-11,1.16230958709529e-18,8.17211361621833e-26,5.63250489381821e-33,3.86285064610408e-40,2.64590396375328e-47,1.81177888594199e-54,1.24051651637776e-61,8.49359341153387e-69,5.81538234992762e-76,3.98166349153046e-83,2.72615597595157e-90,1.86653790729273e-97,1.27797665429755e-104,8.75001956723896e-112,5.9909421724399e-119,4.10186375322599e-126},
  {4132415.83937344,356.494699630825,0.000154818275618991,1.8576076172232e-11,1.62319541294563e-18,1.31064652256669e-25,1.03760681799935e-32,8.1740759661586e-40,6.43145458676695e-47,5.0587814626228e-54,3.97877309912279e-61,3.12927739810357e-68,2.46114308161798e-75,1.93566028400575e-82,1.52237374395904e-89,1.19732871573041e-96,9.4168467647225e-104,7.40623701814548e-111,5.82491656442354e-118,4.58122699684013e-125},
  {3612479.45184105,335.26515031817,0.000164654244167238,2.26069125758137e-11,2.26698414269629e-18,2.10215853514302e-25,1.91158124737906e-32,1.72980890559193e-39,1.56341057241962e-46,1.41258746936579e-53,1.27621693054179e-60,1.15298953621237e-67,1.04165561220034e-74,9.41071090544485e-82,8.50198974598257e-89,7.68101634175101e-96,6.93931805441028e-103,6.26923999291041e-110,5.66386635325749e-117,5.11694911895187e-124},
  {3158070.58027172,315.319904822052,0.000175126755225232,2.75142469927985e-11,3.1663237520674e-18,3.37189875473605e-25,3.52193944160602e-32,3.66089073367764e-39,3.80072161534783e-46,3.94469981396476e-53,4.09382251101985e-60,4.24850220256615e-67,4.40900541978309e-74,4.57556684472517e-81,4.7484191493605e-88,4.92780097367781e-95,5.11395924073719e-102,5.30715001171591e-109,5.50763897177425e-116,5.715701830114e-123},
  {2760918.61936422,296.580402980144,0.000186277936028635,3.34891092345618e-11,4.42274398013316e-18,5.40895346740671e-25,6.48934209486148e-32,7.74827574516967e-39,9.24035678715316e-46,1.10164643464285e-52,1.31329769260175e-59,1.56558262569181e-66,1.866322839099e-73,2.22483106555942e-80,2.65220556574566e-87,3.16167548947628e-94,3.76901091189079e-101,4.49301113800647e-108,5.35608665909645e-115,6.38495285464146e-122},
  {2413798.21182093,278.97293161253,0.000198152778929985,4.07642675043387e-11,6.1781496254514e-18,8.67725019271203e-25,1.19577539522048e-31,1.64003655726503e-38,2.24668186604722e-45,3.07680991739313e-52,4.21334976158336e-59,5.7696078799791e-66,7.90065447206951e-73,1.0818806057607e-79,1.48147892030402e-86,2.0286708353052e-93,2.7779708688547e-100,3.8040287162098e-107,5.20906630792812e-114,7.1330617660908e-121},
  {2110396.99392308,262.4283233974,0.000210799342839618,4.96233728172138e-11,8.63089222030278e-18,1.39213598037059e-24,2.20358204137019e-31,3.47162380918103e-38,5.46292311372331e-45,8.59388957618751e-52,1.35183134673133e-58,2.12641130352267e-65,3.34479908369084e-72,5.26129071865999e-79,8.27588485347305e-86,1.30177686145425e-92,2.04766378048618e-99,3.22092599987632e-106,5.06643931679791e-113,7.96938748191688e-120},
  {1845200.09283448,246.8816745622,0.000224268969411359,6.04121128716537e-11,1.20582458805473e-17,2.23363590625163e-24,4.06106579070477e-31,7.34924927286348e-38,1.32843340290717e-44,2.40054616447575e-51,4.33759204559149e-58,7.8375339855855e-65,1.41614653221443e-71,2.5588006660786e-78,4.62343326545887e-85,8.35396595092992e-92,1.50945719038787e-98,2.72740039026689e-105,4.92807144709348e-112,8.904408853052e-119},
  {1613389.25177896,232.272080208865,0.000238616515105608,7.35518183999806e-11,1.68478420785428e-17,3.58405633778385e-24,7.48484051837529e-31,1.55591197689985e-37,3.23062249193278e-44,6.70597733947268e-51,1.39189546881177e-57,2.88897196959925e-64,5.9962271577692e-71,1.2445499637462e-77,2.58313125075984e-84,5.36142925792627e-91,1.11279375266098e-97,2.30966384323412e-104,4.79383268473126e-111,9.94985996347186e-118},
  {1410754.72874344,218.542386166221,0.000253900600354501,8.95560630564049e-11,2.35416384300996e-17,5.75134663335934e-24,1.37961323236363e-30,3.29427116453785e-37,7.85714762265807e-44,1.87346841784867e-50,4.46680315003141e-57,1.06497520029366e-63,2.53910251935408e-70,6.0536944010554e-77,1.44331335167298e-83,3.44112726506603e-90,8.204286778145e-97,1.9560543990301e-103,4.66359710631574e-110,1.11188819569096e-116},
  {1233618.34963817,205.63895633243,0.000270183877153886,1.09050917712029e-10,3.28974249603919e-17,9.22990205921616e-24,2.54310908318138e-30,6.97535804039107e-37,1.91106937295431e-43,5.23435905682214e-50,1.4335731079756e-56,3.92616457607185e-63,1.07526431957617e-69,2.94483854810582e-76,8.06506039506535e-83,2.20878644516441e-89,6.04922621418647e-96,1.65670781403584e-102,4.5372427496396e-109,1.24261934356739e-115},
  {1078766.30224933,193.511454535709,0.00028753331651567,1.32799666477113e-10,4.59748711074181e-17,1.48135127010587e-23,4.6881990573429e-30,1.47709042075128e-36,4.6485917775708e-43,1.46256124683418e-49,4.60125492287563e-56,1.44754116725982e-62,4.55390169267206e-69,1.43263614187821e-75,4.50700496404292e-82,1.4178821657992e-88,4.46058927769679e-95,1.40327998328613e-101,4.41465148838746e-108,1.3888281733397e-114},
  {943390.436642585,182.112640002779,0.000306020517332417,1.61732970812531e-10,6.42559168452953e-17,2.37767790333077e-23,8.643330259881e-30,3.12810750371084e-36,1.13083795996634e-42,4.08694341717272e-49,1.47695327539599e-55,5.33737059525241e-62,1.92879503248957e-68,6.97018537522964e-75,2.51885089845351e-81,9.10249739059155e-88,3.28941492304678e-94,1.18871228695452e-100,4.29570891091083e-107,1.55236176532459e-113},
  {825036.994234107,171.398175581858,0.000325722038334862,1.9698568701132e-10,8.98132325099936e-17,3.81665236930857e-23,1.59364209247788e-29,6.62507622826493e-36,2.75114809177132e-42,1.14213597139583e-48,4.74123890041079e-55,1.96815100014829e-61,8.17002016121521e-68,3.39146528069299e-74,1.40783418388256e-80,5.8440726718546e-87,2.42593802683215e-93,1.00703321396334e-99,4.180304202937e-106,1.73528965899163e-112},
  {721561.824428933,161.32644792073,0.000346719754963289,2.39941810052128e-10,1.25545963671925e-16,6.12699365371889e-23,2.93856785270766e-29,1.40325092402409e-35,6.6936470218627e-42,3.19206879417479e-48,1.52213148631193e-54,7.25812961988271e-61,3.46095080090909e-67,1.65031052860438e-73,7.86929452232804e-80,3.7523721200843e-86,1.78927046815529e-92,8.53190646471358e-99,4.06833003409487e-105,1.93993093225782e-111},
  {631091.267062277,151.858398850769,0.000369101243126441,2.92289344281235e-10,1.75509669701192e-16,9.83667089447199e-23,5.41896747471802e-29,2.97245771556687e-35,1.62872415204056e-41,8.92200714748693e-48,4.88706811340002e-54,2.67686775297025e-60,1.46623510946553e-66,8.03118919461997e-73,4.39902049270649e-79,2.40952859601279e-85,1.31980016217487e-91,7.22910059589997e-98,3.95968244812903e-104,2.16888461821813e-110},
  {551987.983068899,142.957367274929,0.000392960191988216,3.56087301963746e-10,2.45378140581539e-16,1.57937550855375e-22,9.99387508573843e-29,6.29698394950289e-35,3.96340834078534e-41,2.49395977254028e-47,1.56921036215881e-53,9.87337574711447e-60,6.21224187222052e-66,3.90868431816753e-72,2.45930687210443e-78,1.54737231400397e-84,9.73591814182718e-91,6.12574626167862e-97,3.85426075668734e-103,2.42506387665788e-109},
  {482821.106774289,134.588940901901,0.00041839684810399,4.33847520872679e-10,3.43089874058009e-16,2.53606209583039e-22,1.84326815665132e-28,1.33409488680077e-34,9.64555749517363e-41,6.97193860366686e-47,5.03907909536308e-53,3.64201430214346e-59,2.63226937599277e-65,1.9024732919166e-71,1.37501265199214e-77,9.93790388326983e-84,7.1826198735151e-90,5.19123837843851e-96,3.75196743657076e-102,2.71173439078046e-108},
  {422340.172627511,126.72081721001,0.000445518493426583,5.286345918783e-10,4.79753150212347e-16,4.07260501896116e-22,3.40001673071255e-28,2.82669391602005e-34,2.34759826961393e-40,1.94919637690478e-46,1.61830030070076e-52,1.34355534299643e-58,1.11545033288747e-64,9.26071400773813e-71,7.68844650257549e-77,6.38311536373265e-83,5.29940100187734e-89,4.39967778533131e-95,3.65270803032956e-101,3.0325575195533e-107},
  {369452.338544858,119.322673063183,0.000474439959918288,6.44187921628721e-10,6.70913287320662e-16,6.5406866683834e-22,6.27208934732243e-28,5.98976106606924e-34,5.71424527088653e-40,5.44999730134431e-46,5.19763411976633e-52,4.95687679041312e-58,4.72725243235967e-64,4.50826074533376e-70,4.29941284531563e-76,4.10023969223281e-82,3.91029330610262e-88,3.72914630053549e-94,3.55639105010797e-100,3.391638803863e-106},
  {323202.488585737,112.366042437663,0.000505284183741707,7.85070854128424e-10,9.38327215546511e-16,1.05054287117429e-21,1.15713174010129e-27,1.26934478213897e-33,1.39101996650494e-39,1.52396982716338e-45,1.66952022326072e-51,1.82894260726182e-57,2.00358024110551e-63,2.19489106303634e-69,2.40446850091366e-75,2.63405711075278e-81,2.88556774691493e-87,3.16109364358256e-93,3.46292788462867e-99,3.79358250128632e-105},
  {282755.850553985,105.824201752155,0.000538182802260567,9.5685287543155e-10,1.31244875295616e-15,1.68750224198422e-21,2.13497859401234e-27,2.69023275077669e-33,3.38647598569243e-39,4.26183469018043e-45,5.36312369702278e-51,6.74888737877026e-57,8.49268148824709e-63,1.06870308760398e-68,1.34483556189186e-74,1.69231529143388e-80,2.12957708933663e-86,2.67981893499893e-92,3.37223270922108e-98,4.24355291093932e-104},
  {247382.810284299,99.6720623259637,0.000573276797364228,1.16633227329756e-09,1.83590963080606e-15,2.7109147637085e-21,3.93953691953221e-27,5.70218156180126e-33,8.24524509175133e-39,1.19194925004092e-44,1.72299840955198e-50,2.49060707592583e-56,3.60017710702873e-62,5.20405755602949e-68,7.52246560215005e-74,1.08737239509978e-79,1.57179676206888e-85,2.27203216026103e-91,3.28422239880024e-97,4.7473433478935e-103},
  {216445.644685711,93.886069519576,0.0006107171889389,1.4218082743772e-09,2.56839582059616e-15,4.35541054751569e-21,7.2700694863094e-27,1.20874298313502e-32,2.00770951840473e-38,3.33396217500819e-44,5.53596936702625e-50,9.19221118138915e-56,1.52631662409854e-61,2.53436321949435e-67,4.20816708655228e-73,6.9874235175662e-79,1.16022215075134e-84,1.92648324614022e-90,3.19881644369873e-96,5.31145373756635e-102},
  {189386.930814901,88.4441081400943,0.000650665782647249,1.73341370388649e-09,3.59347929636497e-15,6.99817656279004e-21,1.34175899586171e-26,2.56253295271563e-32,4.88923323191246e-38,9.32623040892955e-44,1.77887343226801e-49,3.39294904700121e-55,6.47154494575368e-61,1.23434963239549e-66,2.35433527065788e-72,4.4905382487904e-78,8.56502203191778e-84,1.63364830828506e-89,3.11593686827019e-95,5.94317792608593e-101},
  {165719.418990557,83.3254137201759,0.000693295976549201,2.11352169098639e-09,5.02819059598203e-15,1.12456382277423e-20,2.47658872429248e-26,5.43310846106076e-32,1.19075950133482e-37,2.6091259048085e-43,5.71662682861526e-49,1.25250107100567e-54,2.74419350892921e-60,6.01244270134845e-66,1.31730720187111e-71,2.88617829418628e-77,6.32352499965836e-83,1.3854642436594e-88,3.0355081521733e-94,6.65070194482571e-100},
  {145017.184801848,78.5104893036777,0.000738793631503681,2.5772429806295e-09,7.03643350082141e-15,1.80728904892295e-20,4.57169837257042e-26,1.152050707105e-31,2.90035835262645e-37,7.30009038088451e-43,1.83729520553538e-48,4.62405699433714e-54,1.16376635673949e-59,2.92892339795261e-65,7.37140253720915e-71,1.8552063274305e-76,4.66911208539631e-82,1.17510420616777e-87,2.95745715425623e-93,7.44321462842672e-99},
  {126907.89830398,73.9810273942341,0.000787358010737569,3.1430341365004e-09,9.84778644907745e-15,2.90480062654502e-20,8.44007793682727e-26,2.44309315097698e-31,7.06520027121172e-37,2.04270969142547e-42,5.90558945405754e-48,1.70731424104849e-53,4.93585138997888e-59,1.42695503535176e-64,4.12532721053258e-70,1.19263208677631e-75,3.44789928501125e-81,9.96787657205742e-87,2.88171303896383e-92,8.33103216822337e-98},
  {111066.069163225,69.7198367445647,0.000839202794458364,3.83344148597086e-09,1.37838573565202e-14,4.66929358375555e-20,1.55833738749828e-25,5.18148928918408e-31,1.72124797034241e-36,5.71651318287053e-42,1.89842616363607e-47,6.30448905477579e-53,2.09365201958527e-58,6.95278357423475e-64,2.30894093152917e-69,7.66773172999444e-75,2.54636696180522e-80,8.45619657738511e-86,2.80820720518637e-91,9.32573838999971e-97},
  {97207.1443895179,65.7107736845072,0.000894557175925807,4.67601125860124e-09,1.92952315713435e-14,7.50642477443487e-20,2.8775550059985e-25,1.09904707657521e-30,4.19381740621903e-36,1.59993699992749e-41,6.10339224455832e-47,2.32827052358416e-52,8.88165783626405e-58,3.38808460057986e-63,1.2924518028906e-68,4.93031245069428e-74,1.8807649512322e-79,7.17454892513938e-85,2.73687321748238e-90,1.04403427798555e-95},
  {85082.3509056941,61.9386777047194,0.000953667045989967,5.70440324057288e-09,2.7013278218061e-14,1.20687750071042e-19,5.31415091525797e-25,2.33144993231456e-30,1.02193600948907e-35,4.47839774569161e-41,1.9624425891287e-46,8.59933945299723e-52,3.76818037796148e-57,1.65119319218112e-62,7.23542420916096e-68,3.17051698318698e-73,1.38930040737446e-78,6.08782613522161e-84,2.66764673959994e-89,1.16894585484044e-94},
  {74474.188835881,58.3893110307256,0.00101679627375503,6.9597536987119e-09,3.78228007919426e-14,1.94062834744728e-19,9.81506693992349e-25,4.94635207869282e-30,2.4905027288542e-35,1.25369408854189e-40,6.31061629217864e-46,3.1764782109329e-51,1.59888955138902e-56,8.04805003299283e-62,4.0510049668958e-67,2.03908279342573e-72,1.0263770633422e-77,5.16629278587867e-83,2.60046547023035e-88,1.30895033260553e-93},
  {65192.4933021623,55.0493019386169,0.00108422809174577,8.49234367646821e-09,5.29639339779915e-14,3.12084167218684e-19,1.81302102631861e-24,1.04952829856477e-29,6.07016556028426e-35,3.51002887128998e-40,2.02953611273276e-45,1.17348316531978e-50,6.78508730653263e-56,3.92313850513178e-61,2.2683587851892e-66,1.31156503734537e-71,7.58346887253577e-77,4.38476158701809e-82,2.53526908093044e-87,1.46589254257146e-92},
  {57070.9929174019,51.906091579292,0.00115626659474432,1.0363641469719e-08,7.41750820455517e-14,5.01940664795278e-19,3.34937444859461e-24,2.22717615933944e-29,1.47967160690712e-34,9.82836075197649e-40,6.52789382470351e-45,4.33569911977583e-50,2.8796765230062e-55,1.91261652634377e-60,1.27031670605942e-65,8.4371562478287e-71,5.6037682776339e-76,3.72189608467413e-81,2.47199915614635e-86,1.6418458999637e-91},
  {49964.3022441025,48.947884092722,0.00123323836233736,1.26488036935019e-08,1.03893460987814e-13,8.0739384898824e-19,6.18838012288947e-24,4.72680193450844e-29,3.60730251166582e-34,2.75235158154387e-39,2.09991541118801e-44,1.6021155254228e-49,1.22231851801176e-54,9.32555283975714e-60,7.11483268394883e-65,5.42818665239174e-70,4.14137777423685e-75,3.15962049773179e-80,2.41059913528417e-85,1.83914118610359e-90},
  {43745.2934213604,46.1635998074088,0.00131549421617608,1.54397385179282e-08,1.45536504013703e-13,1.29888908964332e-18,1.14352021783056e-23,1.00330696576271e-28,8.79535505405335e-34,7.70868532144665e-39,6.75591392328701e-44,5.92082342937888e-49,5.18894019087011e-54,4.54752251919736e-59,3.98539123512602e-64,3.49274630375005e-69,3.06099849773044e-74,2.68262019562139e-79,2.35101425676548e-84,2.06039902458507e-89},
  {38302.7990900167,43.5428313330225,0.00140341112401465,1.88488582033132e-08,2.03896801845098e-13,2.08984215549518e-18,2.11332117606181e-23,2.12987955513283e-28,2.14476138828929e-33,2.15929272167113e-38,2.17380813389287e-43,2.18839233810491e-48,2.20306714412631e-53,2.21783853243301e-58,2.23270850284239e-63,2.24767805664619e-68,2.26274794716956e-73,2.27791886869151e-78,2.29319150401431e-83,2.30856653645822e-88},
  {33539.6047972688,41.0758023662213,0.00149739426376852,2.3013677012516e-08,2.85696478337357e-13,3.36287661753151e-18,3.90609860422197e-23,4.52201818253331e-28,5.23070987124904e-33,6.04921147216297e-38,6.9954290185813e-43,8.08954889552848e-48,9.35476420521262e-53,1.08178519560491e-57,1.25097645052384e-62,1.44662915223625e-67,1.67288191292252e-72,1.93452059319353e-77,2.23707955332432e-82,2.5869587248224e-87},
  {29370.6943473936,38.7533290409139,0.00159787926213386,2.81024461697e-08,4.00365500284222e-13,5.4120986424242e-18,7.2206821881114e-23,9.60211485754705e-28,1.2758499903345e-32,1.69489713981084e-37,2.25146309462016e-42,2.99075444329657e-47,3.97278708463267e-52,5.2772719682146e-57,7.01008970797201e-62,9.31188605619839e-67,1.23694880452969e-71,1.64310681102602e-76,2.18262872355206e-81,2.89930521374254e-86},
  {25721.7161818297,36.5667836647778,0.00170533462374971,3.43210613074565e-08,5.61134572734484e-13,8.71122297487261e-18,1.33497128441875e-22,2.0392015695772e-27,3.11241332409856e-32,4.7494858166361e-37,7.24726229007388e-42,1.10584912218085e-46,1.68739362536158e-51,2.5747590170968e-56,3.92877073135534e-61,5.99482848507374e-66,9.14738236957597e-71,1.39577978194882e-75,2.1297909275933e-80,3.24980305134605e-85},
  {22527.6429044145,34.5080606937359,0.00182026436848012,4.19215316964359e-08,7.8657005413335e-13,1.40233765193367e-17,2.46845756058252e-22,4.33125213948318e-27,7.5937267776343e-32,1.3310975793297e-36,2.33315277119613e-41,4.0895078745178e-46,7.16799292830705e-51,1.25638791238025e-55,2.20216495031747e-60,3.85989882949669e-65,6.7655326139527e-70,1.18584536624236e-74,2.07851962559318e-79,3.64317638381841e-84},
  {19731.5995900185,32.5695448053604,0.00194321089616356,5.12123668263037e-08,1.10273007198426e-12,2.25781070161685e-17,4.56500106725103e-22,9.20085647574069e-27,1.85299458019021e-31,3.73108096105603e-36,7.5123161161989e-41,1.5125428981544e-45,3.04537103698924e-50,6.13157989967041e-55,1.23453807080844e-59,2.48563045752035e-64,5.00459146892206e-69,1.00762909546379e-73,2.02876977984883e-78,4.08474391756407e-83},
  {17283.8395917606,30.7440809408595,0.00207475810014208,6.25713174974082e-08,1.5461938336736e-12,3.63567796861242e-17,8.44343298382047e-22,1.95481654995988e-26,4.52226796694169e-31,1.04597767289881e-35,2.41917616395389e-40,5.59509306834988e-45,1.29403439555521e-49,2.99284342332131e-54,6.92184851664533e-59,1.60088510635645e-63,3.70252698723036e-68,8.56320419010708e-73,1.98049781136398e-77,4.58049521302323e-82},
  {15140.8492498443,29.0249461934434,0.00221553475306606,7.64610090639211e-08,2.16831861053889e-12,5.85528141467558e-17,1.56193059310198e-21,4.15382555851971e-26,1.1038318812229e-30,2.93274735979664e-35,7.79158175029468e-40,2.07000514994979e-44,5.49940778252397e-49,1.46103324391203e-53,3.88154111502345e-58,1.03121272481378e-62,2.73963263535653e-67,7.2784080085794e-72,1.93366155801601e-76,5.13717699785498e-81},
  {13264.5652530605,27.4058234284951,0.00236621819089921,9.34481282602937e-08,3.04122315137415e-12,9.43140099750631e-17,2.88981796007231e-21,8.82788338710156e-26,2.69473250418381e-30,8.22418702395448e-35,2.50986207332438e-39,7.65952123017953e-44,2.33750266726724e-48,7.13349377511334e-53,2.17696966926534e-57,6.64358429753453e-62,2.02746103606542e-66,6.18732006227627e-71,1.88822023430094e-75,5.76239085209333e-80},
  {11621.6904551907,25.8807765281232,0.00252753832375155,1.14226977608369e-07,4.26619945087483e-12,1.51940086452357e-16,5.34745295989116e-21,1.87643124734972e-25,6.57954898318798e-30,2.3066358604823e-34,8.0861504306843e-39,2.83465075391546e-43,9.93701722286841e-48,3.48347109809277e-52,1.22114799855239e-56,4.28079442846181e-61,1.50065354510821e-65,5.26061480808256e-70,1.84413439262167e-74,6.46470380652732e-79},
  {10183.0957404756,24.4442271593761,0.00270028200518046,1.39648399503847e-07,5.98554097241996e-12,2.44814963529429e-16,9.89675689764078e-21,3.98912982599587e-25,1.60674158555526e-29,6.47045092294234e-34,2.60557286847822e-38,1.04922091643273e-42,4.22502629654002e-47,1.70134184198329e-51,6.85099533979925e-56,2.75877157041873e-60,1.11090726462233e-64,4.47342201283716e-69,1.80136588608874e-73,7.25377361153741e-78},
  {8923.29709778483,23.0909329716793,0.00288529779495939,1.70755304088145e-07,8.39917862382308e-12,3.94525204682675e-16,1.83193495154189e-20,8.48193430531945e-25,3.92434485409664e-29,1.81535378897933e-33,8.39722617334809e-38,3.88423539358559e-42,1.7966935583331e-46,8.31078744314822e-51,3.84423795965035e-55,1.77819068798091e-59,8.22519865128859e-64,3.80464778747784e-68,1.75987783280541e-72,8.1404906810613e-77},
  {7819.99843080212,21.8159671349468,0.00308350115406416,2.08826321291908e-07,1.17880840233991e-11,6.35893805013258e-16,3.39156584286473e-20,1.80378470146595e-24,9.58652824310868e-29,5.09402493446232e-33,2.70670883292776e-37,1.43819311325825e-41,7.64172961563208e-46,4.06037204355479e-50,2.15744590672185e-54,1.14634141629521e-58,6.09099224415723e-63,3.23639937375599e-67,1.71963458160965e-71,9.13713900004938e-76},
  {6853.69182643037,20.6146991353352,0.00329588011481731,2.5542945083689e-07,1.65472006576688e-11,1.02510745293031e-15,6.28008362011359e-20,3.83662601074198e-24,2.3422352976755e-28,1.4296700875808e-32,8.72614054443352e-37,5.32603286821868e-41,3.25075543598131e-45,1.98410411023934e-49,1.21100111260074e-53,7.3913643175605e-58,4.51133077623772e-62,2.75349779067364e-66,1.68060167925067e-70,1.02575786092764e-74},
  {6007.30804759122,19.4827767507858,0.00352350147381858,3.12488020433281e-07,2.32317931531925e-11,1.65284119994307e-15,1.16307455702152e-19,8.16189856168202e-24,5.72369714837524e-28,4.0131699765794e-32,2.81371319000738e-36,1.97272904706283e-40,1.38310097476928e-44,9.69705914061042e-49,6.79870392182177e-53,4.76663825695713e-57,3.34193697738868e-61,2.34306488756202e-65,1.64274583897781e-69,1.15174526551208e-73},
  {5265.91092871834,18.416109133347,0.00376751756053744,3.82361801673737e-07,3.26226983108202e-11,2.66545818041533e-15,2.15441171781088e-19,1.73664856094501e-23,1.39894871520084e-27,1.12672596129962e-31,9.07436976919216e-36,7.30819386243784e-40,5.88575933664336e-44,4.74017804774345e-48,3.81756761250178e-52,3.07453047719621e-56,2.47611529572263e-60,1.99417341522113e-64,1.6060349105239e-68,1.29344224214325e-72},
  {4616.43014920223,17.4108509298158,0.00402917364032509,4.67946799738032e-07,4.5818209924859e-11,4.29926053816293e-15,3.99145293157439e-19,3.69584590042283e-23,3.41985827325305e-27,3.16395439622123e-31,2.92707793186913e-35,2.70790763397455e-39,2.50514160927634e-43,2.31755704343664e-47,2.14401842927701e-51,1.98347430181407e-55,1.83495170206797e-59,1.69755047358453e-63,1.57043785146677e-67,1.45284342545708e-71},
  {4047.42755638969,16.4633873765017,0.00430981601720164,5.72798057460761e-07,6.4363502976177e-11,6.93583947433775e-15,7.39633740250913e-19,7.86681912616112e-23,8.36176234022193e-27,8.88639321255422e-31,9.44355460631651e-35,1.00355465842909e-38,1.0664621783906e-42,1.13331231398543e-46,1.20435269262264e-50,1.27984610462468e-54,1.36007171754941e-58,1.44532617287546e-62,1.53592469995694e-66,1.63220228612962e-70},
  {3548.89281819591,15.5703203079055,0.0046109009091837,7.01280834461301e-07,9.04329837742766e-11,1.11915437717716e-14,1.37084429180033e-18,1.67482791397442e-22,2.04490552215945e-26,2.49635620119408e-30,3.04735060093484e-34,3.71992284823589e-38,4.54092524404091e-42,5.54312279498477e-46,6.7665076718542e-50,8.25989716832715e-54,1.00828823185018e-57,1.23082059652568e-61,1.5024665488001e-65,1.83406561142189e-69},
  {3112.06471705469,14.728455022857,0.00493400417724661,8.58756785009727e-07,1.27087281862061e-10,1.80621344471726e-14,2.54125160786035e-18,3.56639420173549e-22,5.00192073930302e-26,7.01416070998336e-30,9.8355235051708e-34,1.37916098940507e-37,1.93388825960687e-41,2.71173671770505e-45,3.80245076522358e-49,5.33187133188326e-53,7.47645489216249e-57,1.04836321322409e-60,1.47003552088823e-64,2.0613127254837e-68},
  {2729.27486151916,13.934787955161,0.00528083199838827,1.05181332275254e-06,1.78635542562261e-10,2.91567265334887e-14,4.71191927807989e-18,7.5958982873319e-22,1.22374521221951e-25,1.97122188817673e-29,3.17514220372979e-33,5.1143051673579e-37,8.23775827359801e-41,1.32687858937824e-44,2.13723984828376e-48,3.44251089187531e-52,5.54494673960535e-56,8.93139781920828e-60,1.43860474597526e-63,2.31720012559006e-67},
  {2393.81099780356,13.1864950990957,0.00565323258381855,1.28854629939774e-06,2.51146320111398e-10,4.70762316545743e-14,8.73858811478569e-18,1.61816272740236e-21,2.99459754355017e-25,5.54100538105521e-29,1.0252319671912e-32,1.89693116360817e-36,3.50978060495555e-40,6.49393757692686e-44,1.20153433292949e-47,2.22312685086793e-51,4.11331812470537e-55,7.61062552462697e-59,1.40814833879622e-62,2.60541231118273e-66},
  {2099.79745833118,12.480921143192,0.00605320905520242,1.57890852901519e-06,3.53168246451193e-10,7.60257263087892e-14,1.62099126734643e-17,3.44795213542249e-21,7.32962752882637e-25,1.5578929590808e-28,3.311136475047e-32,7.03740406987321e-36,1.49570821545385e-39,3.17893037870373e-43,6.75639591460546e-47,1.43598250510656e-50,3.05199067995258e-54,6.48660206940631e-58,1.3786413785336e-61,2.93011969903038e-65},
  {1842.09059439037,11.8155692686144,0.00648293360532159,1.93513967332844e-06,4.96746937219543e-10,1.22805625546758e-13,3.00759183651322e-17,7.34850653472041e-21,1.79442028432031e-24,4.38112334332693e-28,1.0696232803848e-31,2.61139295091589e-35,6.37547594770356e-39,1.55651298016041e-42,3.80008069961991e-46,9.27754088142688e-50,2.26502463602161e-53,5.52984530691737e-57,1.35005988963621e-60,3.29604465258603e-64},
  {1616.1873109489,11.1880915711778,0.00694476308470122,2.37229670805899e-06,6.98860382005918e-10,1.98416461979753e-13,5.58160238759567e-17,1.56653002222238e-20,4.39408260343756e-24,1.23235300611364e-27,3.45610075718179e-31,9.69245403540869e-35,2.71819198303187e-38,7.62300597004959e-42,2.13782588590797e-45,5.99540309377608e-49,1.68137443641488e-52,4.71531262368024e-56,1.32238082400164e-59,3.70853680976536e-63},
  {1418.14505847224,10.5962800685777,0.00744125617292091,2.90890879319609e-06,9.83445731489346e-10,3.20657927944842e-13,1.03610496860987e-16,3.34028272696924e-20,1.07625983399558e-23,3.46728584517338e-27,1.11698364156406e-30,3.59832297784376e-34,1.15918435801998e-37,3.73426077143602e-41,1.20297530652629e-44,3.87533069259313e-48,1.24842029307709e-51,4.02172962370367e-55,1.29558204453627e-58,4.17365907445739e-62},
  {1244.5118435439,10.0380582567919,0.00797519231277166,3.56778609254559e-06,1.38426215882279e-09,5.18339518593006e-13,1.92378572562813e-16,7.12419535123741e-20,2.63678146111725e-23,9.75780764889252e-27,3.61089881667564e-30,1.33620970750102e-33,4.94462073289042e-37,1.82974729313096e-40,6.77094338346733e-44,2.50557401684493e-47,9.27182631020535e-51,3.4310206909408e-54,1.26964231011122e-57,4.69828584732156e-61},
  {1092.26500096299,9.51147318185261,0.00854959260745889,4.37701920732183e-06,1.94893616991469e-09,8.38104313907599e-13,3.57290179212869e-16,1.51984695186185e-19,6.46163745273226e-23,2.7467953662708e-26,1.16760318837771e-29,4.96318598992709e-33,2.10972041847359e-36,8.96786437325587e-40,3.81200181983064e-43,1.62038103917732e-46,6.88781069487195e-50,2.92782592013764e-53,1.24454126193808e-56,5.29021531578256e-60},
  {958.757628084972,9.01468799527949,0.00916774290605444,5.37121475220258e-06,2.7446799204556e-09,1.35549135099425e-12,6.63743688430845e-16,3.24323818437297e-19,1.5838935483814e-22,7.73419845932289e-26,3.7765059923429e-29,1.84400218146167e-32,9.00392314543872e-36,4.39644761053808e-39,2.14670302787253e-42,1.04819484918574e-45,5.11813892590371e-49,2.4990912741063e-52,1.22025941139131e-55,5.95829790743629e-59},
  {841.671720351661,8.54597496343117,0.00983321933080031,6.59302364563374e-06,3.86637761694464e-09,2.19287563985624e-12,1.23338406544713e-15,6.92271483609939e-19,3.88354198014623e-22,2.17832627351743e-25,1.22181005867613e-28,6.85300301572316e-32,3.84376886609554e-35,2.15592369297544e-38,1.20923149646005e-41,6.78243283953038e-45,3.80418430972526e-48,2.13372083085227e-51,1.19677812931121e-54,6.71258334225199e-58},
  {738.977167736874,8.103708902876,0.0105499165321543,8.09503245574699e-06,5.44802533203523e-09,3.54857225425892e-12,2.29254931594585e-15,1.47807499972348e-18,9.52472513143133e-22,6.13695559579843e-25,3.95402715673673e-28,2.54755077680087e-31,1.64136505785247e-34,1.05751686443569e-37,6.81348596872451e-41,4.38986754350005e-44,2.82835203415052e-47,1.82228168258586e-50,1.17407963682567e-53,7.56448910513533e-57},
  {648.895877408961,7.68636101560975,0.0113220789942164,9.9421053255612e-06,7.67892170918073e-09,5.74406953472941e-12,4.26251043870849e-15,3.15676987202983e-18,2.33670196215603e-21,1.72945575987652e-24,1.27997658298349e-27,9.47307989237087e-31,7.01099290682639e-34,5.18880850854956e-37,3.84021647302499e-40,2.84212880192317e-43,2.10344810555791e-46,1.55675348750747e-49,1.15214699773575e-52,8.52699361129228e-56},
  {569.870380198403,7.29249309956893,0.0121543357550399,1.22142854594476e-05,1.08265925783447e-08,9.30071377062157e-12,7.92761971961873e-15,6.74403735550499e-18,5.73435782299996e-21,4.87524592583048e-24,4.14471808296442e-27,3.5236287596225e-30,2.99560444758977e-33,2.5467046428738e-36,2.16507348595132e-39,1.84063082179747e-42,1.56480683859441e-45,1.33031589417469e-48,1.1309641125152e-51,9.61485786382872e-55},
  {500.536359132304,6.92075211140785,0.0130517389540798,1.50103919738053e-05,1.52692648841048e-08,1.50642591878221e-11,1.47487462813946e-14,1.44122557760201e-17,1.40767114102402e-20,1.37473361180453e-23,1.34252666301432e-26,1.31106445858779e-29,1.28033718227393e-32,1.25032947412849e-35,1.22102492457961e-38,1.1924071645067e-41,1.16446012441986e-44,1.137168090945e-47,1.11051571398223e-50,1.08448800197697e-53},
  {439.698608821979,6.56986505993209,0.0140198066735368,1.84524814677938e-05,2.15418892908708e-08,2.44072438737519e-11,2.74477591994878e-14,3.0809415432501e-17,3.45666371220192e-20,3.87775244520633e-23,4.3500109453614e-26,4.87974860874808e-29,5.47398692321013e-32,6.1405866505826e-35,6.88836137930652e-38,7.72719673851646e-41,8.66818183922216e-44,9.72375607953572e-47,1.09078736470839e-49,1.22361880033066e-52},
  {386.309996143718,6.23863420991796,0.0150645706026441,2.26913856820973e-05,3.04013959145928e-08,3.95579630537667e-11,5.10978867924837e-14,6.58838877982342e-17,8.49097025454794e-20,1.09417270259e-22,1.40994459205204e-25,1.81683346150306e-28,2.34114018497616e-31,3.01675141911163e-34,3.88733155290504e-37,5.00914529636264e-40,6.4546941993183e-43,8.31740240484602e-46,1.07176545623709e-48,1.38105761528247e-51},
  {339.453046553709,5.92593257729966,0.016192629125198,2.7913589266374e-05,4.29192674667398e-08,6.41354716075237e-11,9.5158637406553e-14,1.40936739177675e-16,2.08644408450265e-19,3.08845241031177e-22,4.57154485289082e-25,6.76677963411337e-28,1.00161386159347e-30,1.48258099943247e-33,2.19450455420052e-36,3.24828802561652e-39,4.80808982849627e-42,7.11689590864272e-45,1.05343721019409e-47,1.5592892884045e-50},
  {298.323827502711,5.63069969788235,0.0174112065122147,3.43497777271372e-05,6.06129341132934e-08,1.0402004959742e-10,1.77275174501832e-13,3.01594669468701e-16,5.12873932224489e-19,8.72068092760922e-22,1.48278563321904e-24,2.52117732532713e-27,4.28674527917197e-30,7.28872860452731e-33,1.23929824547549e-35,2.1071714750613e-38,3.58281116920251e-41,6.09183258448593e-44,1.03579068137943e-46,1.76114875227127e-49},
  {262.217841617516,5.35193765284027,0.0187282189951047,4.228546856817e-05,8.56323715698215e-08,1.68770154817336e-10,3.30375245860929e-13,6.45628933943985e-16,1.26117218956905e-18,2.46331394125604e-21,4.81120252705814e-24,9.39690068066665e-27,1.83533317713384e-29,3.58463560618985e-32,7.00124165984364e-35,1.3674300234804e-37,2.67076177036807e-40,5.21633158556161e-43,1.01881476294228e-45,1.98987258393867e-48},
  {230.517678340489,5.08870733529375,0.0201523486020365,5.20742428891055e-05,1.21025244196888e-07,2.73930098433949e-10,6.15931811216551e-13,1.38263605523074e-15,3.10244232678746e-18,6.96072866974759e-21,1.56168874699743e-23,3.50373662949479e-26,7.86081770987049e-29,1.76361515360859e-31,3.95676151152724e-34,8.87719819844843e-37,1.99164511503233e-39,4.46835833706492e-42,1.00249919374957e-44,2.24915854449959e-47},
  {202.682204217074,4.84012494322802,0.0216931257633473,6.4154225887753e-05,1.71113875085609e-07,4.44790306425778e-10,1.14875991746846e-12,2.96213116937184e-15,7.63492133558816e-18,1.96771032695272e-20,5.0711545027676e-23,1.30692236423072e-25,3.36815488628047e-28,8.68028827971233e-31,2.23705262263358e-33,5.76525128230878e-36,1.48579974417329e-38,3.82914944778123e-41,9.86834568071331e-44,2.54323441257014e-46},
  {178.237099563709,4.60535868492599,0.0233610218334696,7.90686299492835e-05,2.42031532024122e-07,7.22517786640016e-10,2.14340200389974e-12,6.34860675302608e-15,1.87967667507852e-17,5.56474619228479e-20,1.64739195378757e-22,4.876922594952e-25,1.44375705856771e-27,4.27407572390182e-30,1.2652905444703e-32,3.7457458105115e-35,1.10888456840573e-37,3.28272404593205e-40,9.71812347718877e-43,2.87693764652873e-45},
  {156.766573332819,4.38362568394061,0.0251675528397515,9.74913823715417e-05,3.42485839268716e-07,1.17415636172797e-09,4.00094156989816e-12,1.36124657118599e-14,4.62962668526391e-17,1.57439532952199e-19,5.3539125651279e-22,1.82064876773633e-24,6.19127967329574e-27,2.10539948256512e-29,7.15959672782018e-32,2.43468398932621e-34,8.27935750961735e-37,2.81546849500708e-39,9.57424876784247e-42,3.25580767899796e-44},
  {137.906109052542,4.17418907143187,0.027125395956167,0.000120259122824116,4.84846215322461e-07,1.90894879971679e-09,7.47156872063025e-12,2.92002248152878e-14,1.14077454223235e-16,4.45628802731339e-19,1.74075093589581e-21,6.79982145397781e-24,2.65618153579703e-26,1.03757103745365e-28,4.05301198715583e-31,1.58320781940682e-33,6.18440555620248e-36,2.41578342152876e-38,9.43665399145724e-41,3.68619296552143e-43},
  {121.336113136695,3.97635525444433,0.0292485204161553,0.000148411188104136,6.86693916026276e-07,3.10499332321315e-09,1.39591665421098e-11,6.26662510033738e-14,2.81223620611188e-16,1.26191714508197e-18,5.66239455583696e-21,2.54077948885854e-23,1.14007444748785e-25,5.11563201434566e-28,2.29543681702443e-30,1.02998613867292e-32,4.62165384893326e-35,2.07378366252438e-37,9.30528078919431e-40,4.17537528735877e-42},
  {106.776352967661,3.7894713494049,0.0315523348283064,0.000183239622451108,9.73033030466512e-07,5.05280475536676e-09,2.60923204523057e-11,1.34550950647361e-13,6.93600362909261e-16,3.57514756155748e-18,1.84276163258317e-20,9.49821472811793e-23,4.89569342407156e-25,2.52340114666218e-27,1.30064369906799e-29,6.7039439929663e-32,3.45543247960753e-34,1.7810431617213e-36,9.18008024054642e-39,4.7317142575261e-41},
  {93.9810862417193,3.61292277078083,0.0340538531466753,0.00022635178467915,1.37944656323931e-06,8.22654652796176e-09,4.87954337990676e-11,2.89036779319949e-13,1.71151265482305e-15,1.01337547596904e-17,6.0000032125429e-20,3.55246886409781e-22,2.10333526607291e-24,1.24533611671384e-26,7.37334623024519e-29,4.3655871518434e-31,2.58476280467951e-33,1.53037804892105e-35,9.06101313290218e-38,5.36481551378022e-40},
  {82.7347953868134,3.44613096545753,0.0367718818804198,0.000279748799490534,1.95660498214037e-06,1.34005885550872e-08,9.12992081404768e-11,6.21213399149928e-13,4.22544340011615e-15,2.87387702606476e-17,1.95458776994629e-19,1.32935186604131e-21,9.04116023151558e-24,6.14905310317024e-26,4.18207951989828e-28,2.84430602036816e-30,1.93446266589489e-32,1.3156621595093e-34,8.94805026709012e-37,6.08572671923456e-39},
  {72.8484516387693,3.28855128397682,0.0397272315125271,0.000345923959060675,2.77671184458933e-06,2.18403649115757e-08,1.70916747766251e-10,1.33585192856447e-12,1.04374466742669e-14,8.15447075212605e-17,6.37072237301733e-19,4.97713507620284e-21,3.88838838419975e-23,3.03780373881166e-25,2.37328423220747e-27,1.8541283183771e-29,1.44853775106903e-31,1.13167011847911e-33,8.84117280150948e-36,6.9071662513534e-38},
  {64.1562427875292,3.13967098032147,0.042942955543169,0.000427986273067311,3.94272624514647e-06,3.56151190626427e-08,3.20140639166893e-10,2.874183076462e-12,2.57961476948569e-14,2.31505857363375e-16,2.07759450499106e-18,1.86447906429479e-20,1.67322256979585e-22,1.50158453542948e-24,1.34755291311437e-26,1.20932173767526e-28,1.0852702288255e-30,9.73943849269741e-33,8.74037263769301e-35,7.84379036814358e-37},
  {56.5127068496457,2.99900733244329,0.0464446210896986,0.000529815756016334,5.60156946592479e-06,5.81107612548278e-08,5.99991004982537e-10,6.18754401286457e-12,6.37915585313019e-14,6.57621437547333e-16,6.77923472081797e-18,6.98849034702971e-20,7.20419676096624e-22,7.42655901054519e-24,7.6557840628663e-26,7.89208413672047e-28,8.13567770826405e-30,8.38678992155993e-32,8.6456528504147e-34,8.91250572670859e-36},
  {49.7902211353474,2.86610587621211,0.0502606155741694,0.000656258814005239,7.96305354439165e-06,9.48715342042999e-08,1.12513844094709e-09,1.3328445179708e-11,1.57844295998622e-13,1.86916337988814e-15,2.21338966380359e-17,2.62099716838754e-19,3.10366430258506e-21,3.67521549842223e-23,4.35201964532821e-25,5.15345961918681e-27,6.10248760234281e-29,7.22628246809128e-31,8.5570281657537e-33,1.01328354306434e-34},
  {43.8768024875394,2.74053874591308,0.0544224947242148,0.000813374357299546,1.13270353395053e-05,1.54982408535341e-07,2.11122447742243e-09,2.87281679462612e-11,3.90806547004043e-13,5.31601044643035e-15,7.23106631871935e-17,9.83596544907197e-19,1.3379231770508e-20,1.81989043727551e-22,2.47547918877973e-24,3.3672340848376e-26,4.58023052095601e-28,6.23019103350129e-30,8.47452549083108e-32,1.15273483435498e-33},
  {38.6741799894491,2.62190311484217,0.0589653779202274,0.00100874416018395,1.61224069388711e-05,2.53341497389889e-07,3.9640618083375e-09,6.19603632217018e-11,9.68216230790403e-13,1.51287128251245e-14,2.36387443453255e-16,3.69355890382074e-18,5.77118777935581e-20,9.01748168342171e-22,1.40898154343223e-23,2.20153367348692e-25,3.43989636946162e-27,5.37483807909562e-29,8.39818449929464e-31,1.31221632804244e-32},
  {34.0961062663361,2.50981972994642,0.0639283978598193,0.00125186469642042,2.29631359573277e-05,4.14398740408202e-07,7.44791491123635e-09,1.33723671581794e-10,2.40033140570698e-12,4.30830514017429e-14,7.73276453250982e-16,1.38791026363827e-17,2.49107932143635e-19,4.47109211885374e-21,8.0249004194934e-23,1.44034218104351e-24,2.58518546272183e-26,4.63999732711415e-28,8.32805827699756e-30,1.49475419426567e-31},
  {30.0668777313689,2.40393153482714,0.0693552126015953,0.00155464243162439,3.27288919030593e-05,6.78312482831174e-07,1.40032360629833e-08,2.88803249687947e-10,5.95483195407097e-12,1.22775125566058e-13,2.53130585916155e-15,5.21887868898096e-17,1.07599279824139e-18,2.21840800353522e-20,4.57376088789917e-22,9.42986516187546e-24,1.94418463970262e-25,4.00838595763854e-27,8.2642140327286e-29,1.70385871761215e-30},
  {26.5200378221553,2.30390237577358,0.0752945893202217,0.0019320206568631,4.66811648568397e-05,1.11109708189856e-06,2.6347114739404e-08,6.24175677896413e-10,1.47835523567469e-11,3.50126765536961e-13,8.29211767031665e-15,1.9638305423456e-16,4.65095530545792e-18,1.10148914758863e-19,2.6086646573193e-21,6.17811915066934e-23,1.46316836839232e-24,3.46523208785524e-26,8.20673387930788e-28,1.94360664031889e-29},
  {23.3972405087228,2.20941578582207,0.0818010705839964,0.00240277379549821,6.66306787712797e-05,1.82136483218881e-06,4.96090145865199e-08,1.35000236178002e-09,3.67291626121211e-11,9.99224717630331e-13,2.71837408227778e-14,7.39526516758543e-16,2.01186066810214e-17,5.47320801809356e-19,1.48897012817983e-20,4.05069934291942e-22,1.10198081210794e-23,2.99790630311172e-25,8.15571569084071e-27,2.21873840277219e-28},
  {20.6472541838696,2.12017384214308,0.0889357356903432,0.00299051522111458,9.51790239347469e-05,2.98797495489838e-06,9.34810015953202e-08,2.92211613165105e-09,9.1322652370474e-11,2.85388385173084e-12,8.91842685361733e-14,2.78701150246374e-15,8.70941337544171e-17,2.72169186968826e-18,8.50528724110609e-20,2.65790227443395e-21,8.30594461665947e-23,2.59560769341338e-24,8.11127404246937e-26,2.53477313831485e-27},
  {18.2250885233837,2.03589609234721,0.0967670716057913,0.00372497765695678,0.000136067807487587,4.90574239861234e-06,1.7629258919389e-07,6.3300683398337e-09,2.27244823893668e-10,8.15750625866629e-12,2.92829809686563e-13,1.05116712081535e-14,3.77335707426961e-16,1.35451542260443e-17,4.86228019886511e-19,1.74540415287188e-20,6.2654465040395e-22,2.2490962794944e-23,8.07354123954059e-25,2.89814485656613e-26},
  {16.0912290709311,1.95631854557197,0.105371970404392,0.00464364205876477,0.000194683752714066,8.0610831298309e-06,3.32740604971272e-07,1.3723990701504e-08,5.65940251245526e-10,2.33367105849653e-11,9.62284342688953e-13,3.96794715147751e-14,1.63616843171108e-15,6.74667914265105e-17,2.78196770032531e-18,1.1471338758173e-19,4.73016320422958e-21,1.95046492774093e-22,8.04266844374475e-24,3.31636394856523e-25},
  {14.2109661991568,1.88119272446522,0.114836872840182,0.00579381265235394,0.00027879027931231,1.32573398982379e-05,6.28567702805792e-07,2.9780157630972e-08,1.41065800889193e-09,6.68184565902076e-11,3.16494472370561e-12,1.49911367586375e-13,7.10072493698084e-15,3.36333970876665e-16,1.59308430999232e-17,7.54582590491636e-19,3.57416666963295e-20,1.69294488559493e-21,8.01882690448718e-23,3.79820899477777e-24},
  {12.5538067585939,1.81028477442019,0.125259080893479,0.00723526399454356,0.000399588423509458,2.18226514589643e-05,1.18846569905097e-06,6.46787990409599e-08,3.5193404787467e-09,1.91488030656856e-10,1.0418788772609e-11,5.66880668566686e-13,3.0843649857997e-14,1.67818489291848e-15,9.13090515399534e-17,4.96807165843681e-18,2.70309849037192e-19,1.47073994622595e-20,8.00220930450185e-22,4.35395488609025e-23},
  {11.0929581789407,1.74337462664038,0.136748265877877,0.00904362250228279,0.000573257306973652,3.59551331252482e-05,2.24917738425914e-06,1.40604564872793e-07,8.78826940553512e-09,5.49274402174505e-10,3.43297683295195e-11,2.145612367374e-12,1.34100801816812e-13,8.38130056442483e-15,5.2383129232146e-16,3.27394558801679e-17,2.04621599423044e-18,1.27888499666277e-19,7.99303122956221e-21,4.99564451854199e-22},
  {9.80487605905269,1.68025521182367,0.149428203079458,0.0113146924088851,0.000823193819595733,5.92967601185724e-05,4.26066768893128e-06,3.05952388236784e-07,2.19665779595779e-08,1.57708121232456e-09,1.13224779449385e-10,8.12882646122307e-12,5.8359821733022e-13,4.18986466379204e-14,3.00805669246711e-15,2.15959361582587e-16,1.55045102245377e-17,1.11312533709297e-18,7.99153277304696e-20,5.73741284401097e-21},
  {8.66886739525138,1.62073172145168,0.163438769033418,0.0141699979183075,0.00118327321381608,9.78886611011224e-05,8.07910420065422e-06,6.66407574452629e-07,5.49608087862436e-08,4.53263162214093e-09,3.73803844213954e-10,3.08273440798018e-11,2.54230825803527e-12,2.09662251114136e-13,1.72906876392915e-14,1.4259499494152e-15,1.17597015001211e-16,9.69813697538987e-18,7.99798028711318e-19,6.59587391198387e-20},
  {7.66674257209463,1.56462091385639,0.178938243557635,0.0177638938565288,0.00170260241964318,0.000161763328627559,1.53354055250117e-05,1.45302327694037e-06,1.37654498720089e-07,1.30404740637937e-08,1.23535743500036e-09,1.17028316574775e-10,1.10863618631066e-11,1.05023644295327e-12,9.94912995672592e-14,9.42503821236599e-15,8.92855410526639e-16,8.45822335918317e-17,8.01266829332327e-18,7.59058379642178e-19},
  {6.7825100929163,1.51175046240992,0.196105965712506,0.0222927021799111,0.0024524590675892,0.000267601846654934,2.9139958159748e-05,3.17151585610727e-06,3.45135305917878e-07,3.75576165615485e-08,4.08698640520496e-09,4.44741335464914e-10,4.83962355611989e-11,5.26642148508002e-12,5.73085779754784e-13,6.23625187098437e-14,6.78621572833536e-15,7.38467990738838e-16,8.03592156674938e-17,8.74459505826019e-18},
  {6.00210877438071,1.46195834334663,0.215145401124726,0.028006468961381,0.00353643559108661,0.000443174427445422,5.54318548000921e-05,6.93007761225122e-06,8.66293947281412e-07,1.0828781361471e-07,1.35360101459245e-08,1.69200231336976e-09,2.11500321831519e-10,2.64375412495743e-11,3.30469268809162e-12,4.13086587008165e-13,5.1635823407168e-14,6.45447792686935e-15,8.06809740889086e-16,1.00851217612086e-16},
  {5.31317278328252,1.41509226088077,0.236287687815284,0.0352241160557701,0.0051052901498605,0.000734771185950967,0.000105565503378355,1.51600804830133e-05,2.17687447429444e-06,3.12574371080272e-07,4.48818107246648e-08,6.44446144767345e-09,9.25342915040534e-10,1.32867490280207e-10,1.90780836098621e-11,2.73937041350199e-12,3.93338786183951e-13,5.64784520886264e-14,8.10958812615559e-15,1.16443381753745e-15},
  {4.70482546645008,1.37100910742655,0.259795739063575,0.044352996917436,0.00737872011581991,0.00121965408900124,0.000201276035738864,3.32026253973701e-05,5.47657478858656e-06,9.03305554107846e-07,1.48990165803628e-07,2.4574225696484e-08,4.05323618270839e-09,6.68534672841039e-10,1.10267099584105e-10,1.8187288812183e-11,2.99978393443565e-12,4.94779829075551e-13,8.16082373221203e-14,1.3460339341454e-14},
  {4.16749842603473,1.32957445686352,0.285968995221221,0.0559141746963198,0.0106773323506885,0.00202695268133088,0.000384224281699467,7.28058225757529e-05,1.37945471232795e-05,2.61359799580585e-06,4.95185172038414e-07,9.38200910670242e-08,1.77755854179428e-08,3.36784376307477e-09,6.38087077918147e-10,1.20894894585968e-10,2.29052993270326e-11,4.33974270686573e-12,8.2222748942269e-13,1.55782978395918e-13},
  {3.6927727315702,1.29066208891711,0.315148932116191,0.0705751462025232,0.0154696561114792,0.00337278015655757,0.00073437073710017,0.000159844501283665,3.4789147975359e-05,7.57148075082541e-06,1.64784207332087e-06,3.58632617180315e-07,7.80519652076753e-08,1.69870460309787e-08,3.69702064786141e-09,8.04610853244507e-10,1.75113607955881e-10,3.81113125157467e-11,8.29445614485453e-12,1.8051858672965e-12},
  {3.27323954473516,1.25415354284389,0.347725452180441,0.0891922686706809,0.0224413814944136,0.00561933415688472,0.00140539583356725,0.00035138410953303,8.78482244506088e-05,2.19621934312527e-05,5.49055694025527e-06,1.37263977146691e-06,3.43159976391928e-07,8.57899961933071e-08,2.14474991792846e-08,5.36187480300601e-09,1.34046870126306e-09,3.35117175347736e-10,8.37792938389323e-11,2.0944823459858e-11},
  {2.90237776954745,1.21993769872362,0.384144306189054,0.112865848711051,0.032597487058432,0.00937451287758898,0.00269308055152712,0.000773453139516896,0.00022212102974438,6.37878702127983e-05,1.8318280871129e-05,5.2605466047459e-06,1.51069543912381e-06,4.33833350882959e-07,1.24585914802339e-07,3.5777908895903e-08,1.02745062769779e-08,2.95057711494327e-09,8.4733076957479e-10,2.43331865288525e-10},
  {2.57444663571006,1.18791038476571,0.424915719103034,0.143011779200468,0.0474131122730214,0.0156600753059656,0.00516751420324957,0.00170477725051375,0.000562377759231172,0.000185516382064005,6.1197658188637e-05,2.01877046906396e-05,6.65945951837318e-06,2.19680242092377e-06,7.24674546661628e-07,2.39053449549135e-07,7.88582294679277e-08,2.60135144050583e-08,8.58125951127975e-09,2.83075995239539e-09},
  {2.28439138122241,1.15797400913708,0.47062442365635,0.181454833031815,0.069056786878617,0.026195944855414,0.00992909076709048,0.00376267612468595,0.0014258117237842,0.000540283894701376,0.000204729528642014,7.75780050340984e-05,2.93965687968659e-05,1.11392167647844e-05,4.22097386449452e-06,1.59945000495482e-06,6.06078217610041e-07,2.29660698772961e-07,8.70251314530349e-08,3.29763583616604e-08},
  {2.02776042672155,1.1300372149118,0.521941340842507,0.230550339658118,0.100721234339001,0.043881617593823,0.0191049548231953,0.00831639032904384,0.00361997091334114,0.00157568949251234,0.000685859300691364,0.000298537666990582,0.000129946074341317,5.65623148979398e-05,2.462017763383e-05,1.07165547631451e-05,4.66465139384278e-06,2.03040744935571e-06,8.83786174390686e-07,3.84690275975881e-07},
  {1.80063263231421,1.1040145568308,0.579637188310019,0.293343110590996,0.147114356055281,0.0736125981959799,0.0368132288103273,0.0184074806876955,0.00920384863130463,0.00460193785165131,0.00230097061782762,0.00115048552041412,0.000575242786644602,0.000287621396626993,0.000143810698726583,7.19053494149275e-05,3.59526747139182e-05,1.79763373577659e-05,8.98816867898381e-06,4.49408433950451e-06},
  {1.59955340139128,1.07982619864248,0.644598347021808,0.373775316013014,0.215189098807372,0.123667195853984,0.0710387100951367,0.0408025407692242,0.0234351234198055,0.0134599751182398,0.00773073012649484,0.00444013913406155,0.00255019035216153,0.00146469974451538,0.000841249095452509,0.000483170726318458,0.000277508709291702,0.000159386898936013,9.15437343087493e-05,5.25780685054895e-05},
  {1.42147854813581,1.05739762987284,0.717845374735348,0.47695877687633,0.315230126455968,0.208065849797923,0.137287365271871,0.0905783725496752,0.0597598503089387,0.0394268653626941,0.0260120415457951,0.0171615491405821,0.0113224002300507,0.00746999838638447,0.00492836099041757,0.00325150565836431,0.00214519371929225,0.00141530004141034,0.000933749800385196,0.000616045124146449},
  {1.26372497881686,1.03665940094692,0.800554623534934,0.609532133268684,0.462474242681065,0.350591349600035,0.265717772689774,0.201380055481107,0.152618232863158,0.115663122631349,0.0876562803126044,0.0664310428052522,0.0503453169440205,0.0381546156375265,0.0289157915372222,0.0219140721394092,0.0166077610918485,0.0125863293099978,0.00953865392340064,0.00722894788696167},
  {1.12392735384512,1.01754687565228,0.894083499710517,0.780129992413849,0.679530474657191,0.591650018438932,0.515079619438102,0.448406849138647,0.390361704842088,0.339829791327072,0.295839057460668,0.257542867083196,0.224204089963475,0.195180997235674,0.169914927180641,0.147919535589642,0.128771435034442,0.112102045306637,0.0975904986885475,0.0849574636057099},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
  {0.890103432015932,0.983963086600024,1.12011727128604,1.28381555563124,1.47389903607368,1.69283083126535,1.94448464949846,2.23360698081559,2.56573511147152,2.94725410720329,3.38550548674527,3.88892445194405,4.46720108288849,5.13146652450916,5.89450715231139,6.77101066848392,7.777848816298,8.93440214062341,10.2629330417949,11.7890143025485},
  {0.792614921406624,0.969384613724999,1.25653407445748,1.65074759808578,2.17579493892921,2.8701948952724,3.78698643344921,4.99687331306488,6.59338574641891,8.70001537532391,11.4797360517,15.1476015244175,19.9873797077315,26.3735055301332,34.8000491455898,45.9189401309386,60.5904047531376,79.9495183873961,105.494021974223,139.200196534096},
  {0.706102619386285,0.956217038291349,1.4116821910973,2.12587984865173,3.21703118581581,4.87414079336746,7.38707107924185,11.1964237943772,16.9704980932518,25.7224245804238,38.987889712633,59.0945845123664,89.5706385316999,135.763699859971,205.779288691931,311.903076795126,472.756660598483,716.56510238003,1086.10959665411,1646.23430869208},
  {0.629302801218276,0.944416622037403,1.58838199843803,2.7420799071273,4.76412313936513,8.29042731399637,14.432561330725,25.1277170979978,43.7495345448839,76.1722063143774,132.623445642978,230.910800767761,402.039042364458,699.990623938596,1218.75446148148,2121.97476485308,3694.57265321956,6432.62460859445,11199.8499528805,19500.0713705858},
  {0.56109985233918,0.933943270226821,1.78990765896614,3.542476045413,7.06647944338202,14.1237469104758,28.2428908677096,56.4834806378953,112.965810774407,225.931046304045,451.861804986446,903.723466162163,1807.44686041897,3614.89368488527,7229.7873517942,14459.5746946002,28919.1493847064,57838.2987671657,115676.597533208,231353.195065854},
  {0.500508663092375,0.924760382251228,2.020063632491,4.58373966604484,10.4982360144671,24.1000407259249,55.3566952998374,127.170168822032,292.156812127307,671.198079977986,1542.0071010849,3542.60137479888,8138.76036075486,18697.9610565234,42956.6340886669,98688.4297552471,226726.47379256,520880.654935676,1196669.50293505,2749224.57898534},
  {0.446659139668145,0.916834713549149,2.28327452794146,5.9404405316996,15.6214752419506,41.1888633722313,108.674029334146,286.776630353909,756.797606576087,1997.19395772725,5270.62190102506,13909.2515829189,36706.7330117636,96869.6478680516,255640.532488895,674639.409297571,1780384.07459919,4698461.74104774,12399314.8713892,32721988.1218163},
  {0.398782574594879,0.910136248299152,2.58469067854247,7.71083187664298,23.2818929582147,70.5072920907459,213.684980512229,647.731450666005,1963.52405658121,5952.26874986155,18043.8871736963,54698.8241406191,165815.817768086,502659.556330193,1523778.82790572,4619233.62192619,14002897.8473492,42448848.4902426,128680845.769994,390087379.450853},
  {0.356199651478099,0.904638082383735,2.93031225796461,10.0245432649783,34.7537609316752,120.886322853519,420.834693647046,1465.33061835237,5102.48974764418,17767.8248339897,61871.0931072305,215447.601877822,750232.074256223,2612459.77547057,9097113.27826664,31677988.3217728,110309162.281456,384118813.418157,1337579397.55331,4657721991.95417},
  {0.318309886183791,0.900316316157106,3.32713526913404,13.0528211915084,51.9598731590896,207.589140865183,830.106475588334,3320.17588038963,13280.4535160679,53121.5640628988,212486.006251252,849943.775004923,3399774.85001967,13599099.1500787,54396396.3503147,217585585.151259,870342340.355035,3481369361.17014,13925477444.4306,55701909777.4722},
  {0.284582330785499,0.8971499565847,3.78332334661865,17.0221752671503,77.805688083515,357.034857334763,1639.96648542332,7534.69291846508,34619.6518502042,159069.338024115,730889.816659742,3358286.65086992,15430632.1773708,70900565.7836872,325773451.515334,1496861709.56746,6877770331.61385,31601933861.4321,145204357762.586,667184027597.895},
  {0.254547387757634,0.895120828355204,4.30841003567124,22.2325807462258,116.687588400234,615.018431350211,3244.95021932318,17125.4507351919,90386.6928204276,477061.214800697,2517940.74348392,13289766.3752555,70143801.4616786,370221195.769421,1954039175.77419,10313480587.801,54434876874.6475,287309002608.198,1516426007079.5,8003744449730.85},
  {0.227789600465379,0.894213493597147,4.91353706728282,29.0817822767131,175.266925019127,1061.03337964562,6430.50175835314,38983.6329950949,236347.037868599,1432932.12313391,8687663.15979267,52672120.6964921,319343994.621173,1936139888.12848,11738557147.1934,71169302038.3521,431489960352.404,2616065924523.34,15860857843180.5,96162259967365.2},
  {0.203941302294478,0.894415179861899,5.61173516414561,38.0977744080965,263.650219431857,1833.26051121057,12762.5143622699,88874.5169628923,618942.773720538,4310541.1820462,30020306.0148538,209073473.673613,1456072101.50105,10140674860.2954,70623761268.1003,491852440489.596,3425459351721.24,23856284543259.8,166144815574380.0,1.15709970228924e+15},
  {0.182677021062036,0.895715716063235,6.4182551171884,49.9822493285923,397.190703077245,3172.22057787383,25367.1692229695,202916.170321153,1623286.99931158,12986211.269811,103889520.710041,831115826.783896,6648925936.47853,53191406136.243,425531246378.774,3404249965607.85,27233999714018.1,217871997690456.0,1.74297598148027e+15,1.39438078517554e+16},
  {0.163708547898217,0.898107476090703,7.35095830193444,65.6687661181105,599.241359283378,5497.12438750302,50494.1500118392,463969.503072136,4263571.17381054,39180189.0691699,360049133.053981,3308701357.81661,30405595199.6988,279414850029.614,2567707011543.44,23596166522719.1,216839021260378.0,1.99266101595936e+15,1.83117314483152e+16,1.68277246333518e+17},
  {0.146780590803194,0.901585329839853,8.43077750071962,86.4006959096942,905.366542308315,9539.57135237481,100654.112755199,1062389.29119679,11214326.9448817,118378296.129033,1249606545.63056,13190919867.0705,139244169319.404,1469870222398.02,15516042981462.4,163788331376733.0,1.72895999079447e+15,1.82510110801082e+16,1.92658827993182e+17,2.033718780924e+18},
  {0.131666942752792,0.906146601427089,9.68226091121796,113.835752102081,1369.79165431574,16577.9436240409,200923.510206122,2436053.23329294,29538046.3309631,358167770.790385,4343038470.45366,52662498254.7875,638571293691.725,7743144483775.4,93891298281835.4,1.13850076797692e+15,1.38051557937582e+16,1.67397626699748e+17,2.02981884780875e+18,2.46130404369347e+19},
  {0.118167102715182,0.911791034380636,11.1342146137649,150.186284469371,2075.29015700807,28848.7971757689,401629.40089763,5593523.10974076,77908691.3540681,1085166842.52786,15115052307.7063,210534574473.931,2932495522065.19,40846168816637.1,568938480027864.0,7.92463541325855e+15,1.10380733114462e+17,1.53747215005489e+18,2.14151559398829e+19,2.98287617062419e+20},
  {0.106103295394597,0.918520763621861,12.8204616110932,198.407717907956,3148.35463606968,50269.6917547701,803899.827250647,12860736.9605482,205765150.954508,3292215854.30259,52675347425.6508,842805133838.338,13484880441525.8,215758080264863.0,3.45212925703961e+15,5.52340680038409e+16,8.83745087626283e+17,1.41399214002798e+19,2.26238742397515e+20,3.61981987833239e+21},
  {0.0953178420634143,0.926340294073082,14.7807389293555,262.451845148895,4782.49792786163,87710.5717018909,1611186.45270376,29608319.4767938,544158270.196312,10001095845.3185,183811493813.119,3378301606061.57,62090383859985.6,1.1411699115948e+15,2.0973759832506e+16,3.85480373897388e+17,7.08481073846234e+18,1.30212967035201e+20,2.39320673644568e+21,4.39851622608174e+22},
  {0.0856708405925271,0.93525648574914,17.06175828,347.607537458235,7274.07379914287,153232.273955837,3233273.6065714,68251861.5276788,1440892225.24033,30420036650.8303,642230279238.416,13558839634512.7,286255899959154.0,6.04347058840262e+15,1.27590514924008e+17,2.69370709483662e+18,5.68698851051327e+19,1.20064421233747e+21,2.53481525784137e+22,5.3515340560672e+23},
  {0.0770381178391191,0.945278545210433,19.7184605488255,460.959360053718,11077.3923772332,268031.741728955,6496463.12915111,157526330.37231,3820108394.13831,92642401319.7022,2246708963649.68,54485953654816.2,1.32136401792475e+15,3.2045012204468e+16,7.77138487207772e+17,1.88467468316161e+19,4.57061222112019e+20,1.10844042587306e+22,2.68813042628582e+23,6.51911011204403e+24},
  {0.0693094219866676,0.95641802327489,22.8155000450749,612.005305196355,16889.5955431605,469401.826769063,13068755.5998855,364011070.451388,10140109980.8587,282476724238.946,7869110672718.87,219214553876656.0,6.10679443387766e+15,1.70120740614662e+17,4.73915856788009e+18,1.32021668851054e+20,3.67780921988328e+21,1.02455004403769e+23,2.85415237737897e+24,7.95098867148335e+25},
  {0.0623868263290413,0.968688818905595,26.429001180941,813.489384327962,25781.4686578786,823020.489665076,26320793.4620759,842138552.733387,26947419102.2038,862309294826.699,27593832503380.4,883002120660533.0,2.82560637055579e+16,9.04194005333222e+17,2.89342079047061e+19,9.25894650822938e+20,2.96286288093128e+22,9.48116121761838e+23,3.03397158952895e+25,9.70870908640548e+26},
  {0.056183319414942,0.982107189209503,30.6486382643601,1082.5245076532,39399.2099301512,1444669.65030945,53070831.4290772,1950494438.97014,71694180704.5065,2635334130700.84,96870293353327.8,3.56078974128062e+15,1.30888726421941e+17,4.81125308969364e+18,1.76853710638366e+20,6.50085011219572e+21,2.38960506417824e+23,8.78379329890998e+24,3.22877725207038e+26,1.18684515778269e+28},
  {0.0506215594783234,0.996691765500975,35.5800986185643,1442.10776822524,60275.8853536126,2538652.14688851,107124715.42706,4522543899.93893,190953468582.23,8062787690307.41,340444345001710.0,1.43749993011696e+16,6.06973515458114e+17,2.56290023766892e+19,1.08216547372695e+21,4.5693628796579e+22,1.92937934824115e+24,8.14666020000339e+25,3.43986642556057e+27,1.45245790735563e+29},
  {0.0456327737254708,1.01246357540177,41.3480005803521,1923.16644288124,92312.5501883256,4465801.12081453,216463722.187138,10497419339.9008,509134919485.694,24694284706290.2,1.19774212554542e+15,5.80939657633235e+16,2.81772711529628e+18,1.36668015973723e+20,6.62879916382744e+21,3.21516181880922e+23,1.55944768952351e+25,7.5637782312031e+26,3.6686540704004e+28,1.77940472039931e+30},
  {0.0411557853746056,1.02944607096675,48.0993514208252,2567.32213012612,141521.990951878,7863972.9430054,437851778.689058,24390959382.768,1358891573915.41,75710178056106.1,4.21819948342077e+15,2.3501782729115e+17,1.30940715976488e+19,7.29539260317597e+20,4.06464516845515e+22,2.26462664449305e+24,1.2617420798518e+26,7.02982578032155e+27,3.91668402732158e+29,2.18218975117053e+31},
  {0.0371361533881089,1.04766516284185,56.0076462893009,3430.62709739239,217179.225726834,13861690.1751934,886544934.895682,56729229035.381,3630516329420.84,232350575901122.0,1.48703973510816e+16,9.51704798365052e+17,6.09090969817017e+19,3.89818204501035e+21,2.49483648291565e+23,1.59669534492346e+25,1.02188502008821e+27,6.54006412750403e+28,4.1856410414329e+30,2.67881026648991e+32},
  {0.0335254116350069,1.06714926047815,65.2777283943095,4588.61740882791,333602.394972058,24457227.6397446,1796765216.88057,132069290491.925,9708875974546.49,713756720180775.0,5.24728924475452e+16,3.85763099694654e+18,2.83600232224143e+20,2.08493508104829e+22,1.53277534238584e+24,1.12684576621485e+26,8.2841976136221e+27,6.09026826858323e+29,4.47736393044634e+31,3.29160997220705e+33},
  {0.0302803958021826,1.08792931844252,76.1515533906898,6143.15032582594,512911.201732382,43191740.195046,3644889961.06034,307750904118.191,25987951410269.9,2.1946193418908e+15,1.85331811511366e+17,1.56509838029783e+19,1.32170197511738e+21,1.11615752723722e+23,9.42578349382021e+24,7.95993334506047e+26,6.72204480699103e+28,5.67666643065197e+30,4.7938600075183e+32,4.04834316991444e+34},
  {0.0273626477632417,1.11003888888273,88.9150280373491,8231.66048999566,789302.103100165,76345331.8680784,7400582159.38886,717769862260.093,69624731260615.1,6.75393052045861e+15,6.55168986712089e+17,6.3555186218559e+19,6.16522442277843e+21,5.98062872369891e+23,5.80156027806744e+25,5.62785344049975e+27,5.45934764017038e+29,5.29588714183478e+31,5.1373208799372e+33,4.9835023136746e+35},
  {0.0247378883371729,1.13351418022132,103.906125459466,11039.6964080593,1215678.15911729,135063740.844571,15039101994.3865,1675504784259.17,186693669736150.0,2.08031236499054e+16,2.31809520074514e+18,2.58306256263721e+20,2.87831828915659e+22,3.20732351360001e+24,3.57393569275702e+26,3.98245340383577e+28,4.43766662600641e+30,4.94491287079672e+32,5.51013975671401e+34,6.13997474431356e+36},
  {0.0223755504451868,1.15839412216945,121.524517785969,14817.907410601,1873936.26347883,239142134.276637,30587150001.352,3914418229053.87,501021953528195.0,6.41300555245842e+16,8.20862296249221e+18,1.05070296657174e+21,1.34489954997123e+23,1.7214713448462e+25,2.20348329608571e+27,2.82045861088813e+29,3.6101870193443e+31,4.6210393839311e+33,5.91493041116633e+35,7.57111092620795e+37},
  {0.0202483656212123,1.18472043716923,142.243012724082,19905.0710473959,2890938.10983853,423761375.670073,62259281485.9828,9152437495829.47,1.34564937967698e+15,1.97853017470236e+17,2.90909125860549e+19,4.2773322747069e+21,6.28910544309769e+23,9.24708446540543e+25,1.35963015546619e+28,1.99911029557436e+30,2.93935962406876e+32,4.32184008229745e+34,6.35454795887144e+36,9.3433072473881e+38},
  {0.0183319976651079,1.21253771838944,166.621135193107,26759.3220055258,4463318.27448893,751487674.69871,126824878157.442,21416159110955.2,3.61694865670245e+15,6.10884364625474e+17,1.03176229304722e+20,1.74261436018448e+22,2.94322303367244e+24,4.97101554033944e+26,8.39589664236738e+28,1.41804185659066e+31,2.39503033111575e+33,4.0451346788602e+35,6.83211162707099e+37,1.15392324340463e+40},
  {0.0166047179614373,1.24189351441733,195.321260158716,36000.5208797239,6896038.82252572,1333660376.7264,258539989147.766,50149814178954.4,9.72916803727206e+15,1.88754917029983e+18,3.66205524225886e+20,7.10481086272531e+22,1.37841631171503e+25,2.67428907236011e+27,5.18843417781226e+29,1.00661703855312e+32,1.95295503399578e+34,3.78896166158837e+36,7.35102970888957e+38,1.42618592134937e+41},
  {0.0150471176327236,1.27283842080612,229.127780303124,48467.7591832729,10662337.0053817,2368533855.1087,527426545872.303,117518993485044.0,2.6189068884146e+16,5.83644680126769e+18,1.30071193217229e+21,2.8987766019857e+23,6.46023962887225e+25,1.43973503234325e+28,3.20860704748288e+30,7.15073193973018e+32,1.5936188706064e+35,3.55155406135808e+37,7.91502691466946e+39,1.76395037158051e+42},
  {0.0136418522650197,1.30542617865575,268.969884542772,65297.437725621,16496980.7349664,4209333894.41021,1076702429337.18,275579084642285.0,7.05446150234881e+16,1.80591890933794e+19,4.62313753747486e+21,1.18352225788824e+24,3.02981637110284e+26,7.75632952020504e+28,1.98562033222413e+31,5.08318803452681e+33,1.30129613581698e+36,3.33131810703746e+38,8.52817435359732e+40,2.18321263449413e+43},
  {0.0123734154447204,1.33971378042222,315.948633537135,88029.3178430513,25541404.3632392,7485752418.5983,2199468363522.72,646655186535480.0,1.90149855796585e+17,5.59160239912806e+19,1.64429912780154e+22,4.83533352619148e+24,1.42191066416365e+27,4.18136667494063e+29,1.22960101370185e+32,3.61584808250936e+34,1.06330079769108e+37,3.12681440494319e+39,9.19492240168962e+41,2.70392121267571e+44},
  {0.0112279377869589,1.37576158316925,371.369149651189,118750.618514846,39569686.6055953,13320947587.1801,4495907162077.27,1.51836739197688e+15,5.12868144671896e+17,1.73241490592894e+20,5.8519745832881e+22,1.97676040625617e+25,6.67737715623235e+27,2.25557798990434e+30,7.61920758370194e+32,2.57372278985406e+35,8.69388180119511e+37,2.93674132727633e+40,9.92013673737779e+42,3.35096291859272e+45},
  {0.0101930085248596,1.41363342949461,436.778895437422,160291.875811388,61340550.1939744,23719308842.5683,9195687580940.71,3.56737062295797e+15,1.38414857523075e+18,5.37074832511899e+20,2.08396920291825e+23,8.08628217891289e+25,3.13766637341264e+28,1.21748803871346e+31,4.72413891953721e+33,1.83307663339686e+36,7.11276702369341e+38,2.75992033518518e+41,1.07091378536279e+44,4.15539652034e+46},
  {0.00925751707166614,1.45339677638273,514.013201484181,216493.247479085,95145887.3082971,42259685191.9941,18819513966485.6,8.38642597847936e+15,3.73780825355253e+18,1.66600006963326e+21,7.42570147213592e+23,3.3097948415412e+26,1.47524769039847e+29,6.57550151152824e+31,2.93084491163221e+34,1.30634172426186e+37,5.82265099755518e+39,2.59528299762485e+42,1.15677443859292e+45,5.15599687224541e+47},
  {0.00841151226987353,1.49512283225488,605.249427280278,292566.716785357,147665872.541725,75335253953.6252,38537219112382.9,1.97266518136058e+16,1.00994820580256e+19,5.1708626667297e+21,2.64747245064343e+24,1.35550471268792e+27,6.94018261594992e+29,3.55337330570083e+32,1.81932710772964e+35,9.31495475984558e+37,4.76925683297948e+40,2.44185949796563e+43,1.25023206289186e+46,6.40118816192113e+48},
  {0.0076460773078329,1.53888670250826,713.071404552686,395588.884198433,229302535.141422,134372024815.744,78957056099998.3,4.64267674407545e+16,2.73035923556543e+19,1.60579313786267e+22,9.44417485732587e+24,5.5544312399973e+27,3.26674668325724e+30,1.92128324277833e+33,1.12997113340123e+36,6.64573940552673e+38,3.90858235712792e+41,2.29876844699267e+44,1.35198286511966e+47,7.9514649248059e+49},
  {0.00695321851915817,1.58476754385651,840.54612968469,535171.631945387,356260271.479574,239800054399.856,161856942255223.0,1.09323448274601e+17,7.38533651990892e+19,4.98937332082293e+22,3.37074887087661e+25,2.27723561020638e+28,1.53847282018011e+31,1.03937379463978e+34,7.02188505604767e+36,4.74390161789437e+39,3.20492324210871e+42,2.16520784407247e+45,1.46278854582496e+48,9.88242461684498e+50},
  {0.00632576648740079,1.63284872780539,991.315050281198,724375.132842213,553792823.821298,428164908341.069,331965605713212.0,2.5756068435171e+17,1.99867490586059e+20,1.55104277812645e+23,1.20367751741964e+26,9.34109331813391e+28,7.24912469040715e+31,5.62566029269154e+34,4.36577606737325e+37,3.38804689274863e+40,2.62928322502448e+43,2.04044704836069e+46,1.58348256978701e+49,1.22885671105188e+52},
  {0.00575728806119146,1.68321801361974,1169.70274262187,980951.128577783,861272472.768312,764867412393.668,681189801567951.0,6.07098426632121e+17,5.41162031498427e+20,4.82408375512231e+23,4.30038350857997e+26,3.83354656563901e+29,3.41739043769084e+32,3.04641126225984e+35,2.71570432205594e+38,2.42089770880735e+41,2.15809419487039e+44,1.92381963936322e+47,1.71497704512831e+50,1.52880561423901e+53},
  {0.00524200804628107,1.73596773116094,1380.84631585956,1329036.41621799,1340106722.67597,1366994593769.52,1.39845575440758e+15,1.43167416546687e+18,1.46594616126557e+21,1.50110629493175e+24,1.53712706707425e+27,1.57401663728032e+30,1.61179265784794e+33,1.65047558468217e+36,1.69008697389429e+39,1.73064905491376e+42,1.77218463060507e+45,1.81471706132318e+48,1.85827027068834e+51,1.90286875715757e+54},
  {0.00477473948321122,1.79119497399781,1630.84952238524,1801460.18810775,2086105990.74336,2444249714493.37,2.87228449138686e+15,3.37774917985176e+18,3.97289283421873e+21,4.67311190073999e+24,5.49680689110654e+27,6.46570702130168e+30,7.60539673478795e+33,8.9459775464669e+36,1.0522859047288e+40,1.2377693012443e+43,1.45594732429438e+46,1.71258295909373e+49,2.01445501725945e+52,2.36953719245598e+55},
  {0.00435082154495951,1.84900180321875,1926.96632211394,2442888.55232101,3248810844.13816,4372354727710.33,5.90197285807227e+15,7.97263048469287e+18,1.07717610153109e+22,1.45543208294528e+25,1.96653743898228e+28,2.65713581875973e+31,3.59025754638076e+34,4.85106989855624e+37,6.55464961037212e+40,8.85648586808965e+43,1.19666720292409e+47,1.61690812461873e+50,2.18472761477269e+53,2.95195173942684e+56},
  {0.00396606419981713,1.90949546239879,2277.81956584206,3314111.07366818,5061704224.90644,7824731646945.57,1.21325251828167e+16,1.88260891639932e+19,2.9218021524436e+22,4.53483973764105e+25,7.03846886535541e+28,1.09243529204464e+32,1.69556158873166e+35,2.63167040721199e+38,4.0845991656229e+41,6.33968086955026e+44,9.83977913463076e+47,1.52722598313902e+51,2.37039792466983e+54,3.67907983727632e+57},
  {0.00361669888271134,1.97278860420172,2693.66155832496,4497885.52567927,7889452899.66407,14008810622651.6,2.49507115054986e+16,4.44729895125194e+19,7.9285293231831e+22,1.41354513366412e+26,2.52018200058265e+29,4.49319665349651e+32,8.01086239794831e+35,1.42824659754556e+39,2.54640304271264e+42,4.5399502737435e+45,8.09422082929795e+48,1.44310855693882e+52,2.57290028454767e+55,4.58719189398273e+58},
  {0.00329933450471762,2.03899952912558,3186.68457004058,6106909.18213522,12301797741.7987,25090228058567.6,5.13317641976975e+16,1.05100324556914e+20,2.15231577344975e+23,4.40787160394696e+26,9.02728464204548e+29,1.84878603087076e+33,3.78631283694806e+36,7.75436820148077e+39,1.58809458264751e+43,3.25241769245405e+46,6.66095142758816e+49,1.3641628520343e+53,2.79380552079434e+56,5.72171370649879e+59},
  {0.00301091820696521,2.10825243692895,3771.3909292706,8294692.88087699,19189157297.3298,44954538068590.3,1.05646477819826e+17,2.48471947412397e+20,5.84500535155752e+23,1.37503503567911e+27,3.23480376842766e+30,7.60997881969496e+33,1.79027310973295e+37,4.21167850456667e+40,9.90811769390693e+43,2.33091859469887e+47,5.48356577831059e+50,1.29002761983836e+54,3.0348341344597e+57,7.13955118671534e+60},
  {0.00274870033271803,2.18067769130523,4465.03419270428,11270398.2537,29943541412.9444,80575381171732.9,2.17512261094674e+17,5.87638926094759e+20,1.58790210011778e+24,4.29099963634438e+27,1.1595744279599e+31,3.13357526286277e+34,8.46802181709606e+37,2.28835759166641e+41,6.18394807505452e+44,1.67112056255184e+48,4.51595632622065e+51,1.22037045158841e+55,3.29787077599768e+58,8.91200835085709e+61},
  {0.00251020315115347,2.25641209840458,5288.14512277771,15319086.9716182,46741745196.0029,144472656045862.0,4.47988548113092e+17,1.39026693902468e+21,4.31535947315472e+24,1.33954601527947e+28,4.15818458072923e+31,1.29077711709144e+35,4.00681317745513e+38,1.24378986776161e+42,3.86095693191991e+45,1.19851343059078e+49,3.72041043982357e+52,1.15488516841762e+56,3.5849801360909e+59,1.11284506271676e+63},
  {0.00229319291919107,2.33559919983534,6265.15886414385,20829361.9719477,72988759527.6156,259130302581252.0,9.22994956171555e+17,3.29029681913802e+21,1.17316602458672e+25,4.18317505117769e+28,1.49161980359822e+32,5.31877511068309e+35,1.89655508501411e+39,6.76268846234677e+42,2.41142257766305e+46,8.59859056480965e+49,3.06606401616951e+53,1.09328947432881e+57,3.8984243923391e+60,1.39009046555161e+64},
  {0.00209565491445056,2.41838958081186,7425.16289516105,28331106.9252216,114012210000.175,464937983365556.0,1.90228688228565e+18,7.78961919684661e+21,3.19040812184488e+25,1.30676864987621e+29,5.35250133292628e+32,2.19238218494009e+36,8.97999501182524e+39,3.67820570927227e+43,1.50659303316662e+47,6.17100503789073e+50,2.52764366086177e+54,1.03532284321677e+58,4.24068236553716e+61,1.73698349689548e+65},
  {0.00191577111376169,2.50494119415148,8802.78913449481,38547023.5469025,178150197191.974,834471239617424.0,3.92186109969198e+18,1.84474730299442e+22,8.67905646391011e+25,4.08348421917169e+29,1.92129889884489e+33,9.03983299495105e+36,4.25330215286727e+40,2.00120764548395e+44,9.41581881834203e+47,4.43020719779664e+51,2.08444281445758e+55,9.80744614467666e+58,4.61447055456752e+62,2.17113998750751e+66},
  {0.00175190022823751,2.59541970086116,10439.2781293842,52463025.169165,278455793627.816,1.49817547992255e+15,8.08804127889685e+18,4.3701112612197e+22,2.36174898785367e+26,1.2764329557924e+30,6.89871233428826e+33,3.7285459739254e+37,2.01516832753943e+41,1.0891388379767e+45,5.88647337097745e+48,3.18146484061972e+52,1.71948770120301e+56,9.29332274627464e+59,5.02276623574974e+63,2.7146566786757e+67},
  {0.00160255983831245,2.68999882808704,12383.7486861501,71424404.0032987,435368355145.493,2.69057191895802e+15,1.66849576387303e+19,1.03556818603701e+23,6.42873549168857e+26,3.99112868259862e+30,2.47783129038499e+34,1.5383288771392e+38,9.55051995890179e+41,5.92932057438692e+45,3.68114453122564e+49,2.28539257869125e+53,1.41885742641915e+57,8.80879905240093e+60,5.46883283102668e+64,3.39525653353334e+68},
  {0.00146641040082926,2.78886074528665,14694.71279898,97267233.2579409,680900947847.354,4.83340251914631e+15,3.44297037654105e+19,2.45465992077271e+23,1.75042618645517e+27,1.2483026075832e+31,8.90229240587624e+34,6.34870734256677e+38,4.52761123934366e+42,3.22888846200182e+46,2.30269797964318e+50,1.64218061980642e+54,1.17112935385134e+58,8.35196779238239e+61,5.95624776973278e+65,4.24772800592492e+69},
  {0.00134224092566389,2.89219645939609,17441.8834979513,132497946.437679,1065205757338.43,8.68527891638323e+15,7.10663320241219e+19,5.82004573857656e+23,4.76743170234226e+27,3.90540842185746e+31,3.19929590980776e+35,2.62086020503515e+39,2.14700806468885e+43,1.75882888058462e+47,1.44083259316838e+51,1.18033005503836e+55,9.6692638000502e+58,7.92106090278436e+62,6.48893309110696e+66,5.31573398814184e+70},
  {0.00122895614188781,3.00020623002068,20708.3325205803,180538800.871232,1666870020673.59,1.56110890362947e+16,1.46728044842843e+20,1.38032094108441e+24,1.29880445861733e+28,1.2221700909969e+32,1.15007345264541e+36,1.0822336105733e+40,1.01839635054454e+44,9.58324840673729e+47,9.0179678050564e+51,8.48603114384269e+55,7.9854714915561e+59,7.51443801180399e+63,7.07118905939983e+67,6.65408572642249e+71},
  {0.00112556499341809,3.11310000552053,24593.0658107837,246063454.988977,2609065426791.31,2.80671035510325e+16,3.03024202127439e+20,3.27452800714394e+24,3.53930520177223e+28,3.82570780613187e+32,4.13534454158963e+36,4.47005772123587e+40,4.83186671070768e+44,5.22296187345601e+48,5.64571290275729e+52,6.10268184819453e+56,6.59663828286602e+60,7.13057599181112e+64,7.70773109054487e+68,8.33160163156128e+72},
  {0.00103117032179316,3.23109788103155,29214.0981215183,335455818.7478,4084883745438.68,5.04746658841587e+16,6.25969182234155e+20,7.77013903338443e+24,9.64725382772645e+28,1.19785262800211e+33,1.48733660645893e+37,1.84678650328732e+41,2.29310797115249e+45,2.84729465451494e+49,3.5354145566412e+53,4.38983588914102e+57,5.45074952086517e+61,6.76805947087041e+65,8.40373031926328e+69,1.04347019388208e+74},
  {0.000944959609398705,3.35443057947582,34712.1238691737,457437564.074131,6397091600258.31,9.07940542739663e+16,1.2934113871393e+21,1.84423797145208e+25,2.63025275982977e+29,3.75148376613075e+33,5.35075324091015e+37,7.63182390971968e+41,1.08853438165528e+46,1.55258740394525e+50,2.21447096513689e+54,3.15852216246233e+58,4.5050318757671e+62,6.42557220612501e+66,9.16485816833085e+70,1.30719292470447e+75},
  {0.000866196670384402,3.48333995667555,41254.9003697154,623926427.167074,10020522196566.0,1.63360196420964e+17,2.67316200740561e+21,4.37834519899476e+25,7.1729224269567e+29,1.17518874171852e+34,1.92541986752739e+38,3.15460407428529e+42,5.16850174380961e+46,8.46807261337164e+50,1.38740899060943e+55,2.27313087941523e+59,3.72429762841054e+63,6.10188923257601e+67,9.99733531791043e+71,1.63796341845605e+76},
  {0.000794214188860948,3.61807953174206,49042.4822899096,851210368.904154,15700011422792.6,2.93992924949422e+17,5.52606088851758e+21,1.03969228888165e+26,1.95657529907635e+30,3.68225581065332e+34,6.93007217043419e+38,1.30425695578704e+43,2.45464655268124e+47,4.61971167700326e+51,8.69442371899509e+55,1.63631434558033e+60,3.0795884048678e+64,5.79586971021652e+68,1.09079855126986e+73,2.05291274478112e+77},
  {0.00072840701493017,3.75891504397148,58313.4733034309,1161554075.12923,24604154772413.7,5.29207932735722e+17,1.14262804058286e+22,2.46943995341152e+26,5.3382120604981e+30,1.15403535293788e+35,2.49487556335903e+39,5.39361926502857e+43,1.16603634875955e+48,2.52083251901333e+52,5.4497417394601e+56,1.17816972114891e+61,2.54706362843136e+65,5.50645040076572e+69,1.19042946884193e+74,2.5735677564097e+78},
  {0.000668226138835426,3.90612503754226,69352.4934273282,1585397316.84804,38566742593487.2,9.52822066629388e+17,2.36314339733292e+22,5.86662194065227e+26,1.45677024291805e+31,3.61759757667365e+35,8.98371580312969e+39,2.23096827679476e+44,5.54027337756244e+48,1.37584369351161e+53,3.41670140015485e+57,8.48486545748326e+61,2.10708907994557e+66,5.23263971263358e+70,1.29944759474746e+75,3.22698321368349e+79},
  {0.000613173272167433,4.06000147537548,82499.0993779759,2164363658.36851,60465934444455.9,1.7158943198222e+18,4.88842025711253e+22,1.39402638284447e+27,3.97630381560321e+31,1.13426531929394e+36,3.23561156316428e+40,9.22995878984014e+44,2.63295574590026e+49,7.51082184845625e+53,2.14255208398384e+58,6.11188707928334e+62,1.74348918228927e+67,4.97351225924354e+71,1.41875409666323e+76,4.04716643288638e+80},
  {0.000562795972745032,4.22085038358884,98158.4417830405,2955378804.73875,94819849544982.6,3.09072182842018e+18,1.01143421177818e+23,3.31317615716808e+27,1.08557216954844e+32,3.55712965789028e+36,1.16559424759967e+41,3.81941431641804e+45,1.25154528063978e+50,4.10106324581999e+54,1.34383637737468e+59,4.40348301925017e+63,1.44293331393491e+68,4.72820388161671e+72,1.5493378478065e+77,5.07687025959265e+81},
  {0.000516683256621263,4.38899252804822,116813.998720789,4036308616.54805,148722242271293.0,5.56823354491291e+18,2.09312361135569e+23,7.87600879543151e+27,2.96432606244231e+32,1.11576534390207e+37,4.19978001306787e+41,1.58081814272327e+46,5.95028413512014e+50,2.23971935587799e+55,8.43042615283821e+59,3.17325856095743e+64,1.19443190065457e+69,4.49590709125835e+73,1.692284052943e+78,6.36984986096358e+82},
  {0.000474461646739521,4.56476412459703,139042.79163074,5513678596.03993,233312680024860.0,1.00336902906627e+19,4.33249263488745e+23,1.87263689173653e+28,8.09615773298617e+32,3.50051350166752e+37,1.51353129812256e+42,6.54414281139118e+46,2.82953166694416e+51,1.22342248005152e+56,5.2897893825868e+60,2.28717982541243e+65,9.88922468472125e+69,4.27586689391374e+74,1.84878372994362e+79,7.99370365147509e+83},
  {0.000435791613167968,4.74851758462459,165533.56930648,7533244695.58666,366086905023669.0,1.80837022331276e+19,8.96941645553344e+23,4.45332463608999e+28,2.21164463640326e+33,1.09843419313247e+38,5.45556415346275e+42,2.709611471491e+47,1.34578229462083e+52,6.68409642822112e+56,3.31979013423686e+61,1.6488401723972e+66,8.18929454804696e+70,4.06737695882623e+75,2.02014413233701e+80,1.00334499530666e+85},
  {0.000400364364648884,4.94062229771876,197108.541024713,10294470511.2712,574528066681058.0,3.2598317053062e+19,1.85725576306452e+24,1.05924470953602e+29,6.04272596772051e+33,3.44744620098802e+38,1.96684028776627e+43,1.12212811480559e+48,6.40200824843446e+52,3.65249915716346e+57,2.083838448089e+62,1.18887987628176e+67,6.7828452204929e+71,3.86977610171293e+76,2.20780020688479e+81,1.25960304309664e+86},
  {0.000367898955480206,5.14146545323701,234749.35397692,14070356962.2227,901814807875545.0,5.87735661770755e+19,3.84643382619703e+24,2.51992302800341e+29,1.65131329000508e+34,1.08218117366887e+39,7.09214403123853e+43,4.6479012030994e+48,3.04604749876267e+53,1.99625751942764e+58,1.30826730018392e+63,8.57386053302272e+67,5.61896523147318e+72,3.68244505287788e+77,2.4133271896541e+82,1.58159810697895e+87},
  {0.000338139675558477,5.3514529027234,279628.146756019,19234606742.1756,1.41579530501455e+15,1.05985358839694e+20,7.96749459644877e+24,5.99591140571506e+29,4.51339155853077e+34,3.39765603802025e+39,2.55777864967057e+44,1.92552114408007e+49,1.44955291222293e+54,1.09123921707463e+59,8.21496818366506e+63,6.18431800172118e+68,4.65562232805133e+73,3.50480348474847e+78,2.6384544544728e+83,1.98625741473322e+88},
  {0.000310853694808532,5.57101006519644,333144.674146829,26298841115.0007,2.22309785471416e+15,1.91154571210731e+20,1.65067002871467e+25,1.42691503317805e+30,1.23381919498034e+35,1.06692482757932e+40,9.22621015533956e+44,7.97837912630242e+49,6.89932253585647e+54,5.96620730466753e+59,5.1592937900272e+64,4.46151323358896e+69,3.85810562925938e+74,3.33630727565001e+79,2.88508073909748e+84,2.49488137150604e+89},
  {0.00028582893625185,5.80058287743592,396970.694191607,35963595041.7692,3.49132103089002e+15,3.44823274246722e+20,3.42035999374649e+25,3.39636285317789e+30,3.37344081190563e+35,3.35089866044216e+40,3.32856306434633e+45,3.30639023512601e+50,3.28436855640405e+55,3.26249440598294e+60,3.24076615179717e+65,3.21918266087857e+70,3.19774292904851e+75,3.17644598892532e+80,3.1552908870472e+85,3.13427667815928e+90},
  {0.000262872154663973,6.04063879150449,473103.042817454,49188199765.8817,5.48393426233048e+15,6.22127906524446e+20,7.08850406496722e+25,8.08539556843855e+30,9.22498965309999e+35,1.05259181115271e+41,1.20105102225456e+46,1.37045496977289e+51,1.5637543964674e+56,1.78431872252659e+61,2.03599332595199e+66,2.32316616963832e+71,2.65084418761133e+76,3.02474054852735e+81,3.45137425693777e+86,3.93818381150858e+91},
  {0.000241807200178134,6.29166782185316,563927.101849272,67286559272.2053,8.6151763378048e+15,1.12261863678563e+21,1.46928760745914e+26,1.92512045602702e+31,2.52306318800691e+36,3.30695379179367e+41,4.33446570502131e+46,5.68126277262349e+51,7.4465420817988e+56,9.76033076597934e+61,1.27930604560192e+67,1.67681201073395e+72,2.19783103564297e+77,2.88074109403321e+82,3.77584496644197e+87,4.94907551430694e+92},
  {0.000222473448339745,6.55418364447927,672292.702129682,92058429844.3722,1.35364214181741e+16,2.02606118272002e+21,3.04597809961453e+26,4.58439765957618e+31,6.90173218699396e+36,1.03911592902303e+42,1.56450667798845e+47,2.35555213061357e+52,3.54656961365079e+57,5.3397924265296e+62,8.03970827956288e+67,1.2104760850302e+73,1.82251930999613e+78,2.74402499966457e+83,4.13146415485138e+88,6.22042294295268e+93},
  {0.000204724380033265,6.82872475072992,801604.905675583,125969382952.179,2.1272066212704e+16,3.65711787265751e+21,6.31557397349568e+26,1.09187454979573e+32,1.88822683884691e+37,3.26562239366506e+42,5.64787867355429e+47,9.76802248068253e+52,1.68938415594684e+58,2.92179876917062e+63,5.05326665967697e+68,8.73965197031559e+73,1.51152753322535e+79,2.61419504334584e+84,4.52126446674425e+89,7.81955134971288e+94},
  {0.000188426296414711,7.11585565847605,955932.592441206,172397531505.499,3.34333587769912e+16,6.60221805655296e+21,1.30967450908621e+27,2.60092423650064e+32,5.1667176213143e+37,1.02643729984548e+43,2.03919047110968e+48,4.05121300081464e+53,8.04846095688753e+58,1.59897150886551e+64,3.1766446730694e+69,6.31097646017816e+74,1.25378908098445e+80,2.49087771315442e+85,4.94857697970176e+90,9.83123900316718e+95},
  {0.000173457155512238,7.41616818351985,1140138.35405115,235971823164.123,5.2554913892438e+16,1.19207543374839e+22,2.71629470317792e+27,6.19648813604858e+32,1.41396366357411e+38,3.22672421114126e+43,7.36365087450982e+48,1.68045337442363e+54,3.83495461486962e+59,8.75173403735251e+64,1.99722973768322e+70,4.55787010609918e+75,1.04014974354408e+81,2.3737216396851e+86,5.41706082149644e+91,1.23622532040784e+97},
  {0.000159705518523849,7.73028277424334,1360033.88765493,323035931588.524,8.26243686640989e+16,2.1526781323314e+22,5.63445456393469e+27,1.47647135136575e+33,3.87010949365931e+38,1.01450163369889e+44,2.65943920526541e+49,6.97154985246437e+54,1.82754927916359e+60,4.79081033321263e+65,1.25588215455368e+71,3.292219695942e+76,8.63035638708753e+81,2.26239614390812e+87,5.93073574694351e+92,1.55470679161117e+98},
  {0.000147069595063146,8.05884991265857,1622565.91041552,442284440530.601,1.29916123408423e+17,3.88789490015514e+22,1.16892575417597e+28,3.51855607978929e+33,1.05942033827632e+39,3.1900956441537e+44,9.60609759036079e+49,2.89262581565662e+55,8.71039830086437e+60,2.62291305333964e+66,7.89823052415872e+71,2.37834976803378e+77,7.16179102002743e+82,2.15658989105878e+88,6.49401797190218e+93,1.95550714566354e+99},
  {0.000135456377696935,8.40255158517961,1936038.60613732,605635398056.81,2.04303893622708e+17,7.0227726286515e+22,2.42538475517897e+28,8.38614947618701e+33,2.90049438155819e+39,1.00325960461511e+45,3.47026460488481e+50,1.20036644580004e+56,4.1520789342817e+61,1.43620845770503e+67,4.96786047289026e+72,1.71838830135221e+78,5.9439237143693e+83,2.05600964194172e+89,7.11175959193669e+94,2.45996533602232e+100},
  {0.000124780857096452,8.76210282660512,2310379.8025957,829427178923.722,3.21327273747005e+17,1.26870320874792e+23,5.03305521171401e+28,1.99902421377126e+34,7.94205855362289e+39,3.15558789666671e+45,1.25382094496973e+51,4.9818743478202e+56,1.97947728024069e+62,7.86517515917206e+67,3.1251171901005e+73,1.24172156764691e+79,4.93380684543311e+84,1.96037909381595e+90,7.78929194626617e+95,3.09496613281823e+101},
  {0.000114965309999394,9.13825334097679,2757459.50012182,1136060349291.15,5.05445808391841e+17,2.2922792175223e+23,1.04457298524232e+29,4.76573131216781e+34,2.17495453894025e+40,9.92666304306214e+45,4.53069151627324e+51,2.0678914389359e+57,9.43825017154515e+62,4.30779830296308e+68,1.96616186649741e+74,8.97394047712036e+79,4.09587885039222e+85,1.86943780371608e+91,8.53247332407003e+96,3.89438476564657e+102},
  {0.000105938652964023,9.53178920316461,3291471.07551508,1556250199428.16,7.9516347846685e+17,4.14218790172362e+23,2.16820669759691e+29,1.13630743366608e+35,5.95692425647133e+40,3.12306536331545e+46,1.63737539880955e+52,8.58454923789961e+57,4.50077438228578e+63,2.35970176753198e+69,1.23716328991229e+75,6.48629862959104e+80,3.40068853069118e+86,1.78294018769484e+92,9.34774145036477e+97,4.9009086694113e+103},
  {9.76358555990094e-05,9.94353464522544,3929387.52625359,2132117356970.23,1.25109952218914e+18,7.48592837890585e+23,4.50107409910062e+29,2.70966580306812e+35,1.63172722743378e+41,9.82680765374392e+46,5.9181452068342e+52,3.56418997759641e+58,2.14652815444323e+64,1.29274379791366e+70,7.78553334061164e+75,4.68882779575366e+81,2.82384073621702e+87,1.70065459004571e+93,1.02421712329221e+99,6.16833495679414e+104},
  {8.99974075823777e-05,10.3743539317859,4691507.56519745,2921428679793.76,1.96870085903771e+18,1.35305037016321e+24,9.34510240570618e+29,6.46231365934945e+35,4.47018464963521e+41,3.09240421948787e+47,2.13931823337542e+53,1.47998261356639e+59,1.02385476436635e+65,7.08304870268657e+70,4.90006829431776e+76,3.38987782622731e+82,2.34512481059827e+88,1.62236241707011e+94,1.12235383003836e+100,7.76446807840237e+105},
  {8.29688343474977e-05,10.8251533289167,5602109.30579558,4003417059271.78,3.09826750060568e+18,2.44587104299597e+24,1.94045357992645e+30,1.54138676752551e+36,1.22477032455881e+42,9.73265544126671e+47,7.73421887477044e+53,6.14615731203196e+59,4.88417719598495e+65,3.88131850421619e+71,3.08437508858792e+77,2.45106652721367e+83,1.94779395394524e+89,1.54785733042745e+95,1.23003889154377e+101,9.77477474880864e+106},
  {7.6500256820595e-05,11.2968831711916,6690232.78843221,5486768664528.1,4.87650086046891e+18,4.42184327802615e+24,4.02969936764985e+30,3.67693044582468e+36,3.35609342965716e+42,3.06349118614627e+48,2.79645425179341e+54,2.55270674254169e+60,2.33020785947374e+66,2.12710306148872e+72,1.94170136426072e+78,1.77245960866563e+84,1.6179692393342e+90,1.47694449552305e+96,1.34821169060312e+102,1.23069943950112e+108},
  {7.05459910488632e-05,11.7905400318616,7990616.80534618,7520585770634.0,7.67621006834808e+18,7.99507009833423e+24,8.3693392557105e+30,8.7721962346434e+36,9.19734685479766e+42,9.64386354648785e+48,1.01122573758981e+55,1.06034529612991e+61,1.1118521723473e+67,1.16586138370097e+73,1.22249423487858e+79,1.28187810660149e+85,1.34414661535017e+91,1.40943988077183e+97,1.47790483227193e+103,1.5496955373655e+109},
  {6.50641839664327e-05,12.3071690013274,9544820.52284267,10309434959055.6,1.20846345617197e+19,1.44573707354052e+25,1.73843239789988e+31,2.09304887738182e+37,2.52080467576066e+43,3.03622244510703e+49,3.65709816890966e+55,4.40495839396215e+61,5.30575928955895e+67,6.39077327707503e+73,7.69767040388277e+79,9.2718248996144e+85,1.11678901376902e+92,1.3451696039274e+98,1.62025346020624e+104,1.95159128473083e+110},
  {6.00164819121172e-05,12.8478660793519,11402566.4411278,14134004828676.5,1.90268687098442e+19,2.61458928279826e+25,3.61136641696206e+31,4.99456322344475e+37,6.90975961754941e+43,9.56011747068511e+49,1.3227331407437e+56,1.83013623612364e+62,2.53218335660507e+68,3.503539482841e+74,4.84751226175698e+80,6.70703889695952e+86,9.27988802434607e+92,1.28396932197504e+99,1.77650550949841e+105,2.45798070990139e+111},
  {5.53677288423603e-05,13.4137806867353,13623348.4728983,19379466560249.0,2.9960377719718e+19,4.72893981756083e+25,7.5029396272359e+31,1.19196034644011e+38,1.89423052179249e+44,3.01050268418318e+50,4.78469213556737e+56,7.60450897828858e+62,1.20861757302826e+69,1.92090890291749e+75,3.05298498667466e+81,4.85224338278812e+87,7.71188396436112e+93,1.22568366138054e+100,1.94803299061787e+106,3.09609457350061e+112},
  {5.10856914790514e-05,14.0061183024625,16278357.6002575,26574412663358.7,4.71815793588573e+19,8.55400132486428e+25,1.5589657056489e+32,2.84492821665503e+38,5.19335407668885e+44,9.48112824006377e+50,1.73093585879657e+57,3.16012415822899e+63,5.769363080399e+69,1.05329915234729e+76,1.92298383262457e+82,3.51074705227116e+88,6.40948962615236e+94,1.17016568574403e+101,2.13634440865981e+107,3.90027454092158e+113},
  {4.7140808898339e-05,14.6261432326382,19452787.971557,36444323618091.2,7.43090969363518e+19,1.54745898625345e+26,3.23955961711528e+32,6.79086539657675e+38,1.42399131603339e+45,2.9862442546884e+51,6.26256512994052e+57,1.31335284529218e+64,2.75429936475663e+70,5.77618380197635e+76,1.21135350879269e+83,2.54039241664508e+89,5.32758902842526e+95,1.11727639814599e+102,2.34309843267928e+108,4.91383356416156e+114},
  {4.35059643063335e-05,15.2751815178477,23248598.7683021,49984988333360.6,1.17045556361863e+20,2.79970587522166e+26,6.73253804310116e+32,1.62114684608781e+39,3.90490229749281e+45,9.40662990106789e+51,2.26603680616627e+58,5.4588620099034e+64,1.31503658862664e+71,3.16791629338448e+77,7.63149447143017e+83,1.83842323012034e+90,4.42875245842256e+96,1.06688427569292e+103,2.57011894154688e+109,6.1914038145619e+115},
  {4.01562769634481e-05,15.9546239859141,27787822.1185528,68563332798718.1,1.84378577428829e+20,5.06580236376248e+26,1.39931092663356e+33,3.87045620980434e+39,1.07091640707913e+46,2.9633664263893e+52,8.20019599337005e+58,2.26916137285409e+65,6.27924024968371e+71,1.73759660653395e+78,4.80829223584691e+84,1.33055477957655e+91,3.6819226945161e+97,1.01886483396273e+104,2.81941158559269e+110,7.80190013889502e+116},
  {3.70689124135186e-05,16.6659294573831,33216525.250539,94055898778806.6,2.90474318660252e+20,9.16697017271051e+26,2.90864939066201e+33,9.24152621805713e+39,2.93726216723649e+46,9.3363773029226e+52,2.96772219412826e+59,9.43344641690702e+65,2.99859700093199e+72,9.53160334237317e+78,3.02979926077522e+85,9.63078657398843e+91,3.06132659389451e+98,9.73100219235715e+104,3.0931820174631e+111,9.83226064982514e+117},
  {3.42229093490018e-05,17.4106281114324,39709556.560037,129039045144905.0,4.57663175401399e+20,1.65899214800175e+27,6.04657518498823e+33,2.206816258587e+40,8.05695213993991e+46,2.94179472717065e+53,1.07414568869513e+60,3.92207888918778e+66,1.43208909524841e+73,5.2290632511142e+79,1.90931589718051e+86,6.97158763611785e+92,2.54557323344904e+99,9.29478826558667e+105,3.39385596120087e+112,1.23921685542417e+119},
  {3.15990216014425e-05,18.1903250202985,47476231.0169717,177050209252336.0,7.21147928155488e+20,3.00263813562639e+27,1.25709382005328e+34,5.27022067470318e+40,2.21023782267558e+47,9.27014413016707e+53,3.88815245175615e+60,1.63080642214862e+67,6.84009484204942e+73,2.86894339502682e+80,1.20332204213487e+87,5.04709841936279e+93,2.1169065051763e+100,8.87894941841102e+106,3.72410130573748e+113,1.56200130026338e+120},
  {2.91795738887725e-05,19.0067038607224,56767141.2117739,242946801954906.0,1.13642859364456e+21,5.4350188465609e+27,2.61375764264987e+34,1.25872487718534e+41,6.0638244356291e+47,2.92146035651551e+54,1.40754656054243e+61,6.78153317747018e+67,3.26733450233629e+74,1.57419835290562e+81,7.58447187424416e+87,3.65419101856605e+94,1.76058561388157e+101,8.4824840632312e+107,4.08685242793079e+114,1.96904145584678e+121},
  {2.69483300794714e-05,19.8615308113507,67882317.3610891,333399256162192.0,1.7910124584828e+21,9.83870107703129e+27,5.43502556296107e+34,3.00657111875056e+41,1.66376843813567e+48,9.20772115325916e+54,5.09590009527905e+61,2.82027864442353e+68,1.56085918534909e+75,8.63844511004665e+81,4.7808758775557e+88,2.64593620172381e+95,1.46437150851936e+102,8.10444301876948e+108,4.48533697113142e+115,2.48237265653899e+122},
  {2.48903728495461e-05,20.756658645479,81181003.9801199,457568421119252.0,2.82288381871626e+21,1.78119887357688e+28,1.13025333913404e+35,7.18207736103172e+41,4.56538151139541e+48,2.90229966344659e+55,1.84508752248033e+62,1.17298937571671e+69,7.45713115886722e+75,4.74077816625459e+82,3.01389087469288e+89,1.91604375504608e+96,1.21810106722043e+103,7.74392655724191e+109,4.92310532827198e+116,3.12980319430148e+123},
  {2.29919937129844e-05,21.6940310290068,97093374.1541917,628036289693336.0,4.44963764218223e+21,3.22495970957922e+28,2.35064604976713e+35,1.71579701975751e+42,1.25284834248365e+49,9.14891466983711e+55,6.68113537226297e+62,4.87902867912172e+69,3.56301024931179e+76,2.60196183821081e+83,1.90013654735509e+90,1.38761411627006e+97,1.01333398842577e+104,7.40008163254609e+110,5.40406310380724e+117,3.94642917234286e+124},
  {2.12405925009008e-05,22.675687033971,116134566.167392,862084884842335.0,7.01443750784718e+21,5.83946056992313e+28,4.88917108393396e+35,4.09938108245628e+42,3.43840067006988e+49,2.88425368089008e+56,2.4194693452061e+63,2.02959421460177e+70,1.70254623467495e+77,1.42819913039112e+84,1.19806023025278e+91,1.00500575589441e+98,8.43059930862504e+104,7.07209927730048e+111,5.93250685676207e+118,4.97654744772764e+125},
  {1.96245854500584e-05,23.7037658785559,138921503.785646,1.18345365591503e+15,1.10585187177312e+22,1.05744323103589e+29,1.0169957113035e+36,9.79504798436493e+42,9.43735635744362e+49,9.09354511304613e+56,8.76245635975422e+63,8.44346977691792e+70,8.1361069540703e+77,7.83993564114697e+84,7.55454624751018e+91,7.27954576057748e+98,7.01455587605731e+105,6.75921215748973e+112,6.51316345794382e+119,6.27607141854978e+126},
  {1.81333211387212e-05,24.7805119050294,166193053.281834,1.62475457882719e+15,1.74355769317388e+22,1.91503468065931e+29,2.11562288933317e+36,2.34061557869142e+43,2.59047541029701e+50,2.86726770953189e+57,3.17370722209485e+64,3.5129173989117e+71,3.88838833427497e+78,4.30399223138527e+85,4.76401767929315e+92,5.27321234123849e+99,5.83683151944888e+106,6.460692274261e+113,7.15123342828259e+120,7.91558201184548e+127},
  {1.67570035776739e-05,25.9082798076424,198834180.374997,2.23079131374184e+15,2.74922521824343e+22,3.46841334958053e+29,4.40141191566537e+36,5.59355916870638e+43,7.11120527723158e+50,9.04144580656304e+57,1.14958866715036e+65,1.46167071089798e+72,1.85847719177812e+79,2.36300739940608e+86,3.00450524368955e+93,3.82015391193096e+100,4.85723099431862e+107,6.17584880320779e+114,7.85243866268505e+121,9.98418110957924e+128},
  {1.54866218274891e-05,27.0895401231359,237904902.285648,3.06312112322467e+15,4.33529182383961e+22,6.28230574906573e+29,9.15756025376593e+36,1.33684295996449e+44,1.9522748901066e+51,2.85129094518077e+58,4.16439675223374e+65,6.08226254400078e+72,8.88339250122539e+79,1.29745617104622e+87,1.89498850459712e+94,2.76770930180183e+101,4.04235424317871e+108,5.90402606215426e+115,8.62307498499459e+122,1.25943587342902e+130},
  {1.43138855703645e-05,28.3268849971501,284674988.466147,4.20632524776404e+15,6.83690871617486e+22,1.13799592991423e+30,1.90546498760949e+37,3.19525827382521e+44,5.36009070738919e+51,8.99246184872078e+58,1.50867308357083e+66,2.53112852722094e+73,4.24652695046577e+80,7.12448912909548e+87,1.1952908939852e+95,2.00536533598099e+102,3.36444473371585e+109,5.64460159909765e+116,9.47007002508344e+123,1.58881410341264e+131},
  {1.32311661166916e-05,29.6230342405027,340665553.506159,5.77662808008874e+15,1.0782862675017e+23,2.06155625437677e+30,3.96510781903202e+37,7.63773141545457e+44,1.47175713224398e+52,2.83627614445881e+59,5.46601758133411e+66,1.05340669344342e+74,2.03012022191787e+81,3.91243918039715e+88,7.5400370738433e+95,1.45311294951798e+103,2.80043351965577e+110,5.39698439257519e+117,1.04010469592104e+125,2.0044856532506e+132},
  {1.2231442373486e-05,30.9808416900185,407698913.546745,7.93374566685916e+15,1.70075067288725e+23,3.73492554758539e+30,8.25165962151635e+37,1.82580785763076e+45,4.04140555932906e+52,8.94644911047424e+59,1.98051976959085e+67,4.38440055495251e+74,9.70603616631872e+81,2.14868991863771e+89,4.75669852443697e+96,1.05302217766864e+104,2.33114566193107e+111,5.16061315724613e+118,1.1424394709959e+126,2.5290947126583e+133},
  {1.13082513443749e-05,32.40330188934,487958350.832714,1.08971744106276e+16,2.68274233914745e+23,6.76706637389338e+30,1.71735206214274e+38,4.36493205479594e+45,1.10984018639437e+53,2.82217932432494e+60,7.17660537020507e+67,1.82497155932111e+75,4.64080990587513e+82,1.18013480559397e+90,3.00102421053763e+97,7.63145572703867e+104,1.94064135325795e+112,4.93495474799533e+119,1.25493452629411e+127,3.19123628452164e+134},
  {1.04556427694297e-05,33.8935571059355,584059758.876463,1.49685852110398e+16,4.23202743467286e+23,1.22616839093992e+31,3.57444449831621e+38,1.04359284953343e+46,3.04803288820708e+53,8.90327333396579e+60,2.60069929780269e+68,7.5968432983528e+75,2.2190998523047e+83,6.48217397595777e+90,1.89349674068861e+98,5.53106103592333e+105,1.61566881548615e+113,4.71950265633829e+120,1.37860588245631e+128,4.02702216252362e+135},
  {9.66813754814256e-06,35.4549047013477,699137533.996963,2.05626132651436e+16,6.67649706451701e+23,2.22193048429418e+31,7.44026577732011e+38,2.49525750609742e+46,8.37162025577707e+53,2.80895949152062e+61,9.42522841615103e+68,3.16257551725322e+76,1.06118371933954e+84,3.5607412486963e+91,1.19478646355037e+99,4.0090380831657e+106,1.34520995483538e+114,4.51377559331464e+121,1.51457176190597e+129,5.08205951924388e+136},
  {8.94068962060557e-06,37.0908048725977,836947550.824361,2.82491934506062e+16,1.05336532526931e+24,4.02662309636665e+31,1.54881127414023e+39,5.96663960643541e+46,2.29947954915065e+54,8.86280932014751e+61,3.41604660681059e+69,1.31667564033372e+77,5.0749816025894e+84,1.95609664465258e+92,7.5395631849661e+99,2.90604324285954e+107,1.12010300493098e+115,4.31731615348256e+122,1.66406292046008e+130,6.41395094791122e+137},
  {8.268651010792e-06,38.8048887835642,1001990625.41756,3.88117738548113e+16,1.66203071326239e+24,7.29761854508733e+31,3.22432059353988e+39,1.42683550006908e+47,6.31653993584022e+54,2.79657839854015e+62,1.23818447484145e+70,5.48209251710711e+77,2.42721378237691e+85,1.07465698077667e+93,4.75808000456143e+100,2.10665600973599e+108,9.32729076761029e+115,4.12968955496871e+123,1.82843402780939e+131,8.09545354405689e+138},
  {7.6477397620189e-06,40.6009671061654,1199660548.78358,5.33273669710706e+16,2.62257706296934e+24,1.32266699903072e+32,6.7128526225496e+39,3.41229983418947e+47,1.73523428664426e+55,8.82494019542252e+62,4.48824029377698e+70,2.28266983346652e+78,1.16094264905502e+86,5.90443844508482e+93,3.00293875228967e+101,1.52726486191859e+109,7.76751763809784e+116,3.95048245089041e+124,2.00917620374665e+132,1.021847095453e+140},
  {7.07401051846071e-06,42.4830389920516,1436421588.42726,7.32766363977156e+16,4.13853074665694e+24,2.39744463010242e+32,1.39767023093179e+40,8.16110885716498e+47,4.7672255625155e+55,2.78500032314852e+63,1.62702997165158e+71,9.50535946148619e+78,5.55318586038747e+86,3.24426290840718e+94,1.89535216389354e+102,1.10729617588643e+110,6.46900798649823e+117,3.77930180776856e+125,2.20793082794312e+133,1.28990982710652e+141},
  {6.5438275282e-06,44.4553014967876,1720021333.25012,1.00695296417524e+17,6.53119072464727e+24,4.34585168828448e+32,2.91025178224762e+40,1.95199815186096e+48,1.30978956949552e+56,8.78955674850676e+63,5.89852265246187e+71,3.95842331867284e+79,2.6564515413508e+87,1.7827142205651e+95,1.19635922294074e+103,8.02863077357317e+110,5.38792289596493e+118,3.61577384684347e+126,2.42650475311797e+134,1.62839977467184e+142},
  {6.05383986295393e-06,46.5221594794182,2059745930.24538,1.38382338957876e+17,1.03078086725075e+25,7.87823649065469e+32,6.06016164544851e+40,4.66914573119793e+48,3.59886163372782e+56,2.77419186885098e+64,2.13854673454036e+72,1.64855607111833e+80,1.27083562928671e+88,9.79659629817202e+95,7.55198439767423e+103,5.82166172877826e+111,4.48779336760102e+119,3.45954304448739e+127,2.66688706473244e+135,2.05584567824689e+143},
  {5.60095866748888e-06,48.6882360016026,2466726169.11839,1.90186432528887e+17,1.62692560468764e+25,1.42827055709754e+33,1.26201701279319e+41,1.11692191507255e+49,9.88908540457743e+56,8.75655682982217e+64,7.75392499120284e+72,6.8661385998924e+80,6.08000900623136e+88,5.38388842341486e+96,4.76746948717161e+104,4.22162646861878e+112,3.73827880776669e+120,3.31027118814187e+128,2.9312675449739e+136,2.59565725364912e+144},
  {5.18233626799532e-06,50.9583832516994,2954304560.15504,2.61399860056282e+17,2.56800563875724e+25,2.58951769078277e+33,2.62828912408694e+41,2.67199180920253e+49,2.71752803170824e+57,2.76412178403331e+65,2.8115860017741e+73,2.85988345709386e+81,2.90901519583778e+89,2.9589921768435e+97,3.00982806345205e+105,3.06153739360572e+113,3.11413511772493e+121,3.16763648445816e+129,3.22205701495031e+137,3.27741249967787e+145},
  {4.79534698349404e-06,53.3376940204892,3538475577.72886,3.59300401872049e+17,4.05369217026722e+25,4.69519669227833e+33,5.47403505990468e+41,6.39254716070856e+49,7.46824308640756e+57,8.72584480666814e+65,1.01954795341783e+74,1.19127111971602e+82,1.39191996776761e+90,1.62636526703978e+98,1.90029908900076e+106,2.22037250256514e+114,2.59435691441384e+122,3.03133271652507e+130,3.54190974681133e+138,4.13848489391981e+146},
  {4.43756949781782e-06,55.831513756581,4238413674.44748,4.93896761803131e+17,6.39928811624284e+25,8.51363052711079e+33,1.14016606332132e+42,1.52946258538812e+50,2.05252736949989e+58,2.7547607977737e+66,3.69734554431263e+74,4.96248251218087e+82,6.66052769875038e+90,8.93960774832319e+98,1.19985380086709e+107,1.61041649731495e+115,2.16146442949322e+123,2.90106844727057e+131,3.89374815714027e+139,5.22610031038401e+147},
  {4.10677066198186e-06,58.4454532309921,5077106590.32207,6.78954041062629e+17,1.01027188320755e+26,1.5438372204337e+34,2.37494931042245e+42,3.65956506353741e+50,5.6413775632884e+58,8.6973310682424e+66,1.34090534628543e+75,2.0673455042115e+83,3.18734233314026e+91,4.91410615822929e+99,7.57635649438835e+107,1.16808993005893e+116,1.80091062817823e+124,2.77656626631953e+132,4.28079001461552e+140,6.59993725823779e+148},
  {3.80089060793591e-06,61.1854018418901,6082114985.01822,9.33404537730503e+17,1.59503487186501e+26,2.79971306933631e+34,4.94727312594184e+42,8.75679930033392e+50,1.55062465378997e+59,2.74608147056477e+67,4.86330505450478e+75,8.61296031777637e+83,1.52536610171661e+92,2.70144364942156e+100,4.78429311397943e+108,8.47304780542937e+116,1.5005882344841e+125,2.65756207775028e+133,4.70657841879169e+141,8.33541409997788e+149},
  {3.51802906487747e-06,64.057541592079,7286483626.29649,1.28328875043435e+18,2.51841344864001e+26,5.07750628036294e+34,1.03062899371839e+43,2.09549314798903e+51,4.26238944862753e+59,8.67093157527802e+67,1.76396444494812e+76,3.5885314300885e+84,7.30036200954303e+92,1.48515648918011e+101,3.02134335443749e+109,6.14650103653691e+117,1.25041979024196e+126,2.54380442636815e+134,5.17501483318517e+142,1.05278449273761e+151},
  {3.25643277859343e-06,67.0683617734769,8729834414.73771,1.76442597030592e+18,3.9765682007411e+26,9.20898928318896e+34,2.14715490352612e+43,5.01477724370483e+51,1.17172075781464e+60,2.73805805839327e+68,6.39841926796436e+76,1.49522178047806e+85,3.49413157117931e+93,8.16531744866839e+101,1.90812551225987e+110,4.45903430905505e+118,1.04201673161766e+127,2.43505386025628e+135,5.69039548486173e+143,1.32976938645625e+152},
  {3.01448394276692e-06,70.224674394582,10459677582.5419,2.42608886815882e+18,6.27934049843481e+26,1.67031220470879e+35,4.47351178647448e+43,1.20016576723555e+52,3.22121198850781e+60,8.64656744969e+68,2.32102463126401e+77,6.23043919830762e+85,1.67246985751966e+94,4.48950146454543e+102,1.20514133097535e+111,3.23502659914793e+119,8.68395838428633e+127,2.3310823275054e+136,6.25745147472526e+144,1.67972183995875e+153},
  {2.79068955891195e-06,73.5336303887766,12532984675.2252,3.33605975161773e+18,9.91615866329529e+26,3.02975264200272e+35,9.32089520541001e+43,2.87246439358171e+52,8.85601451979035e+60,2.73066638880828e+69,8.41997174659318e+77,2.5963039847235e+86,8.00573434166549e+94,2.46857878060044e+103,7.61189614258274e+111,2.34713855845145e+120,7.23743380821427e+128,2.23167260516187e+137,6.8813929780173e+145,2.12188692970594e+154},
  {2.58367164864927e-06,77.0027366432462,15018075652.7133,4.58758831906485e+18,1.56601669264468e+27,5.49591710479791e+35,1.94218298885332e+44,6.87529843089231e+52,2.43489823083949e+61,8.62416460015361e+69,3.05467492666398e+78,1.08197169275862e+87,3.83237087415362e+95,1.35743594949949e+104,4.80807471950006e+112,1.70303306959912e+121,6.03218923268319e+129,2.13661775854438e+138,7.56795795343393e+146,2.68059119895501e+155},
  {2.39215824847214e-06,80.6398738903383,17996882922.7931,6.30896642295251e+18,2.4732752502568e+27,9.97002655712859e+35,4.04711743432155e+44,1.64570350314184e+53,6.69493627925374e+61,2.72388374776276e+70,1.10826216115212e+79,4.50919894649802e+87,1.83466605904992e+96,7.46474267196957e+104,3.0371951781762e+113,1.23574987120187e+122,5.02792104140106e+130,2.04572062920457e+139,8.32346582221672e+147,3.38658574938156e+156},
  {2.21497512302682e-06,84.4533155053243,21567667695.9194,8.67670474512958e+18,3.90635156526654e+27,1.80873633592799e+36,8.43381892739455e+44,3.93943953131318e+53,1.84091987698331e+62,8.60365338000231e+70,4.02108095205602e+79,1.87934148445389e+88,8.78353483076069e+96,4.10518885319834e+105,1.91865548982282e+114,8.96728291611165e+122,4.19106837374973e+131,1.95879334990572e+140,9.15487662589773e+148,4.27874466942608e+157},
  {2.05103813830013e-06,88.45174725678,25848279147.2175,1.19336671561596e+19,6.17010684668603e+27,3.28153235778963e+36,1.75762093735531e+45,9.43060950108593e+53,5.06227582359155e+62,2.71768877615534e+71,1.45903464884289e+80,7.83311463661749e+88,4.20536898431934e+97,2.25773995784723e+106,1.21211486673358e+115,6.50749208114258e+123,3.49368320060049e+132,1.87565688509383e+141,1.00698562235825e+150,5.40621289427418e+158},
  {1.89934624100943e-06,92.6442880581759,30980064995.0099,1.6414029125802e+19,9.7462199027392e+27,5.9538827572932e+36,3.66309617245623e+45,2.25770525646098e+54,1.39212707635832e+63,8.58496827424858e+71,5.29432445810957e+80,3.26501681932069e+89,2.01354363388815e+98,1.24175768359523e+107,7.65795330114635e+115,4.72268069089192e+124,2.91249008475924e+133,1.79614059543319e+142,1.10768481472615e+151,6.83112253029839e+159},
  {1.75897499497213e-06,97.0405117717528,37132563862.7368,2.2577629541305e+19,1.53957757744382e+28,1.08030332326508e+37,7.63472274088052e+45,5.40525978204435e+54,3.8285454013838e+63,2.71206137511727e+72,1.92122109242467e+81,1.36100026087942e+90,9.64139394660718e+98,6.83001469146214e+107,4.83841921919745e+116,3.42756234594804e+125,2.4281037221401e+134,1.7200818250565e+143,1.2185152797105e+152,8.63202822922251e+160},
  {1.62907062932812e-06,101.650470118384,44509135912.2238,3.10572532047768e+19,2.43213956000657e+28,1.96025552040955e+37,1.59132819641081e+46,1.29415840544371e+55,1.05295609161263e+64,8.56804761287497e+72,6.97213322975781e+81,5.67351924933165e+90,4.61679031506485e+99,3.75688549372888e+108,3.05714342608628e+117,2.48773251129993e+126,2.0243777368776e+135,1.64732551026906e+144,1.3405014728781e+153,1.09082521200523e+162},
  {1.50884455723478e-06,106.484716749878,53353719596.8756,4.27237140078678e+19,3.84234758392217e+28,3.557139511528e+37,3.31701537613067e+46,3.09870006933379e+55,2.89606269714192e+64,2.7069826191953e+73,2.53031882920666e+82,2.36520122557877e+91,2.21086238343367e+100,2.06659568065742e+109,1.93174311107857e+118,1.80569019141194e+127,1.6878626724001e+136,1.57772380851641e+145,1.47477188620639e+154,1.37853793220272e+163},
  {1.39756832708055e-06,111.554332543071,63958940035.6251,5.87754438875665e+19,6.07051805794197e+28,6.45520527288748e+37,6.91442636765638e+46,7.41980669395575e+55,7.96574872055986e+64,8.55283330786797e+73,9.18344779749205e+82,9.86062862451122e+91,1.05877630933053e+101,1.13685223723224e+110,1.22068574963142e+119,1.3107013312087e+128,1.40735483483477e+137,1.51113574649655e+146,1.62256965252015e+155,1.74222089820105e+164}
  };
