% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_functions.R
\name{pseudo_res_discrete}
\alias{pseudo_res_discrete}
\title{Calculate pseudo-residuals for discrete-valued observations}
\usage{
pseudo_res_discrete(
  obs,
  dist,
  par,
  stateprobs,
  normal = TRUE,
  randomise = TRUE,
  seed = NULL
)
}
\arguments{
\item{obs}{vector of discrete-valued observations (of length n)}

\item{dist}{character string specifying which parametric CDF to use (e.g., \code{"norm"} for normal or \code{"pois"} for Poisson) or CDF function to evaluate directly.}

\item{par}{named parameter list for the parametric CDF

Names need to correspond to the parameter names in the specified distribution (e.g. \code{list(mean = c(1,2), sd = c(1,1))} for a normal distribution and 2 states).
This argument is as flexible as the parametric distribution allows. For example you can have a matrix of parameters with one row for each observation and one column for each state.}

\item{stateprobs}{matrix of local state probabilities for each observation (of dimension c(n,N), where N is the number of states)}

\item{normal}{logical, if \code{TRUE}, returns Gaussian pseudo residuals

These will be approximately standard normally distributed if the model is correct.}

\item{randomise}{logical, if \code{TRUE}, return randomised pseudo residuals. Recommended for discrete observations.}

\item{seed}{integer, seed for random number generation}
}
\value{
vector of pseudo residuals
}
\description{
For HMMs, pseudo-residuals are used to assess the goodness-of-fit of the model. 
These are based on the cumulative distribution function (CDF)
\deqn{F_{X_t}(x_t) = F(x_t \mid x_1, \dots, x_{t-1}, x_{t+1}, \dots, x_T)}
and can be used to quantify whether an observation is extreme relative to its model-implied distribution.

This function calculates such residuals for \strong{discrete-valued} observations, based on the local state probabilities obtained by \code{\link{stateprobs}} or \code{\link{stateprobs_g}} and the respective parametric family.
}
\details{
For discrete observations, calculating pseudo residuals is slightly more involved, as the CDF is a step function.
Therefore, one can calculate the lower and upper CDF values for each observation. 
By default, this function does exactly that and then randomly samples the interval in between to give approximately Gaussian psuedo-residuals.
If \code{randomise} is set to \code{FALSE}, the lower, upper and mean pseudo-residuasl are returned.
}
\examples{
obs = rpois(100, lambda = 1)
stateprobs = matrix(0.5, nrow = 100, ncol = 2)
par = list(lambda = c(1,2))
pres = pseudo_res_discrete(obs, "pois", par, stateprobs)
}
