% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSys.CriticalPoint.R
\name{AQSys.CritPoint}
\alias{AQSys.CritPoint}
\title{ATPS Critical Point Calculation}
\usage{
\method{AQSys}{CritPoint}(dataSET, tldata, method, modelName = "merchuk",
  slope = NULL, NP = 100, xmax = 30, xlbl = "", ylbl = "",
  Order = "xy", ext = FALSE, ...)
}
\arguments{
\item{dataSET}{- Binodal Experimental data that will be used in the nonlinear fit. [type:data.frame]}

\item{tldata}{- A data.frame with two columns containing a set of Tieline's Slopes (S)
and its bottom-rich component composition in the bottom phase (XB). [type:data.frame]}

\item{method}{- Binodal Experimental data that will be used in the nonlinear fit. [type:string]
"algebraic" - Uses the critical point own definition to set up constraints and solve a system of equations.
"numerical" - A number of tie-lines are calculated successively until TLL is close to zero and concentration of components are numerically equal. A constant slope is assumed.
"polynomial" - Calculate the intercept point between the chosen mathematical description and a third order polynomial fitting the tie-lines mid-points}

\item{modelName}{- Mathematical descriptor that will be used for non-linear fitting. 
Use AQSysList() to list the available equations. [type:string]}

\item{slope}{The method assumes all tielines for a given ATPS are parallel, thus only one slope is required. [type:double]}

\item{NP}{Number of points used to build the fitted curve. Default is 100. [type:integer]}

\item{xmax}{Maximum value for the Horizontal axis' value (bottom-rich component). [type:double]}

\item{xlbl}{Plot's Horizontal axis label. [type:string]}

\item{ylbl}{Plot's Vertical axis label. [type:string]}

\item{Order}{Defines how the data is organized in the Worksheet. 
Use "xy" whether the first column corresponds to the lower phase fraction and "yx" whether the opposite. [type:string]}

\item{ext}{- False: Return only XC and YC. True: return an extended output result, 
including phase diagram plot and an data.frame including the calculated data. [type:boolean]}

\item{...}{Additional optional arguments. None are used at present.}
}
\value{
(XC,YC) - The function returns Tieline's Critical Point Composition
}
\description{
Merchuk et al. described a very straightforward method to calculate the critical composition of a given Binodal
curve and its Tielines.
}
\details{
Using the binodal data, tieline's Slopes (S), the composition of bottom-rich component in the bottom phase (XB)
and an equation which stablish a relatioship between them, this function returns the critical composition of the binodal
under study. When used within a iterative function, mrchk.tielines() can be used to obtain TLL and S and therefore
calculate the critical composition.
}
\examples{
\dontrun{
AQSys.CritPoint(dataSET, tldata)
}
}
