% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{get_jira_issues}
\alias{get_jira_issues}
\title{Retrieves all issues of a JIRA query as a \code{data.frame}}
\usage{
get_jira_issues(
  domain = NULL,
  username = NULL,
  password = NULL,
  jql_query,
  fields = basic_jql_fields(),
  maxResults = 50,
  verbose = FALSE,
  as.data.frame = TRUE
)
}
\arguments{
\item{domain}{Custom JIRA domain URL as for example
\href{https://bugreports.qt.io}{https://bugreports.qt.io}. Can be passed as a
parameter or can be previously defined through the \code{save_jira_credentials()} function.}

\item{username}{Username used to authenticate the access to the JIRA \code{domain}.
If both username and password are not passed no authentication is made and only
 public domains can bet accessed. Optional parameter.}

\item{password}{Password used to authenticate the access to the JIRA \code{domain}.
If both username and password are not passed no authentication is made and only
 public domains can bet accessed. Optional parameter.}

\item{jql_query}{JIRA's decoded JQL query. By definition, it works with:
\itemize{
\item Fields
\item Operators
\item Keywords
\item Functions
}
To learn how to create a query visit
\href{https://confluence.atlassian.com/jirasoftwareserver/advanced-searching-939938733.html}{this ATLASSIAN site}
or the following \href{https://3kllhk1ibq34qk6sp3bhtox1-wpengine.netdna-ssl.com/wp-content/uploads/2017/12/atlassian-jql-cheat-sheet-2.pdf}{cheatsheet}.}

\item{fields}{Optional argument to define the specific JIRA fields to obtain.
 If no value is entered, by default the following fields are passed:
\itemize{
\item status
\item priority
\item created
\item reporter
\item summary
\item description
\item assignee
\item updated
\item issuetype
\item fixVersions
}
To obtain a list of all supported fields use the following function: \code{supported_jql_fields()}.}

\item{maxResults}{Max results authorized to obtain for each API call. By default JIRA sets this value to 50 issues.}

\item{verbose}{Explicitly informs the user of the JIRA API request process.}

\item{as.data.frame}{Defines if the function returns a flattened \code{data.frame} or the raw JIRA response.}
}
\value{
Returns a flattened, formatted \code{data.frame} with the issues according to the JQL query.
}
\description{
Calls JIRA's latest REST API, optionally with basic authentication,
 to get all issues of a JIRA query (JQL). Allows to specify which fields to obtain.
}
\section{Warning}{

If the \code{comment} field is used as a \code{fields} parameter input, each issue and its
attributes are repeated the number of comments the issue has. The function works with the
 latest JIRA REST API and to work you need to have a internet connection. Calling the function
 too many times might block your access, you will receive a 403 error code. To unblock your
 access you will have to access interactively through your browser, signing out and signing
 in again, and might even have to enter a CAPTCHA at
 https://jira.yourdomain.com/secure/Dashboard.jspa. This only happens if the API
 is called upon multiple times in a short period of time.
}

\examples{
get_jira_issues(domain = "https://bugreports.qt.io",
                jql_query = 'project="QTWB"')
}
\seealso{
For more information about Atlassians JIRA API visit the following link:
\href{https://docs.atlassian.com/software/jira/docs/api/REST/8.9.1/}{JIRA API Documentation}.
}
