% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{save_jira_credentials}
\alias{save_jira_credentials}
\title{Saves domain and the domain's credentials in the environment}
\usage{
save_jira_credentials(
  domain = NULL,
  username = NULL,
  password = NULL,
  verbose = FALSE
)
}
\arguments{
\item{domain}{The users' JIRA server domain to retrieve information from.
An example would be \href{https://bugreports.qt.io}{https://bugreports.qt.io}.
It will be saved in the environment as JIRAGILER_DOMAIN.}

\item{username}{The users' username to authenticate to the \code{domain}.
It will be saved in the environment as JIRAGILER_USERNAME.}

\item{password}{The users' password to authenticate to the \code{domain}.
It will be saved in the environment as JIRAGILER_PASSWORD. If \code{verbose}
is set to \code{TRUE}, it will message asterisks.}

\item{verbose}{Optional parameter to inform the user when the users'
credentials have been saved.}
}
\value{
Saves the credentials in the users environment - it does not return any object.
}
\description{
Saves the domain and/or username and password in
the users' environment. It has the advantage that it is not necessary
to explicitly publish the credentials in the users code. Just do it one
time and you are set. To update any of the parameters just save again and
it will overwrite the older credential.
}
\examples{
\dontrun{
save_jira_credentials(domain="https://bugreports.qt.io",
                      username='__INSERT_YOUR_USERNAME_HERE__',
                      password='__INSERT_YOUR_PASSWORD_HERE__')
}
}
