% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdt_simple_index.R
\name{add_index.simple_mediation}
\alias{add_index.simple_mediation}
\title{add_index method for simple mediation}
\usage{
\method{add_index}{simple_mediation}(mediation_model, times = 5000, level = 0.05, ...)
}
\arguments{
\item{mediation_model}{A mediation model of class \code{"simple_mediation"}.}

\item{times}{Number of simulations to use to compute the Monte Carlo indirect
effect confidence interval.}

\item{level}{Alpha threshold to use for the confidence interval.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
Adds confidence interval for the index of  mediation to a model
fitted with \code{\link{mdt_simple}}.
}
\details{
Indirect effect index for simple mediation uses \eqn{a} and \eqn{b}
estimates and their standard errors to compute the \eqn{ab} product
distribution using Monte Carlo methods (see MacKinnon, Lockwood, &
Williams, 2004).
}
\examples{
## getting an indirect effect index
ho_et_al$condition_c <- build_contrast(ho_et_al$condition,
                                       "Low discrimination",
                                       "High discrimination")
simple_model <- mdt_simple(data = ho_et_al,
                           IV = condition_c,
                           DV = hypodescent,
                           M = linkedfate)
add_index(simple_model)

}
\references{
MacKinnon, D. P., Lockwood, C. M., & Williams, J. (2004).
Confidence Limits for the Indirect Effect: Distribution of the Product and
Resampling Methods. \emph{Multivariate Behavioral Research}, \emph{39}(1),
99-128. doi: 10.1207/s15327906mbr3901_4
}
