% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/character_get.stats.R
\name{get.stats}
\alias{get.stats}
\title{get.stats}
\source{
A minimal web application that extracts statistical results from single documents with \code{\link[JATSdecoder]{get.stats}} is hosted at: \href{https://www.get-stats.app}{https://www.get-stats.app/}

Statistical results extracted with \code{\link[JATSdecoder]{get.stats}} can be analyzed and used to identify articles stored in the PubMed Central library at: \href{https://www.scianalyzer.com}{https://www.scianalyzer.com/}.
}
\usage{
get.stats(
  x,
  output = "both",
  stats.mode = "all",
  recalculate.p = TRUE,
  checkP = FALSE,
  alpha = 0.05,
  criticalDif = 0.02,
  alternative = "undirected",
  estimateZ = FALSE,
  T2t = FALSE,
  R2r = FALSE,
  select = NULL,
  rm.na.col = TRUE,
  cermine = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{x}{NISO-JATS coded XML or DOCX file path or plain textual content.}

\item{output}{Select the desired output. One of c("both", "allStats", "standardStats").}

\item{stats.mode}{Select a subset of test results by p-value checkability for output. One of: c("all", "checkable", "computable", "uncomputable").}

\item{recalculate.p}{Logical. If TRUE recalculates p-values of test results if possible.}

\item{checkP}{Logical. If TRUE observed and recalculated p-values are checked for consistency.}

\item{alpha}{Numeric. Defines the alpha level to be used for error assignment.}

\item{criticalDif}{Numeric. Sets the absolute maximum difference in reported and recalculated p-values for error detection.}

\item{alternative}{Character. Select test sidedness for recomputation of p-values from t-, r- and beta-values. One of c("undirected", "directed"). If "directed" is specified, p-values for directed null-hypothesis are added to the table but still require a manual inspection on consistency of the direction.}

\item{estimateZ}{Logical. If TRUE detected beta-/d-value is divided by reported standard error "SE" to estimate Z-value ("Zest") for observed beta/d and recompute p-value. Note: This is only valid, if Gauss-Marcov assumptions are met and a sufficiently large sample size is used. If a Z- or t-value is detected in a report of a beta-/d-coefficient with SE, no estimation will be performed, although set to TRUE.}

\item{T2t}{Logical. If TRUE capital letter T is treated as t-statistic.}

\item{R2r}{Logical. If TRUE capital letter R is treated as correlation.}

\item{select}{Select specific standard statistics only (e.g.: c("t", "F", "Chi2")).}

\item{rm.na.col}{Logical. If TRUE removes all columns with only NA from standardStats.}

\item{cermine}{Logical. If TRUE CERMINE specific letter conversion will be peformed on allStats results.}

\item{warnings}{Logical. If FALSE warning messages are omitted.}
}
\value{
If output="all": list with two elements. E1: vector of extracted results by \code{\link[JATSdecoder]{allStats}} and E2: matrix of standard results by \code{\link[JATSdecoder]{standardStats}}.\cr If output="allStats": vector of extracted results by \code{\link[JATSdecoder]{allStats}}.\cr If output="standardStats": matrix of standard results by \code{\link[JATSdecoder]{standardStats}}.
}
\description{
Extracts statistical results from text string, XML, CERMXML, HTML or DOCX files. The result is a list with a vector containing all identified sticked results and a matrix containing the reported standard statistics and recalculated p-values if computation is possible.
}
\examples{
## Extract results from plain text input
x<-c("The mean difference of scale A was significant (beta=12.9, t(18)=2.5, p<.05).",
"The ANOVA yielded significant results on 
 faktor A (F(2,18)=6, p<.05, eta(g)2<-.22)",
"the correlation of x and y was r=.37.")
get.stats(x)

## Extract results from native NISO-JATS XML file
# download example XML file via URL if a connection is possible
x<-"https://journals.plos.org/plosone/article/file?id=10.1371/journal.pone.0114876&type=manuscript"
# file name
file<-paste0(tempdir(),"/file.xml")
# download URL as "file.xml" in tempdir() if a connection is possible
tryCatch({
  readLines(x,n=1)
  download.file(x,file)
  },
  warning = function(w) message(
  "Something went wrong. Check your internet connection and the link address."),
  error = function(e) message(
  "Something went wrong. Check your internet connection and the link address.")
)
# apply get.stats() to file
if(file.exists(file)) get.stats(file)
}
\references{
Böschen (2021). "Evaluation of JATSdecoder as an automated text extraction tool for statistical results in scientific reports.” \emph{Scientific Reports.} doi: \href{https://www.nature.com/articles/s41598-021-98782-3}{10.1038/s41598-021-98782-3}.
}
\seealso{
\code{\link[JATSdecoder]{study.character}} for extracting different study characteristics at once.
}
