% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_RunHYPE.R
\name{RunHYPE}
\alias{RunHYPE}
\title{Run HYPE model}
\usage{
RunHYPE(hype.path = NULL, info.dir = NULL, sequence = 0, p = FALSE, ...)
}
\arguments{
\item{hype.path}{Path to HYPE \code{.exe} executable (Windows) or HYPE file on Linux}

\item{info.dir}{Optional path to a separate directory containing the HYPE model setup (info.txt, GeoData.txt, etc.). If not specified, then the directory of \code{hype.path} will be used.}

\item{sequence}{Optional integer between 0 and 999 specifying which forcing files to use.}

\item{p}{Optional logical. If \code{TRUE}, then the \code{sequence} number will also be applied to the parameter file. Ignored if \code{FALSE} (default).}

\item{...}{Additional arguments passed on to \code{\link{system}}.}
}
\value{
Output messagess from the HYPE executable are printed to the console.
}
\description{
\code{RunHYPE} is a wrapper to run a HYPE model using a specified HYPE executable.
}
\details{
\code{RunHYPE} is a \code{\link{system}} wrapper to run a HYPE model via the system console. HYPE executables can be downloaded from the \href{https://sourceforge.net/projects/hype/files/}{official code repository}.
The path to the HYPE executable must be specified with \code{hype.path}. If your HYPE model is saved to a different directory than the HYPE executable (\code{hype.path}), then you can
specify the model directory with \code{info.dir}. The \code{sequence} argument can be used to specify which forcing files should be used for the simulation,
and \code{p} can be used to specify if the \code{sequence} number should also be applied to the parameter file.
Read more about how to run HYPE on the \href{http://hype.smhi.net/wiki/doku.php?id=start#how_to_run_hype}{HYPE wiki}.
}
\examples{
\dontrun{
RunHYPE()
}

}
