% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_UpstreamGroupSLCClasses.R
\name{UpstreamGroupSLCClasses}
\alias{UpstreamGroupSLCClasses}
\title{Calculate area-weighted upstream averages of grouped SLC class fractions.}
\usage{
UpstreamGroupSLCClasses(
  subid = NULL,
  gd,
  bd = NULL,
  gcl = NULL,
  type = c("landuse", "soil", "crop"),
  group = NULL,
  signif.digits = 3,
  progbar = TRUE
)
}
\arguments{
\item{subid}{Integer vector of SUBIDs for which to calculate upstream properties (must exist in \code{gd}).
If \code{NULL} (default), upstream areas for all SUBIDs will be calculated.}

\item{gd}{A data frame containing a column with SUBIDs and a column with areas, e.g. an imported 'GeoData.txt' file imported with \code{\link{ReadGeoData}}.}

\item{bd}{A data frame, containing 'BRANCHID' and 'SOURCEID' columns, e.g. an imported 'BranchData.txt' file. Optional argument.}

\item{gcl}{Data frame containing columns with SLCs and corresponding land use and soil class IDs, typically a 'GeoClass.txt'
file imported with \code{\link{ReadGeoClass}}. Must be provided if no \code{group} argument is given.}

\item{type}{Keyword character string for use with \code{gcl}. Type of grouping index, choice of \code{"landuse"}, \code{"soil"}, and/or \code{"crop"},
can be abbreviated.}

\item{group}{Integer vector, of same length as number of SLC classes in \code{gd}. Alternative grouping index specification to \code{gcl} + \code{type}.}

\item{signif.digits}{Integer, number of significant digits to round upstream SLCs to. See also \code{\link{signif}}. Set to \code{NULL} to prevent rounding.}

\item{progbar}{Logical, display a progress bar while calculating SLC class fractions. Adds overhead to calculation time but useful when \code{subid}
is \code{NULL} or contains many SUBIDs.}
}
\value{
\code{UpstreamGroupSLCClasses} returns a data frame with SUBIDs in the first column, and upstream group fractions in the following columns.
}
\description{
Function to calculate averages of grouped SLC class fractions calculated from imported GeoData.txt and GeoClass.txt or any other user-defined grouping.
}
\details{
\code{UpstreamGroupSLCClasses} calculates area-weighted upstream averages of CropID fractions from SLC class fractions in a GeoData table and corresponding
grouping columns in a GeoClass table or a user-provided vector. Upstream calculations include branch connections in case of stream bifurcations but not
potential irrigation links or groundwater flows. Averages are weighted by sub-catchment area.

The function builds on \code{\link{GroupSLCClasses}}, which provides grouped sums of SLC classes for several or all sub-basins in a GeoData dataframe.
}
\note{
\code{UpstreamGroupSLCClasses} expects SLC class columns in argument \code{gd} to be ordered in ascending order.
}
\examples{
# Import source data
te1 <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
te2 <- ReadGeoClass(filename = system.file("demo_model", "GeoClass.txt", package = "HYPEtools"))
# Upstream land use fractions for single SUBID
UpstreamGroupSLCClasses(subid = 63794, gd = te1, gcl = te2, type = "landuse", progbar = FALSE)
# Upstream soil fraction for all SUBIDs in GeoData
UpstreamGroupSLCClasses(gd = te1, gcl = te2, type = "soil")

}
\seealso{
\code{\link{GroupSLCClasses}}
\code{\link{UpstreamSLCClasses}}
\code{\link{UpstreamGeoData}}
\code{\link{SumUpstreamArea}}
\code{\link{AllUpstreamSubids}}
}
