% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_SimToPar.R
\name{SimToPar}
\alias{SimToPar}
\alias{AllSimToPar}
\alias{BestSimsToPar}
\title{HYPE Calibration Outputs to par.txt}
\usage{
AllSimToPar(simfile, row, par)

BestSimsToPar(simfile, row, par)
}
\arguments{
\item{simfile}{Imported allsim.txt or bestsims.txt file imported as data frame.}

\item{row}{Integer, row number indicating row containing the parameter values that should be replaced/added to \code{par}.}

\item{par}{Imported par.txt file that should be updated using parameter values from \code{simfile}. Typically imported using \code{\link{ReadPar}}.}
}
\value{
\code{AllSimToPar} and \code{BestSimsToPar} return a list of named vectors in the format used by \code{\link{ReadPar}}.
}
\description{
Update par.txt with values from an allsim.txt or bestsims.txt file
}
\details{
\code{AllSimToPar} and \code{BestSimsToPar} can be used to update an existing par.txt file with the parameter values from a HYPE allsim.txt or bestsims.txt file.
If a parameter in the allsim or bestsims file already exists in \code{par}, then the parameter values will be overwritten in \code{par}. If the parameter does not exist,
then the parameter will be added to the bottom of the output.
}
\examples{
simfile <- read.table(file = system.file("demo_model", "results",
  "bestsims.txt",
  package = "HYPEtools"
), header = TRUE, sep = ",")
par <- ReadPar(filename = system.file("demo_model", "par.txt", package = "HYPEtools"))
BestSimsToPar(simfile, 1, par)

}
\seealso{
\code{\link{ReadPar}} for HYPE par.txt import; \code{\link{WritePar}} to export HYPE par.txt files
}
