% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{fast_Gp_sim}
\alias{fast_Gp_sim}
\title{Approximate GP simulation}
\usage{
fast_Gp_sim(covparms, covfun_name = "matern_isotropic", locs, m = 30)
}
\arguments{
\item{covparms}{A vector of covariance parameters appropriate
for the specified covariance function}

\item{covfun_name}{See \code{\link{GpGp}} for information about covariance
functions.}

\item{locs}{matrix of locations. Row \code{i} of \code{locs} specifies the location
of element \code{i} of \code{y}, and so the length of \code{y} should equal
the number of rows of \code{locs}.}

\item{m}{Number of nearest neighbors to use in approximation}
}
\value{
vector of simulated values
}
\description{
Calculates an approximation to the inverse Cholesky
factor of the covariance matrix using Vecchia's approximation,
then the simulation is produced by solving a linear system
with a vector of uncorrelated standard normals
}
\examples{
locs <- as.matrix( expand.grid( (1:50)/50, (1:50)/50 ) )
y <- fast_Gp_sim(c(4,0.2,0.5,0), "matern_isotropic",  locs, 30 )
fields::image.plot( matrix(y,50,50) )
}
