% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancestry_module.R
\name{ancestry_module}
\alias{ancestry_module}
\title{Creates a module to start simulations tracking local ancestry}
\usage{
ancestry_module(
  input_population = NA,
  number_of_founders = 2,
  initial_frequencies = NA,
  morgan = 1,
  markers = NA,
  track_junctions = FALSE
)
}
\arguments{
\item{input_population}{Potential earlier simulated population used as
starting point for the simulation. If not provided by the user, the
simulation starts from scratch.}

\item{number_of_founders}{Number of unique ancestors / ancestries to be
tracked in the simulation}

\item{initial_frequencies}{A vector describing the initial frequency of each
ancestor / ancestry. By default, equal frequencies are assumed. If a vector
not summing to 1 is provided, the vector is normalized.}

\item{morgan}{Length of the genomic stretch simulated, expressed in Morgan
(e.g. the number of crossovers during meiosis)}

\item{markers}{A vector of locations of markers, with the location in Morgan.
Ancestry at these marker positions is tracked for every generation.}

\item{track_junctions}{Tracks the average number of junctions over time if
TRUE}
}
\value{
list with type = "Ancestry". Can be used in simulate_admixture.
}
\description{
Module to perform simulations based on local ancestry
}
