% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Creating_gaps.R
\name{Creating_gaps}
\alias{Creating_gaps}
\title{Creating gaps in multivariate time series}
\usage{
Creating_gaps(data, rate, ngaps, begin = NULL)
}
\arguments{
\item{data}{input multivariate time series}

\item{rate}{size of a gap, as a percentage of input time series size}

\item{ngaps}{number of gaps to create on each signal}

\item{begin}{the starting position of a gap (random by default)}
}
\value{
Creating_gaps returns a multivariate time series with one gap per signal.
}
\description{
This function builds gaps (with the same size) in multivariate time series. 
The size of each gap is defined as a percentage of input data length.
By default, the position of each gap is randomly chosen.
}
\examples{
data(dataFSMUMI)
X <- dataFSMUMI[1:5000,]; #reduction for demo
rate <- 0.1
ngaps <- 1
incompleted_signal <- Creating_gaps(X, rate,1)
}
\author{
Thi-Thu-Hong Phan, Andre Bigand, Emilie Poisson-Caillault
}
