% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_plotting_functions.R
\name{map.FLightR.ggmap}
\alias{map.FLightR.ggmap}
\title{plots result over map}
\usage{
map.FLightR.ggmap(
  Result,
  dates = NULL,
  plot.cloud = TRUE,
  map.options = NULL,
  plot.options = NULL,
  save.options = NULL,
  zoom = "auto",
  return.ggobj = FALSE,
  seasonal.colors = TRUE,
  seasonal.donut.location = "topleft",
  seasonal.donut.proportion = 0.5,
  save = TRUE
)
}
\arguments{
\item{Result}{FLightR result object obtained from \code{\link{run.particle.filter}}}

\item{dates}{either NULL if all twilights should be included or data.frame with first column - start of the period and second end of the period. Each line represents a new period}

\item{plot.cloud}{Should probability cloud be plotted? If TRUE cloud is estimated by \code{\link[ggplot2]{stat_density2d}}}

\item{map.options}{options passed to \code{\link[ggmap]{get_map}}, note that \code{zoom} option is defined separately}

\item{plot.options}{plotting options. Not defined yet!}

\item{save.options}{options passed to \code{\link[ggplot2]{ggsave}}. Filename should be defined here.}

\item{zoom}{Zoom for map. If 'auto' FLightR will try to find optimal zoom level by downloading different size maps and checking whether all the points fit the map.}

\item{return.ggobj}{Should ggobj be returned for subsequent checks and/or replotting}

\item{seasonal.colors}{if true points of the track will have seasonal colors}

\item{seasonal.donut.location}{if NULL - no color wheel placed, otherwise select one of 'bottomleft', 'bottomright', 'topleft'}

\item{seasonal.donut.proportion}{how much of X axis should color wheel occupy.
return either NULL or ggplot2 class object}

\item{save}{should function save results with \code{\link[ggplot2]{ggsave}}?}
}
\value{
if 'return.ggobj=TRUE' return ggplot object otherwise returns 'NULL'.
}
\description{
plots track over map with probability cloud. Can plot only part of the track if dates are specified. Note that you can use it only after obtaining and registering in you current session Google Api Key. For details on the API key check [here](http://ornithologyexchange.org/forums/topic/38315-mapflightrggmap-error).
}
\examples{
File<-system.file("extdata", "Godwit_TAGS_format.csv", package = "FLightR")
# to run example fast we will cut the real data file by 2013 Aug 20
Proc.data<-get.tags.data(File, end.date=as.POSIXct('2013-06-25', tz='GMT'))
Calibration.periods<-data.frame(
       calibration.start=as.POSIXct(c(NA, "2014-05-05"), tz='GMT'),
       calibration.stop=as.POSIXct(c("2013-08-20", NA), tz='GMT'),
       lon=5.43, lat=52.93) 
       #use c() also for the geographic coordinates, if you have more than one calibration location
       # (e. g.,  lon=c(5.43, 6.00), lat=c(52.93,52.94))

# NB Below likelihood.correction is set to FALSE for fast run! 
# Leave it as default TRUE for real examples
Calibration<-make.calibration(Proc.data, Calibration.periods, likelihood.correction=FALSE)

Grid<-make.grid(left=0, bottom=50, right=10, top=56,
  distance.from.land.allowed.to.use=c(-Inf, Inf),
  distance.from.land.allowed.to.stay=c(-Inf, Inf))

all.in<-make.prerun.object(Proc.data, Grid, start=c(5.43, 52.93),
                             Calibration=Calibration, threads=2)
# here we will run only 1e4 partilces for a very short track.
# One should use 1e6 particles for the full run
Result<-run.particle.filter(all.in, threads=1,
           nParticles=1e3, known.last=TRUE,
           precision.sd=25, check.outliers=FALSE)

\dontrun{
map.FLightR.ggmap(Result, seasonal.donut.location=NULL, zoom=6, save=FALSE)
} 
# for this short track without variance seasonal donut does not work,
# but for normall track it will.
}
\author{
Eldar Rakhimberdiev
}
