% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_options.R
\name{unit_options}
\alias{unit_options}
\title{Unit options.}
\usage{
unit_options(
  unitvar2 = NULL,
  areaunits = "acres",
  minplotnum.unit = 10,
  unit.action = "keep",
  npixelvar = "npixels",
  ...
)
}
\arguments{
\item{unitvar2}{String. Name of a second level estimation unit variable in
unitarea and cond or pltassgn with assignment for each plot (e.g.,
'STATECD').}

\item{areaunits}{String. Units of areavar in unitarea ('acres', 'hectares').}

\item{minplotnum.unit}{Integer. Minimum number of plots for estimation unit.}

\item{unit.action}{String. What to do if number of plots in an estimation
unit is less than minplotnum.unit ('keep', 'remove' 'combine'). If
unit.action='combine', combines estimation unit to the following estimation
unit, ordered in unitzonal or stratalut.}

\item{npixelvar}{String. Name of variable in unitlut defining number of
pixels by estimation unit.}

\item{...}{For extendibility.}
}
\value{
A list of user-supplied parameters and parameter values for strata.
}
\description{
Returns a list of user-supplied parameters and parameter values for unit.
}
\details{
If no parameters, an empty list is returned.
}
\examples{

unit_options()

}
\author{
Grayson W. White
}
\keyword{options}
