% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETRep_Functions.R
\name{create_Elliptical_Tube}
\alias{create_Elliptical_Tube}
\title{Create a Discrete Elliptical Tube (ETRep)}
\usage{
create_Elliptical_Tube(
  numberOfFrames,
  method,
  materialFramesBasedOnParents = NA,
  initialFrame = diag(3),
  initialPoint = c(0, 0, 0),
  EulerAngles_Matrix = NA,
  ellipseResolution = 10,
  ellipseRadii_a,
  ellipseRadii_b,
  connectionsLengths,
  plotting = TRUE,
  add = FALSE
)
}
\arguments{
\item{numberOfFrames}{Integer, specifies the number of consecutive material frames.}

\item{method}{String, either "basedOnEulerAngles" or "basedOnMaterialFrames", defines the material frames method.}

\item{materialFramesBasedOnParents}{Array (3 x 3 x numberOfFrames) with pre-defined material frames.}

\item{initialFrame}{Matrix 3 x 3 as the initial frame}

\item{initialPoint}{Real vector with three elemets as the initial point}

\item{EulerAngles_Matrix}{Matrix of dimensions numberOfFrames x 3 with Euler angles to define material frames.}

\item{ellipseResolution}{Integer, resolution of elliptical cross-sections (default is 10).}

\item{ellipseRadii_a}{Numeric vector for the primary radii of cross-sections.}

\item{ellipseRadii_b}{Numeric vector for the secondary radii of cross-sections.}

\item{connectionsLengths}{Numeric vector for lengths of spinal connection vectors.}

\item{plotting}{Logical, enables plotting of the ETRep (default is TRUE).}

\item{add}{Logical, enables overlay plotting}
}
\value{
List containing tube details (orientation, radii, connection lengths, boundary points, etc.).
}
\description{
Constructs a discrete elliptical tube (ETRep) based on specified parameters.
}
\examples{
numberOfFrames<-15
EulerAngles_alpha<-c(rep(0,numberOfFrames))
EulerAngles_beta<-c(rep(-pi/20,numberOfFrames))
EulerAngles_gamma<-c(rep(0,numberOfFrames))
EulerAngles_Matrix<-cbind(EulerAngles_alpha,
                          EulerAngles_beta,
                          EulerAngles_gamma)
tube <- create_Elliptical_Tube(numberOfFrames = numberOfFrames,
                               method = "basedOnEulerAngles",
                               EulerAngles_Matrix = EulerAngles_Matrix,
                               ellipseResolution = 10,
                               ellipseRadii_a = rep(3, numberOfFrames),
                               ellipseRadii_b = rep(2, numberOfFrames),
                               connectionsLengths = rep(4, numberOfFrames),
                               plotting = FALSE)
 # Plotting
 plot_Elliptical_Tube(tube = tube,plot_frames = FALSE,
                      plot_skeletal_sheet = TRUE,
                      plot_r_project = FALSE,
                      plot_r_max = FALSE,add = FALSE)
}
\references{
Taheri, M., Pizer, S. M., & Schulz, J. (2024). "The Mean Shape under the Relative Curvature Condition." arXiv.
\doi{10.48550/arXiv.2404.01043}

Taheri Shalmani, M. (2024). "Shape Statistics via Skeletal Structures." University of Stavanger.
\doi{10.13140/RG.2.2.34500.23685}
}
