% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{ELCIC.glm.single}
\alias{ELCIC.glm.single}
\title{Variable selection in generalized linear models (GLM)}
\usage{
ELCIC.glm.single(x, y, index.var=NULL, name.var = NULL, dist)
}
\arguments{
\item{x}{A matrix containing covariates. The first column should contain all ones corresponding to the intercept if intercept is considered in your mean model.}

\item{y}{A vector containing outcomes.}

\item{index.var}{A vector containing index corresponding to candidate covariates (including the intercept). See more in details section.}

\item{name.var}{A vector containing names of candidate covariates. The names should be subset of column names of x matrix. See more in details section.}

\item{dist}{A specified distribution. It can be "gaussian", "poisson",and "binomial".}
}
\value{
A vector containing information criteria including ELCIC, AIC, BIC, and GIC.
}
\description{
The function \code{\link{ELCIC.glm.single}} provides values of several model selection criteria including AIC, BIC, GIC, and ELCIC, given a candidate mean model.
}
\details{
"x" and "y" should be all observed. The corresponding individual data will be omitted in analysis if any missingness is detected.

Either arguments "index.var" or "name.var" is used to identify the candidate mean model. If both arguments are provided, only the argument "name.var" will be used.
}
\examples{
## tests
# load data
data(glmsimdata)
x<-glmsimdata$x
y<-glmsimdata$y
#candidate model index
name.var<-c("intercept","x1","x2")
index.var<-c(1,2,3)
criteria<-ELCIC.glm.single(x, y, index.var =index.var, name.var = NULL, dist="poisson")
criteria

}
