#' Validate the performance of EBPRS
#'
#' @param fam fam file after processed by 'extractInfo'
#' @param score polygenic score generated by 'generateScore'
#' @export
#' @import stats ROCR
#' @description
#' Provide the performance evaluated by predictive r2 and AUC.
#' @references
#' Song, S., Jiang, W., Hou, L. and Zhao, H. Leveraging effect size distributions to improve polygenic risk scores derived from genome-wide association studies. \emph{Submitted}.
#' @examples
#' validate(fam=matrix(sample(0:1,20*6,replace=TRUE),ncol=6),score=rnorm(20,0,1))
#' @seealso
#' \code{\link{extractInfo}}
#'
#' \code{\link{findPara}}
#'
#' \code{\link{generateScore}}
#' @author
#' Shuang Song, Wei Jiang, Lin Hou and Hongyu Zhao




validate <- function(fam,score){
  truey <- fam[,6]
  if(length(table(truey))>2){
    loss <- which(truey==-9)
    score <- score[-loss]
    truey <- truey[-loss]
  }
  auc <- printAUC(score,truey)
  r2 <- cor(score,truey)^2
  print(paste("The R2 equals to",r2))
  print(paste("The AUC equals to",auc))
  return(list(r2=r2,AUC=auc))

}
