\name{coxsplit}
\alias{coxsplit}
\title{
Split Data for Cross-validation
}
\description{
Specify which fold each observation is in to obtain \code{foldid}.

\code{coxsplit} splits data by the `status' or/and `time' of \code{y}.
}
\usage{
coxsplit(y, nfolds, seeds = NULL)
}
\arguments{
  \item{y}{response variable. \code{y} should be a two-column matrix with columns named `time' and `status'. The latter is a binary variable, with `1' indicating death, and `0' indicating right censored.
}
  \item{nfolds}{number of folds.
}
  \item{seeds}{seeds for random split within each `status' of \code{y}. Default is \code{NULL}. For \code{seeds=NULL}, the split is performed based on the `time' of \code{y}. If \code{seeds} is supplied by user, data is randomly dividied within eath `status' of \code{y}.
}
}
\details{
\code{seeds=NULL} is incorporated in \code{Coxnet} by default. If random split is needed, \code{foldid} can be generated by \code{coxsplit} at the outset and input as an augment in \code{\link{Coxnet}}.
}
\value{
a vector of values between 1 and \code{nfolds} specifying which fold each observation is in.
}
\author{
Xiang Li, Donglin Zeng and Yuanjia Wang\cr
Maintainer: Xiang Li <xl2473@columbia.edu>
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{Coxnet}}, \code{\link{print.Coxnet}}
}
\examples{
set.seed(1213)
N=100
xb=rnorm(N)
ty=rexp(N,exp(xb))
tcens=rbinom(n=N,prob=.3,size=1)  # censoring indicator
y=cbind(time=ty,status=1-tcens)
foldid=coxsplit(y,10)  # 10-fold
}
\keyword{Cox model}
\keyword{Regularization}
\keyword{Split}

