% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/shiny-app.R
\name{write_shiny_app}
\alias{write_shiny_app}
\alias{write_shiny_app.Seurat}
\alias{write_shiny_app.default}
\title{Create the ClustAssess ShinyApp}
\usage{
write_shiny_app(
  object,
  metadata = NULL,
  assay_name = NULL,
  clustassess_object,
  project_folder,
  compression_level = 6,
  summary_function = stats::median,
  shiny_app_title = "",
  organism_enrichment = "hsapiens",
  height_ratio = 0.6,
  qualpalr_colorspace = "pretty"
)

\method{write_shiny_app}{Seurat}(
  object,
  metadata = NULL,
  assay_name,
  clustassess_object,
  project_folder,
  compression_level = 6,
  summary_function = stats::median,
  shiny_app_title = "",
  organism_enrichment = "hsapiens",
  height_ratio = 0.6,
  qualpalr_colorspace = "pretty"
)

\method{write_shiny_app}{default}(
  object,
  metadata = NULL,
  assay_name = NULL,
  clustassess_object,
  project_folder,
  compression_level = 6,
  summary_function = stats::median,
  shiny_app_title = "",
  organism_enrichment = "hsapiens",
  height_ratio = 0.6,
  qualpalr_colorspace = "pretty"
)
}
\arguments{
\item{object}{A Seurat object or an expression matrix}

\item{metadata}{The metadata dataframe. This parameter will be ignored if
the object is a Seurat object.}

\item{assay_name}{The name of the assay to be used to extract the expression matrix
from the Seurat object. This parameter will be ignored if the object is not
a Seurat object.}

\item{clustassess_object}{The output of the ClustAssess automatic pipeline}

\item{project_folder}{The folder where the files will be written}

\item{compression_level}{The compression level for the h5 files (See `rhdf5::h5createFile`` for more details)}

\item{summary_function}{The function used for summarizing the stability values; the default is \code{median}}

\item{shiny_app_title}{The title of the shiny app}

\item{organism_enrichment}{The organism used for the enrichment analysis; the default is \code{hsapiens}}

\item{height_ratio}{The ratio of the height of the plot to the height of the browser; the default is \code{0.6}}

\item{qualpalr_colorspace}{The colorspace used for generating the colors; the default is \code{pretty}}
}
\description{
Creates the ClustAssess ShinyApp based on the output of the
automatic ClustAssess pipeline. In addition to that, the expression matrix
and the metadata dataframe are provided as input to the ShinyApp.
}
