% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miaSpectra2D.R
\name{miaSpectra2D}
\alias{miaSpectra2D}
\title{Multivariate Image Analysis (Tucker 1) of a Spectra2D Object}
\usage{
miaSpectra2D(spectra)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra2D}}.}
}
\value{
A list per \code{\link[ThreeWay]{pcasup1}}.  Of particular interest are the
  elements \code{C} containing the eigenvectors and \code{1c} containing the eigenvalues.
  We add the class \code{mia} to the list for our use later, as well as a \code{method}
  element for annotating plots.
}
\description{
Carry out multivariate image analysis of a \code{\link{Spectra2D}} object
(multivariate image analysis is the same as a Tucker1 analysis).
Function \code{\link[ThreeWay]{pcasup1}} from package \pkg{ThreeWay} is used.
}
\examples{
library("ggplot2")
data(MUD1)
res <- miaSpectra2D(MUD1)

# plotScores & plotScree use ggplot2 graphics

p1 <- plotScores(MUD1, res, tol = 1.0, ellipse = "cls")
p1 <- p1 + ggtitle("MIA Scores")
p1

p2 <- plotScree(res)
p2

# plotLoadings2D uses base graphics
MUD1a <- plotLoadings2D(MUD1, res,
  load_lvls = seq(-90, 0, 10),
  main = "MIA Comp. 1 Loadings"
)

# Selection of loading matrix levels can be aided by the following
# Use MUD1a$names to find the index of the loadings

inspectLvls(MUD1a,
  which = 11, ylim = c(0, 80),
  main = "Histogram of Loadings Matrix"
)
}
\references{
A. Smilde, R. Bro and P. Geladi
"Multi-way Analysis: Applications in the Chemical Sciences" Wiley (2004).
See especially Example 4.5.

P. Geladi and H. Grahn "Multivariate Image Analysis" Wiley (1996).  Note that
in this text the meanings of scores and loadings are reversed from the usual
spectroscopic uses of the terms.
}
\seealso{
For other data reduction methods for \code{Spectra2D} objects, see
\code{\link{pfacSpectra2D}} and \code{\link{popSpectra2D}}.
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{multivariate}
