#'  Comparisons of treatment levels
#'
#' Performes all required comparisons of treatment levels
#'
#' @param CTPparms Object of class \code{CTPparms} (i.e. generated by the function \code{getCTPparms}
#'
#' @param ... Additional arguments for the chosen test
#'
#' @return A data.frame with the hypotheses and the unadjusted p-values

CTPcompare <- function(CTPparms,...)
{
  L1 <- CTPparms$hyplist
  l1 <- length(L1)
  l2 <- sapply(L1,length)
  pval <- NULL

 
    for (i in 1:l1)
    {

      for(j in 1:l2[i])
      {

        hyp <-L1[[i]][[j]]
        x1 <- length(hyp); x2 <- length(unlist(hyp))


        if(x1 == x2) xpval <- ctp.single.test(hyp, CTPparms,...)
        if(x1 < x2)
        {
          plist <- unlist(lapply(hyp, ctp.single.test,CTPparms=CTPparms))
          xpval <- 1. - pchisq(-2. * logb(prod(plist)), 2. * length(plist))
        }
        pval <- c(pval,xpval)
      }
    }
    pvalues <- data.frame(CTPparms$hypnames, pvalue = pval)

  pvalues
}
