% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTM.R
\name{CTDM}
\alias{CTDM}
\title{Term Document Matrix}
\usage{
CTDM(doc, weighting, shortTermDeleted)
}
\arguments{
\item{doc}{The Chinese text document.}

\item{weighting}{Available weighting function with matrix are tf, tfidf.}

\item{shortTermDeleted}{Deltected short word when nchar <2.}
}
\description{
Constructs Term-Document Matrix from Chinese Text Documents.
}
\details{
This function run a Chinese word segmentation by jiebeR and build
term-document matrix, and there is two weighting function with matrix,
term frequency and term frequency inverse document frequency.
}
\examples{
library(CTM)
a <- "hello taiwan"
b <- "world of tank"
c <- "taiwan weather"
d <- "local weather"
text <- t(data.frame(a,b,c,d))
tdm <- CTDM(doc = text, weighting = "tfidf", shortTermDeleted = FALSE)
}
\author{
Jim Liu
}

