% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDFtestingSuite.R
\name{MaxErrorAt_PDF}
\alias{MaxErrorAt_PDF}
\title{Locate where the maximum error occurs between two PDFs}
\usage{
MaxErrorAt_PDF(Y, est, range, gran, ...)
}
\arguments{
\item{Y}{The vector output of a non-differentially private PDF
computation (values within bins)}

\item{est}{The vector output of a differentially private PDF 
computation (values within bins)}

\item{range}{A vector length 2 containing user-specified min and max to
truncate the universe to}

\item{gran}{The smallest unit of measurement in the data (one [year]
for a list of ages)}

\item{...}{Optionally add additional parameters. This is primarily used to allow automated
execution of varied diagnostic functions.}
}
\value{
A single value, the value at which the  largest absolute vertical
   difference between
  parallel observations in the private- and true-PDF vectors occurs.
}
\description{
Find the location of the maximum direct error between a
   non-private PDF and a DP approximation of that PDF.
}
\examples{
MaxErrorAt_PDF(c(.1,.2,.3,.4,.5,.6,.7,.8,.9,1), c(.1,.2,.3,.3,.3,.3,.3,.3,.4,1),
   range= c(1,10), gran =1)
}

