% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_ChooseBackground.R
\name{BP_ChooseBackground}
\alias{BP_ChooseBackground}
\title{Let the use to choose the background color of an image}
\usage{
BP_ChooseBackground(bone, analysis = 1)
}
\arguments{
\item{bone}{The bone image to be used}

\item{analysis}{The name or rank of analysis}
}
\value{
The orignial bone object with a new attribute for background color
}
\description{
Let the user to choose the background color of an image.
}
\details{
BP_ChooseBackground lets the use to choose the background color of an image
}
\examples{
\dontrun{
# Not run:
 path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.tif", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_ChooseBackground(bone=bone)
 bone <- BP_ChooseForeground(bone=bone)
 plot(bone)
 }
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
