requireNamespace("dplyr")
library(dplyr) # couldn't use %>% without this


# make some test data - this is derived from GBIF data but it is HEAVILY EDITED and USELESS
testData <- dplyr::tribble( # even step coordinates (different for lat/long)
  ~database_id, ~datasetName,    ~id, ~institutionCode, ~collectionCode,         ~ownerInstitutionCode,                    ~basisOfRecord,                  ~occurrenceID,      ~catalogNumber, ~otherCatalogNumbers,   ~kingdom,      ~phylum,    ~class,        ~order,  ~family,  ~scientificName, ~taxonID, ~scientificNameAuthorship, ~genus, ~specificEpithet,        ~recordedBy, ~eventDate, ~year, ~month, ~day,        ~verbatimEventDate,        ~country, ~stateProvince,  ~locality,                  ~locationRemarks, ~decimalLatitude, ~decimalLongitude, ~minimumElevationInMeters,                                             ~rights,                                     ~rightsHolder, ~accessRights,                                       ~recordId,   ~occurrenceStatus,
  "fake SCAN1", "fakeDataset",   13775122L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",     "CAS:ANTWEB:casent0106100",     "casent0106100",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.541,         -121.7567,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:46a46727-6535-4e70-88e7-a42c98f806ed",           "PRESENT",
  "fake SCAN2", "fakeDataset",   13775123L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d01", "casent0106100-d01",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.542,         -121.7568,                       15L,                               "All rights reserved", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:d6ff3ddb-4695-4aaf-ab89-c251ab2fc7e6",           "PRESENT",
  "fake SCAN3", "fakeDataset",   13775124L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d11", "casent0106100-d11",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.543,         -121.7569,                       15L,                              "All rights reserved.", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:4504a6e6-ab1c-4de7-ac43-a3588a63ae90",           "PRESENT",
  "fake SCAN4", "fakeDataset",          NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.544,         -121.7570,                       15L,                               "All rights reserved", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",
  "fake SCAN5", "fakeDataset",          NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.545,         -121.7571,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",
  "fake SCAN6", "fakeDataset",          NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.546,         -121.7572,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",
  "fake SCAN7", "fakeDataset",         NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,         -121.7567,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN8", "fakeDataset",         NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,         -121.7567,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",
  "fake SCAN9", "fakeDataset",  13852774L,                      "CAS",        "ANTWEB", "CAS, San Francisco, CA, USA", "PreservedSpecimen",     "CAS:ANTWEB:casent0249086",     "casent0249086",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera", "C. Sch‚àö‚àÇning",   "9/1/09", 2009L,     9L,   1L,                "1-Sep-09",         "Kenya",             NA, "Chogoria",                                NA,         -0.20222,           37.5083,                     2277L,                               "All Rights Reserved", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:964139d3-fb07-4a57-9b7c-e9a5830f4c82",            "ABSENT",
  "fake SCAN10", "fakeDataset",         NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",     "mellifera",         "P.S. Ward",  "6/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.546,         -121.7572,                       15L,                               "All Rights Reserved", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",
  "fake SCAN11", "newDataset",         NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,         -121.7567,                       15L,                               "All Rights Reserved", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN12", "newDataset",         NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,         -121.7567,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN13", "newDataset",  13852774L,                      "CAS",        "ANTWEB", "CAS, San Francisco, CA, USA", "PreservedSpecimen",     "CAS:ANTWEB:casent0249086",     "casent0249086",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera", "C. Sch‚àö‚àÇning",   "9/1/09", 2009L,     9L,   1L,                "1-Sep-09",         "Kenya",             NA, "Chogoria",                                NA,         -0.20222,           37.5083,                     2277L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:964139d3-fb07-4a57-9b7c-e9a5830f4c82",            "ABSENT",

  "fake SCAN14", "fakeDataset",          NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",            "Ward",  "4/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,          -121.756,                       15L,                              "All rights reserved.", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN15", "fakeDataset",          NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",            "Ward",  "4/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,          -121.756,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN16", "fakeDataset",          NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",            "Ward",  "4/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,          -121.756,                       15L,                              "All rights reserved.", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN17", "fakeDataset",          NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",            "Ward",  "4/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,          -121.756,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",

  "fake SCAN18", "fakeDataset",   13775123L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d01", "casent0106100-d01",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",         "BeeNerd",  "6/30/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           28.742,           -121.75,                       15L,                                    "Not for public", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:d6ff3ddb-4695-4aaf-ab89-c251ab2fc7e6",            "ABSENT",
  "fake SCAN19", "fakeDataset",   13775124L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d11", "casent0106100-d11",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",         "BeeNerd",  "6/30/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           28.743,           -121.75,                       15L,                                    "Not for public", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:4504a6e6-ab1c-4de7-ac43-a3588a63ae90",            "ABSENT",
  "fake SCAN20", "fakeDataset",          NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",         "BeeNerd",  "6/30/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           28.744,           -121.75,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",  
  "fake SCAN21", "fakeDataset",          NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",         "BeeNerd",  "6/30/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           28.745,           -121.75,                       15L,                                                "ND", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",                     
)



# Run the function
testOut <- BeeBDC::flagLicense(data = testData, 
                              strings_to_restrict = "all", 
                              excludeDataSource = NULL)


# test number of TRUE and FALSE values in the flag column, .occurrenceAbsent
resultsT <- length(testOut$.unLicensed[testOut$.unLicensed == TRUE])
resultsF <- length(testOut$.unLicensed[testOut$.unLicensed == FALSE])

testthat::test_that("flagLicense column .unLicensed results TRUE", {
  testthat::expect_equal(resultsT, 10)
})

testthat::test_that("flagLicense column .unLicensed results FALSE", {
  testthat::expect_equal(resultsF, 11)
})


# test the order of the TRUE and FALSE values in the flag column, .unLicensed
correct <- c(TRUE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, FALSE, FALSE, FALSE,
             TRUE, TRUE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE)

testthat::test_that("flag column .unLicensed results correct series", {
  testthat::expect_equal(correct, testOut$.unLicensed)
})
