% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare_ppc.default.R
\name{ggm_compare_ppc.default}
\alias{ggm_compare_ppc.default}
\alias{ggm_compare_ppc}
\title{Compare GGMs with the Posterior Predictive Distribution}
\usage{
ggm_compare_ppc(..., type = "global", iter = 5000, cores = 1)
}
\arguments{
\item{...}{data matrices (\emph{n} by  \emph{p}). Requires at least two.}

\item{type}{\code{type = "global"} for testing the entire precision matrix. \code{type = "nodewise"} for testing each node (i.e., variable)}

\item{iter}{number of replicated data sets. default is \code{iter = 1000}.}

\item{cores}{number of cores for parallel computing. The default is 2, but this can be adjusted.}
}
\value{
list of class \code{ggm_compare_ppc}:

\itemize{
\item \code{pvalue} posterior predictive p-values
\item \code{obs_jsd} observed symmetric KL divergence (Jensen-Shannon divergence)
\item \code{predictive_risk} list of predictive distributions
\item  \code{info} list of information about the data matrices

\itemize{
\item \code{dat} list containing the data matrices
\item \code{dat_info} sample size for each data matrix
\item \code{pairwise} matrix of pairwise combinations
}

\item \code{names} contrast names (e.g.., Yg1  vs Yg2)
\item \code{iter}  number of posterior samples
\item \code{type} "global"
\item \code{call} match.call()
}
}
\description{
Compare GGMs with the posterior predictive distribution. The method assume group equality, and the predictive check
allows for testing whether that assumption should be modified--i.e., the GGMs are actually different. The current test statistic available is
Kullback-Leibler divergence, which in this case, can be understood as a likelihood ratio for multivariate normal distributions. There are
two options: (1) 'global' and (2) 'nodewise.' The former tests the entire GGM, whereas the latter allows for testing specific nodes (variables)
in the model.
}
\note{
This method is Bayesian, as it relies on the posterior predictive distribution.
That said, there are clear parallels to frequentist testing-e.g., assuming group
equality and critical regions. Most importantly, this method CANNOT provide evidence
for the null hypothesis. Thus it can only reject the underlying assumption of group equality.
For gaining (relative) evidence for the null hypothesis see..

see methods(class = "ggm_compare_ppc")
}
\examples{
\donttest{
# Assume null is true
Y1 <- MASS::mvrnorm(500, rep(0, 16), Sigma = diag(16))
Y2 <- MASS::mvrnorm(500, rep(0, 16), Sigma = diag(16))
Y3 <- MASS::mvrnorm(500, rep(0, 16), Sigma = diag(16))

# global predictive check (iter = 50 for demonstrative purposes)
ggm_ppc <- ggm_compare_ppc(Y1, Y2, Y3,
                           type = "global", iter = 50)
summary(ggm_ppc)

plot(ggm_ppc)

# nodewise
ggm_ppc  <- ggm_compare_ppc(Y1, Y2, Y3, type = "nodewise", iter = 50)

plot(ggm_ppc, log = TRUE)
}
}
