% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nucleotide_matation.R
\name{nucleotide_mutation}
\alias{nucleotide_mutation}
\title{The frequencies of nucleotide mutations and the frequencies of transition and transversion}
\usage{
nucleotide_mutation(data)
}
\arguments{
\item{data}{A colums from 11 to 22 in the IMGT Table 8 caled "8_V-REGION-nt-mutation-statistics.txt".}
}
\value{
Output is four different values:

vregion_nt_mut number of nucleotide mutations in V region.

transition_rel the frequencies of transition.

transverion_rel the frequencies of transversion.

trans_transv_anzahl number of transition and transversion in V region.
}
\description{
Calculate nucleotide (A, T, C and G) mutations, transition, transversion and their frequency.
}
\examples{
data(IMGTtab8)
bm_proband<- nucleotide_mutation(IMGTtab8[,11:22])
percentlabels<- round(bm_proband$vregion_nt_mut/sum(bm_proband$vregion_nt_mut)*100)
pielabels<- paste(percentlabels, "\%", sep="")
pie(bm_proband$vregion_nt_mut, col=c("grey50","black","grey90","white"),
    labels=pielabels, cex=1.5, radius = 0.3)
legend("right", c(" prod. IGHV"), cex=1.5)
legend("topleft", c("A","G","T","C"), cex=2, fill=c("grey50","black",
                                                   "grey90","white"))
}

