% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint.R
\name{queue_endpoint}
\alias{queue_endpoint}
\title{Create a queue endpoint object}
\usage{
queue_endpoint(
  endpoint,
  key = NULL,
  token = NULL,
  sas = NULL,
  api_version = getOption("azure_storage_api_version")
)
}
\arguments{
\item{endpoint}{The URL (hostname) for the endpoint, of the form \verb{http[s]://\{account-name\}.queue.\{core-host-name\}}. On the public Azure cloud, endpoints will be of the form \verb{https://\{account-name\}.queue.core.windows.net}.}

\item{key}{The access key for the storage account.}

\item{token}{An Azure Active Directory (AAD) authentication token. This can be either a string, or an object of class AzureToken created by \link[AzureRMR:reexports]{AzureRMR::get_azure_token}. The latter is the recommended way of doing it, as it allows for automatic refreshing of expired tokens.}

\item{sas}{A shared access signature (SAS) for the account.}

\item{api_version}{The storage API version to use when interacting with the host. Defaults to \code{"2019-07-07"}.}
}
\value{
An object of class \code{queue_endpoint}, inheriting from \code{storage_endpoint}.
}
\description{
Create a queue endpoint object
}
\details{
This is the queue storage counterpart to the endpoint functions defined in the AzureStor package.
}
\examples{
\dontrun{

# obtaining an endpoint from the storage account resource object
AzureRMR::get_azure_login()$
    get_subscription("sub_id")$
    get_resource_group("rgname")$
    get_storage_account("mystorage")$
    get_queue_endpoint()

# creating an endpoint standalone
queue_endpoint("https://mystorage.queue.core.windows.net/", key="access_key")

}
}
\seealso{
\code{\link[AzureStor:storage_endpoint]{AzureStor::storage_endpoint}}, \code{\link[AzureStor:storage_endpoint]{AzureStor::blob_endpoint}}, \code{\link{storage_queue}}
}
