% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disk.R
\name{as.disk}
\alias{as.disk}
\alias{disk}
\alias{is.disk}
\title{Class 'disk'}
\usage{
as.disk(x, na.rm = FALSE)

is.disk(x)
}
\arguments{
\item{x}{vector}

\item{na.rm}{a logical indicating whether missing values should be removed}
}
\value{
Ordered integer factor with new class \code{\link{disk}}
}
\description{
This transforms a vector to a new class \code{\link{disk}}, which is a growth zone size (around an antibiotic disk) in millimeters between 6 and 99.
}
\details{
Interpret disk values as RSI values with \code{\link[=as.rsi]{as.rsi()}}. It supports guidelines from EUCAST and CLSI.
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
# interpret disk values
as.rsi(x = 12,
       mo = as.mo("S. pneumoniae"),
       ab = "AMX",
       guideline = "EUCAST")
as.rsi(x = 12,
       mo = as.mo("S. pneumoniae"),
       ab = "AMX",
       guideline = "CLSI")
}
\seealso{
\code{\link[=as.rsi]{as.rsi()}}
}
