% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/A3.R
\name{plotSlopes}
\alias{plotSlopes}
\title{Plot Distribution of Slopes}
\usage{
plotSlopes(x, ...)
}
\arguments{
\item{x}{an A3 object.}

\item{...}{additional options provided to the \code{\link{plot}} and \code{\link{density}} functions.}
}
\description{
Plots an 'A3' object's distribution of slopes for each feature and observation. Uses Kernel Density Estimation to create an estimate of the distribution of slopes for a feature.
}
\examples{
\donttest{
 require(randomForest)
 data(housing)

 x <- a3(MED.VALUE ~ NOX + PUPIL.TEACHER + ROOMS + AGE + HIGHWAY + 0,
   housing, randomForest, p.acc = NULL, n.folds = 2)

 plotSlopes(x)
 }
}

