% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r, R/bitmapfont.r
\name{c}
\alias{c}
\alias{c.AmigaBasic}
\alias{c.AmigaBitmapFont}
\title{Combine multiple AmigaFFH objects}
\usage{
\method{c}{AmigaBasic}(...)

\method{c}{AmigaBitmapFont}(..., name = "font")
}
\arguments{
\item{...}{Either \code{\link[=AmigaBasic]{AmigaBasic()}} or \code{\link[=AmigaBitmapFont]{AmigaBitmapFont()}}
class objects. In case of \code{\link[=AmigaBitmapFont]{AmigaBitmapFont()}} objects:
Each \code{\link[=AmigaBitmapFont]{AmigaBitmapFont()}} object should have a
unique Y-size.}

\item{name}{This argument is only valid when \code{...} are one or more
\code{\link[=AmigaBitmapFont]{AmigaBitmapFont()}} class objects.

A \code{character} string specifying the name that needs to be
applied to the font set. When unspecified, the default name 'font' is
used. Note that this name will also be used as a file name when writing
the font to a file. So make sure the name is also a valid file name. This
will not be checked for you and may thus result in errors.}
}
\value{
Returns an \code{\link[=AmigaBitmapFontSet]{AmigaBitmapFontSet()}} in which the
\code{\link[=AmigaBitmapFont]{AmigaBitmapFont()}} objects are combined. Or when \code{\link[=AmigaBasic]{AmigaBasic()}}
objects are combined, an \code{\link[=AmigaBasic]{AmigaBasic()}} object is returned
in which the lines of Amiga Basic code are combined.
}
\description{
Use this function to correctly combine one or more \code{\link[=AmigaBitmapFont]{AmigaBitmapFont()}}
class objects into a single \code{\link[=AmigaBitmapFontSet]{AmigaBitmapFontSet()}} class
object, or to combine multiple \code{\link[=AmigaBasic]{AmigaBasic()}} class objects.
}
\details{
In case \code{...} are one or more \code{\link[=AmigaBasic]{AmigaBasic()}} class objects:

\code{\link[=AmigaBasic]{AmigaBasic()}} class objects are combined into a single
\code{\link[=AmigaBasic]{AmigaBasic()}} class object in the same order as they
are given as argument to this function. for this purpose the lines of
Amiga Basic codes are simply concatenated.

In case \code{...} are one or more \code{\link[=AmigaBitmapFont]{AmigaBitmapFont()}} class objects:

\code{\link[=AmigaBitmapFontSet]{AmigaBitmapFontSet()}} class objects can hold multiple
\code{\link[=AmigaBitmapFont]{AmigaBitmapFont()}} class objects. Use this method to
combine font bitmaps into such a font set. Make sure each bitmap
represents a unique font height (in pixels). When heights are duplicated
an error will be thrown.

You can also specify a \code{name} for the font, that will be embeded
in the object. As this name will also be used as a file name when
writing the font to a file, make sure that it is a valid filename.
}
\examples{
data(font_example)

## first get some AmigaBitmapFont objects:
font8 <- getAmigaBitmapFont(font_example, 8)
font9 <- getAmigaBitmapFont(font_example, 9)

## now bind these bitmaps again in a single set
font.set <- c(font8, font9, name = "my_font_name")

## Amiga Basic codes can also be combined:
bas1 <- as.AmigaBasic("LET a = 1")
bas2 <- as.AmigaBasic("PRINT a")
bas  <- c(bas1, bas2)
}
\seealso{
Other AmigaBitmapFont.operations: 
\code{\link{AmigaBitmapFont}},
\code{\link{availableFontSizes}()},
\code{\link{fontName}()},
\code{\link{font_example}},
\code{\link{getAmigaBitmapFont}()},
\code{\link{rasterToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{write.AmigaBitmapFont}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBitmapFont.operations}
