% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_isolates_unclean}
\alias{example_isolates_unclean}
\title{Data Set with Unclean Data}
\format{
A \link[tibble:tibble]{tibble} with 3 000 observations and 8 variables:
\itemize{
\item \code{patient_id}\cr ID of the patient
\item \code{date}\cr date of receipt at the laboratory
\item \code{hospital}\cr ID of the hospital, from A to C
\item \code{bacteria}\cr info about microorganism that can be transformed with \code{\link[=as.mo]{as.mo()}}, see also \link{microorganisms}
\item \code{AMX:GEN}\cr 4 different antimicrobials that have to be transformed with \code{\link[=as.sir]{as.sir()}}
}
}
\usage{
example_isolates_unclean
}
\description{
A data set containing 3 000 microbial isolates that are not cleaned up and consequently not ready for AMR data analysis. This data set can be used for practice.
}
\section{Download Our Reference Data}{

All reference data sets in the AMR package - including information on microorganisms, antimicrobials, and clinical breakpoints - are freely available for download in multiple formats: R, MS Excel, Apache Feather, Apache Parquet, SPSS, and Stata.

For maximum compatibility, we also provide machine-readable, tab-separated plain text files suitable for use in any software, including laboratory information systems.

Visit \href{https://amr-for-r.org/articles/datasets.html}{our website for direct download links}, or explore the actual files in \href{https://github.com/msberends/AMR/tree/main/data-raw/datasets}{our GitHub repository}.
}

\examples{
example_isolates_unclean
}
\keyword{datasets}
