% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\name{product_vars}
\alias{product_vars}
\title{Retain values based on conditions}
\usage{
product_vars(data, fork_vars, vars, keep_values)
}
\arguments{
\item{data}{A data frame containing the input data}

\item{fork_vars}{Character vector of column names to use as logical
conditions, evaluated against \code{keep_values}}

\item{vars}{Character vector of column names whose values will be retained or
modified based on conditions in \code{fork_vars}}

\item{keep_values}{Vector of values in \code{fork_vars} to consider as "true" for
retaining values in \code{vars}}
}
\value{
A data frame with new \verb{_product} suffixed variables. Excludes
intermediate logical columns.
}
\description{
Creates new variables by applying conditions to specified columns
(\code{fork_vars}) and retaining or modifying values from other columns (\code{vars})
based on \code{keep_values}.
Generates new variables with \verb{_product} suffix.
}
\examples{
product_vars(
  data = tibble::tibble(
    var_av = c("1", "2", "3", "4", "5", NA, "999", "777"),
    var_al = c("5", "4", "3", "2", "1", "777", NA, "999"),
    var_bv = c("1", "1", "36", "2", "1", NA, "999", "777"),
    var_bl = c("5", "2", "2", "2", "1", "777", NA, "999")
  ),
  fork_vars = c("var_al", "var_bl"),
  vars = c("var_av", "var_bv"),
  keep_values = "2"
)

}
\keyword{internal}
