% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_y_ysr__synd__tho_sum}
\alias{compute_mh_y_ysr__synd__tho_sum}
\title{Compute "Youth Self Report [Youth] (Syndrome Scale - Thought problems):
Sum"}
\usage{
compute_mh_y_ysr__synd__tho_sum(
  data,
  name = "mh_y_ysr__synd__tho_sum",
  max_na = 0,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_y_ysr__synd__tho_sum}
Youth Self Report [Youth] (Syndrome Scale - Thought problems): Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_y_ysr__tho_001}
\item \code{mh_y_ysr__tho__dep_001}
\item \code{mh_y_ysr__tho_002}
\item \code{mh_y_ysr__tho_003}
\item \code{mh_y_ysr__tho_004}
\item \code{mh_y_ysr__tho_005}
\item \code{mh_y_ysr__tho_006}
\item \code{mh_y_ysr__tho__dep_002}
\item \code{mh_y_ysr__tho_007}
\item \code{mh_y_ysr__tho_008}
\item \code{mh_y_ysr__tho_009}
\item \code{mh_y_ysr__tho__dep_003}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 0 of 12 items missing
}
}
\examples{
\dontrun{
compute_mh_y_ysr__synd__tho_sum(data) |>
  select(
    any_of(c("mh_y_ysr__synd__tho_sum", vars_mh_y_ysr__synd__tho))
  )
}
}
\seealso{
\code{\link[=compute_mh_y_ysr__synd__tho_nm]{compute_mh_y_ysr__synd__tho_nm()}}
}
