% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose.VPC.categorical.R
\name{xpose.VPC.categorical}
\alias{xpose.VPC.categorical}
\title{Xpose visual predictive check for categorical data.}
\usage{
xpose.VPC.categorical(
  vpc.info = "vpc_results.csv",
  vpctab = dir(pattern = "^vpctab")[1],
  object = NULL,
  subset = NULL,
  main = "Default",
  main.sub = "Default",
  main.sub.cex = 0.85,
  real.col = 4,
  real.lty = "b",
  real.cex = 1,
  real.lwd = 1,
  median.line = FALSE,
  median.col = "darkgrey",
  median.lty = 1,
  ci.lines = FALSE,
  ci.col = "blue",
  ci.lines.col = "darkblue",
  ci.lines.lty = 3,
  xlb = "Default",
  ylb = "Proportion of Total",
  force.x.continuous = FALSE,
  level.to.plot = NULL,
  max.plots.per.page = 1,
  rug = TRUE,
  rug.col = "orange",
  censored = FALSE,
  ...
)
}
\arguments{
\item{vpc.info}{Name of PSN file to use.  File will come from \code{VPC}
command in PsN.}

\item{vpctab}{Name of vpctab file produced from PsN.}

\item{object}{Xpose data object.}

\item{subset}{Subset of data to look at.}

\item{main}{Title for plot.}

\item{main.sub}{Used for names above each plot when using multiple plots.
Should be a vector, e.g. \code{c("title 1","title 2")}.}

\item{main.sub.cex}{Size of \code{main.sub}}

\item{real.col}{Color of real line.}

\item{real.lty}{Real line type.}

\item{real.cex}{Size of real line.}

\item{real.lwd}{Width of real line.}

\item{median.line}{Dray a median line?}

\item{median.col}{Color of median line.}

\item{median.lty}{median line type.}

\item{ci.lines}{Lines marking confidence interval?}

\item{ci.col}{Color of CI area.}

\item{ci.lines.col}{Color of CI lines.}

\item{ci.lines.lty}{Type of CI lines.}

\item{xlb}{X-axis label.  If other than "default"" passed directly to
\code{\link{xyplot}}.}

\item{ylb}{Y-axis label. Passed directly to \code{\link{xyplot}}.}

\item{force.x.continuous}{For the x variable to be continuous.}

\item{level.to.plot}{Which levels of the variable to plot. Smallest level is
1, largest is number_of_levels.  For example, with 4 levels, the largest
level would be 4, the smallest would be 1.}

\item{max.plots.per.page}{The number of plots per page.}

\item{rug}{Should there be markings on the plot showing where the intervals
for the VPC are?}

\item{rug.col}{Color of the rug.}

\item{censored}{Is this censored data?  Censored data can be both below and
above the limit of quantification.}

\item{\dots}{Additional information passed to function.}
}
\description{
Xpose visual predictive check for categorical data (binary, ordered
categorical and count data).
}
\examples{

\dontrun{
library(xpose4)

## move to the directory where results from PsN
## are found
cur.dir <- getwd()
setwd(paste(cur.dir,"/binary/vpc_36",sep=""))

xpose.VPC.categorical(level.to.plot=1,max.plots.per.page=4)
xpose.VPC.categorical(level.to.plot=1,max.plots.per.page=4,by="DOSE")

## ordered categorical plots
setwd(paste(cur.dir,"/ordered_cat/vpc_45",sep=""))
xpose.VPC.categorical()


## count
setwd(paste(cur.dir,"/count/vpc65b",sep=""))
xpose.VPC.categorical()

setwd(paste(cur.dir,"/count/vpc65a",sep=""))
xpose.VPC.categorical()

}

}
\seealso{
\code{\link{xpose.VPC.both}}.

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.pred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{gof}()},
\code{\link{ind.plots}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose4-package}}

Other PsN functions: 
\code{\link{boot.hist}()},
\code{\link{bootscm.import}()},
\code{\link{npc.coverage}()},
\code{\link{randtest.hist}()},
\code{\link{read.npc.vpc.results}()},
\code{\link{read.vpctab}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose4-package}}
}
\author{
Andrew C. Hooker
}
\concept{PsN functions}
\concept{specific functions}
\keyword{methods}
