% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_fit.R
\name{anlz_fit}
\alias{anlz_fit}
\title{Return summary statistics for GAM fits}
\usage{
anlz_fit(mod)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}
}
\value{
A \code{data.frame} with summary statistics for GAM fits
}
\description{
Return summary statistics for GAM fits
}
\details{
Results show the overall summary of the model as Akaike Information Criterion (\code{AIC}), the generalized cross-validation score (\code{GCV}), and the \code{R2} values.  Lower values for \code{AIC} and \code{GCV} and higher values for \code{R2} indicate improved model fit.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl')
  
mod <-  anlz_gam(tomod, trans = 'log10')
anlz_fit(mod)
}
\concept{analyze}
