% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_build.R
\name{wflow_build}
\alias{wflow_build}
\title{Build the site}
\usage{
wflow_build(
  files = NULL,
  make = is.null(files),
  update = FALSE,
  republish = FALSE,
  combine = "or",
  view = getOption("workflowr.view"),
  clean_fig_files = FALSE,
  delete_cache = FALSE,
  seed = 12345,
  log_dir = NULL,
  verbose = FALSE,
  local = FALSE,
  dry_run = FALSE,
  project = "."
)
}
\arguments{
\item{files}{character (default: NULL). Files to build. Only allows files in
the analysis directory with the extension Rmd or rmd. If \code{files} is
\code{NULL}, the default behavior is to build all outdated files (see
argument \code{make} below). Supports file
\href{https://en.wikipedia.org/wiki/Glob_(programming)}{globbing}.
The files are always built in the order they are listed.}

\item{make}{logical (default: \code{is.null(files)}). When \code{make =
TRUE}, build any files that have been modified more recently than their
corresponding HTML files (inspired by
\href{https://en.wikipedia.org/wiki/Make_(software)}{Make}). This is the
default action if no files are specified.}

\item{update}{logical (default: FALSE). Build any files that have been
committed more recently than their corresponding HTML files (and do not
have any unstaged or staged changes). This ensures that the commit version
ID inserted into the HTML corresponds to the exact version of the source
file that was used to produce it.}

\item{republish}{logical (default: FALSE). Build all published R Markdown
files (that do not have any unstaged or staged changes). Useful for
site-wide changes like updating the theme, navigation bar, or any other
setting in \code{_site.yml}.}

\item{combine}{character (default: \code{"or"}). Determine how to combine the
files from the arguments \code{files}, \code{make} (\code{wflow_build()}
only), \code{update}, and \code{republish}. When \code{combine} is
\code{"or"}, any file specified by at least one of these arguments will be
built. When \code{combine} is \code{"and"}, only files specified by all of
these arguments will be built.}

\item{view}{logical (default: \code{getOption("workflowr.view")}). View the
website with \code{\link{wflow_view}} after building files. If only one
file is built, it is opened. If more than one file is built, the main index
page is opened. Not applicable if no files are built or if \code{dry_run =
TRUE}.}

\item{clean_fig_files}{logical (default: FALSE). Delete existing figure files
for each R Markdown file prior to building it. This ensures that only
relevant figure files are saved. As you develop an analysis, it is easy to
generate lots of unused plots due to changes in the number of code chunks
and their names. However, if you are caching chunks during code
development, this could cause figures to disappear. Note that
\code{\link{wflow_publish}} uses \code{clean_fig_files = TRUE} to ensure
the results can be reproduced.}

\item{delete_cache}{logical (default: FALSE). Delete the cache directory (if
it exists) for each R Markdown file prior to building it.}

\item{seed}{numeric (default: 12345). The seed to set before building each
file. Passed to \code{\link{set.seed}}. \bold{DEPRECATED:} The seed set
here has no effect if you are using \code{\link{wflow_html}} as the output
format defined in \code{_site.yml}. This argument is for backwards
compatibility with previous versions of workflowr.}

\item{log_dir}{character (default: NULL). The directory to save log files
from building files. It will be created if necessary and ignored if
\code{local = TRUE}. The default is to use a directory named
\code{workflowr} in \code{\link{tempdir}}.}

\item{verbose}{logical (default: FALSE). Display the build log directly in
the R console as each file is built. This is useful for monitoring
long-running code chunks.}

\item{local}{logical (default: FALSE). Build files locally in the R console.
This should only be used for debugging purposes. The default is to build
each file in its own separate fresh R process to ensure each file is
reproducible in isolation. This is done using
\code{\link[callr:r]{callr::r_safe}}.}

\item{dry_run}{logical (default: FALSE). List the files to be built, without
building them.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
An object of class \code{wflow_build}, which is a list with the
  following elements:

 \itemize{

   \item \bold{files}: The input argument \code{files}

   \item \bold{make}: The input argument \code{make}

   \item \bold{update}: The input argument \code{update}

   \item \bold{republish}: The input argument \code{republish}

   \item \bold{view}: The input argument \code{view}

   \item \bold{clean_fig_files}: The input argument \code{clean_fig_files}

   \item \bold{delete_cache}: The input argument \code{delete_cache}

   \item \bold{seed}: The input argument \code{seed}

   \item \bold{log_dir}: The directory where the log files were saved

   \item \bold{verbose}: The input argument \code{verbose}

   \item \bold{local}: The input argument \code{local}

   \item \bold{dry_run}: The input argument \code{dry_run}

   \item \bold{built}: The relative paths to the built R Markdown files

   \item \bold{html}: The relative paths to the corresponding HTML files

 }
}
\description{
\code{wflow_build} builds the website from the files in the analysis
directory. This is intended to be used when developing your code to preview
the changes. When you are ready to commit the files, use
\code{\link{wflow_publish}}.
}
\details{
\code{wflow_build} has multiple, non-mutually exclusive options for deciding
which files to build. If multiple options are used, then the argument
\code{combine} determines which files will be built. If \code{combine ==
"or"} (the default), then any file specified by at least one of the arguments
will be built. In contrast, if \code{combine == "and"}, then only files
specified by all of the arguments will be built. The argument \code{make} is
the most useful for interactively performing your analysis. The other options
are more useful when you are ready to publish specific files with
\code{\link{wflow_publish}} (which passes these arguments to
\code{wflow_build}). Here are the options for specifying files to be built:

\itemize{

\item Files specified via the argument \code{files}

\item \code{make = TRUE} - Files which have been modified more recently
than their corresponding HTML files

\item \code{update = TRUE} - Previously published files which have been
committed more recently than their corresponding HTML files.
However, files which currently have staged or unstaged changes are not
included.

\item \code{republish = TRUE} - All published files.
However, files which currently have staged or unstaged changes are not
included.

}

Under the hood, \code{wflow_build} is a wrapper for
\code{\link[rmarkdown]{render_site}} from the package \link{rmarkdown}. By
default (\code{local = FALSE}), the code is executed in an isolated R
session. This is done using \code{\link[callr:r]{callr::r_safe}}.
}
\section{Comparison to RStudio Knit button}{


\code{wflow_build} is intentionally designed to be similar to clicking on the
Knit button in RStudio. Both isolate the code execution in a separate R
process, thus ensuring the results are not dependent on the state of the
current R session. However, they do differ in a few ways:

\describe{

  \item{Number of files}{The RStudio Knit button only builds the current Rmd
  file open in the editor. In contrast, \code{wflow_build} can build any
  number of Rmd files (each in their own separate R process) with a single
  invocation, including accepting file globs.}

  \item{System and user profiles}{The two methods diverge the most in
  their use of \code{.Rprofile} files. \code{wflow_build} ignores any system
  or user profiles (i.e. \code{~/.Rprofile} on Linux/macOS or
  \code{~/Documents/.Rprofile} on Windows). This is the default behavior of
  \code{\link[callr:r]{callr::r_safe}}, which it calls to run the separate R
  process. This is ideal for reproducibility. Otherwise the results could be
  affected by custom settings made only on the user's machine. In contrast,
  the RStudio Knit button loads any system or user level profiles, consistent
  with its role as a development tool.}

  \item{Project-specific profiles}{A project-specific \code{.Rprofile} is
  treated differently than system or user profiles. \code{wflow_build} only
  loads a project-specific \code{.Rprofile} if it is located in the current
  working directory in which \code{wflow_build} is invoked. This may be
  confusing if this differs from the directory in which the code in the Rmd
  is actually executed (the option \code{knit_root_dir} defined in
  \code{_workflowr.yml}). The RStudio Knit button only loads a
  project-specific \code{.Rprofile} if it is located in the same directory as
  its setting "Knit Directory" is configured. For example, if "Knit Directory"
  is set to "Document Directory", it will ignore any \code{.Rprofile} in the
  root of the project. But it would load the \code{.Rprofile} if "Knit
  Directory" was changed to "Project Directory".}
}

The main takeaway from the above is that you should try to limit settings and
options defined in \code{.Rprofile} to affect the interactive R experience
and superficial behavior, e.g. the option \code{max.print} to limit the
number of lines that can be printed to the console. Any critical settings
that affect the results of the analysis should be explicitly set in the Rmd
file.
}

\examples{
\dontrun{

# Build any files which have been modified
wflow_build() # equivalent to wflow_build(make = TRUE)
# Build a single file
wflow_build("file.Rmd")
# Build multiple files
wflow_build(c("file1.Rmd", "file2.Rmd"))
# Build multiple files using a file glob
wflow_build("file*.Rmd")
# Build every published file
wflow_build(republish = TRUE)
# Build file.Rmd and any files which have been modified
wflow_build("file.Rmd", make = TRUE)
}

}
\seealso{
\code{\link{wflow_publish}}
}
