% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/violinplotter.R
\name{violinplotter}
\alias{violinplotter}
\title{Plotting and Comparing Means with Violin Plots}
\usage{
violinplotter(formula, data=NULL, TITLE="", XLAB="", YLAB="",
 VIOLIN_COLOURS=c("#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe"),
 PLOT_BARS=TRUE,
 ERROR_BAR_COLOURS=c("#636363","#1c9099","#de2d26"),
 SHOW_SAMPLE_SIZE=TRUE,
 XCATEGOR=TRUE, LOGX=FALSE, LOGX_BASE=10, HSDX=TRUE,
 ALPHA=0.05, REGRESSX=FALSE)
}
\arguments{
\item{formula}{R's compact symbolic form to represent linear models with fixed additive and interaction effects (See ?formula for more information) [mandatory]}

\item{data}{data.frame containing the response and explanatory variables which forms the formula above [default=NULL]}

\item{TITLE}{string or vector of strings corresponding to violin plot title/s [default: combinations of the "response variable name X explanatory variable" from the dataframe column names]}

\item{XLAB}{string or vector of strings specifying the x-axis labels [default: column names of the explanatory variables (and their combinations) from data]}

\item{YLAB}{string or vector of strings specifying the y-axis labels [default: column names of the response variable from data]}

\item{VIOLIN_COLOURS}{vector or list of vectors of colors of the violin plots which are repeated if the length is less than the number of explanatory factor levels or less than the number of explanatory factors in the case of a list [default=c("#e0f3db", "#ccebc5", "#a8ddb5", "#7bccc4", "#4eb3d3", "#2b8cbe")]}

\item{PLOT_BARS}{logical (i.e. TRUE or FALSE) to plot all or none of the bars; or vector strings which bars to plot (e.g. "stdev", "sterr", "ci") [default=TRUE=c("stdev", "sterr", "ci")]}

\item{ERROR_BAR_COLOURS}{vector of colors of standard deviation, standard error and 95 percent confidence interval error bars (error bar selection via leaving one of the three colors empty) [default=c("#636363", "#1c9099", "#de2d26")]}

\item{SHOW_SAMPLE_SIZE}{logical referring to whether or not to show the sample sizes for each category [default=TRUE]}

\item{XCATEGOR}{logical or vector of logicals referring to whether the explanatory variable/s is/are strictly categorical [default=TRUE]}

\item{LOGX}{logical or vector of logicals referring to whether to transform the explanatory variable/s into the logarithm scale [default=FALSE]}

\item{LOGX_BASE}{numeric or vector of numerics referring to the logarithm base to transform the explanatory variable/s with [default=1]}

\item{HSDX}{logical or vector of logicals referring to whether to perform Tukey's Honest Significance Grouping [default=TRUE]}

\item{ALPHA}{numeric significance level for the analysis of variance F-test and Tukey's mean comparison [default=0.05]}

\item{REGRESSX}{logical or vector of logicals referring to whether to regress the response variable against the explanatory variable/s [default=FALSE]}
}
\value{
Violin plot/s with optional error bars, mean comparison grouping/s, and regression line/s

Mean comparison grouping/s based on Tukey's Hones significant difference and regression line statistics, if applicable
}
\description{
Plotting and Comparing Means with Violin Plots
}
\examples{
x1 = rep(rep(rep(c(1:5), each=5), times=5), times=5)
x2 = rep(rep(letters[6:10], each=5*5), times=5)
x3 = rep(letters[11:15], each=5*5*5)
y = rep(1:5, each=5*5*5) + rnorm(rep(1:5, each=5), length(x1))
formula = log(y) ~ exp(x1) + x2 + x3 + (x2:x3)
test1 = violinplotter(formula=formula)
test2 = violinplotter(formula=formula, PLOT_BARS=c("ci", "stdev"))

}
