% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_cassette.R
\name{use_cassette}
\alias{use_cassette}
\alias{local_cassette}
\title{Use a cassette to record HTTP requests}
\usage{
use_cassette(
  name,
  ...,
  dir = NULL,
  record = NULL,
  match_requests_on = NULL,
  serialize_with = NULL,
  preserve_exact_body_bytes = NULL,
  re_record_interval = NULL,
  warn_on_empty = NULL
)

local_cassette(
  name,
  dir = NULL,
  record = NULL,
  match_requests_on = NULL,
  serialize_with = NULL,
  preserve_exact_body_bytes = NULL,
  re_record_interval = NULL,
  warn_on_empty = NULL,
  frame = parent.frame()
)
}
\arguments{
\item{name}{The name of the cassette. This is used to name a file on
disk, so it must be valid file name.}

\item{...}{a block of code containing one or more requests (required). Use
curly braces to encapsulate multi-line code blocks. If you can't pass a code
block use \code{\link[=insert_cassette]{insert_cassette()}} instead.}

\item{dir}{The directory where the cassette will be stored. Defaults to
\code{test_path("_vcr")}.}

\item{record}{Record mode that dictates how HTTP requests/responses are
recorded. Possible values are:
\itemize{
\item \strong{once}, the default: Replays recorded interactions, records new ones
if no cassette exists, and errors on new requests if cassette exists.
\item \strong{none}: Replays recorded interactions, and errors on any new requests.
Guarantees that no HTTP requests occur.
\item \strong{new_episodes}: Replays recorded interactions and always records new
ones, even if similar interactions exist.
\item \strong{all}: Never replays recorded interactions, always recording new.
Useful for re-recording outdated responses or logging all HTTP requests.
}}

\item{match_requests_on}{Character vector of request matchers used to
determine which recorded HTTP interaction to replay. The default matches
on the \code{"method"}, \code{"uri"}, and either \code{"body"} (if present)
or \code{"body_json"} (if the content-type is \code{application/json}).

The full set of possible values are:
\itemize{
\item \code{method}: the HTTP method.
\item \code{uri}: the complete request URI, excluding the port.
\item \code{uri_with_port}: the complete request URI, including the port.
\item \code{host}: the \strong{host} component of the URI.
\item \code{path}: the \strong{path} component of the URI.
\item \code{query}: the \strong{query} component of the URI.
\item \code{body}: the request body.
\item \code{body_json}: the request body, parsed as JSON.
\item \code{header}: all request headers.
}

If more than one is specified, all components must match in order for the
request to match. If not supplied, defaults to \code{c("method", "uri")}.

Note that the request header and body will only be included in the
cassette if  \code{match_requests_on} includes "header" or "body" respectively.
This keeps the recorded request as lightweight as possible.}

\item{serialize_with}{(string) Which serializer to use:
\code{"yaml"} (the default), \code{"json"}, or \code{"qs2"}.}

\item{preserve_exact_body_bytes}{(logical) Force a binary (base64)
representation of the request and response bodies? By default, vcr
will look at the \code{Content-Type} header to determine if this is necessary,
but if it doesn't work you can set \code{preserve_exact_body_bytes = TRUE} to
force it.}

\item{re_record_interval}{(integer) How frequently (in seconds) the
cassette should be re-recorded. Default: \code{NULL} (not re-recorded).}

\item{warn_on_empty}{(logical) Warn if the cassette is ejected but no interactions
have been recorded. Default: \code{NULL} (inherits from global configuration).}

\item{frame}{Attach exit handlers to this environment. Typically, this
should be either the current environment or a parent frame (accessed
through \code{\link[=parent.frame]{parent.frame()}}). See \code{vignette("withr", package = "withr")}
for more details.}
}
\description{
\code{use_cassette(...)} uses a cassette for the code in \code{...};
\code{local_cassette()} uses a cassette for the current function scope (e.g.
for one test). Learn more in \code{vignette("vcr")}.

Note that defaults for most arguments are controlled by \code{\link[=vcr_configure]{vcr_configure()}},
so you may want to use that instead if you are changing the defaults for
all cassettes.
}
\seealso{
\code{\link[=insert_cassette]{insert_cassette()}} and \code{\link[=eject_cassette]{eject_cassette()}} for the underlying
functions.
}
