% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcr-package.R
\docType{package}
\name{vcr-package}
\alias{vcr}
\alias{vcr-package}
\title{vcr: Record 'HTTP' Calls to Disk}
\description{
Record test suite 'HTTP' requests and replays them during future runs. A port of the Ruby gem of the same name (\url{https://github.com/vcr/vcr/}). Works by hooking into the 'webmockr' R package for matching 'HTTP' requests by various rules ('HTTP' method, 'URL', query parameters, headers, body, etc.), and then caching real 'HTTP' responses on disk in 'cassettes'. Subsequent 'HTTP' requests matching any previous requests in the same 'cassette' use a cached 'HTTP' response.
}
\section{Backstory}{

A Ruby gem of the same name (\code{VCR}, \url{https://github.com/vcr/vcr}) was
created many years ago and is the original. Ports in many languages
have been done. Check out that GitHub repo for all the details on
how the canonical version works.
}

\section{Main functions}{

The \link{use_cassette} function is most likely what you'll want to use. It
sets the cassette you want to record to, inserts the cassette, and then
ejects the cassette, recording the interactions to the cassette.

Instead, you can use \link{insert_cassette}, but then you have to make sure
to use \link{eject_cassette}.
}

\section{vcr configuration}{

\link{vcr_configure} is the function to use to set R session wide settings.
See it's manual file for help.
}

\section{Record modes}{

See \link{recording} for help on record modes.
}

\section{Request matching}{

See \link{request-matching} for help on the many request matching options.
}

\section{Async}{

As of \pkg{crul} v1.5, \code{vcr} will work for async http requests with
\pkg{crul}. \pkg{httr} does not do async requests, and \pkg{httr2}
async plumbing does not have any hooks for mocking via \pkg{webmockr}
or recording real requests via this package
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ropensci/vcr/}
  \item \url{https://books.ropensci.org/http-testing/}
  \item \url{https://docs.ropensci.org/vcr/}
  \item Report bugs at \url{https://github.com/ropensci/vcr/issues}
}

}
\author{
\strong{Maintainer}: Scott Chamberlain \email{myrmecocystus@gmail.com} (\href{https://orcid.org/0000-0003-1444-9135}{ORCID})

Authors:
\itemize{
  \item Aaron Wolen (\href{https://orcid.org/0000-0003-2542-2202}{ORCID})
  \item Maëlle Salmon (\href{https://orcid.org/0000-0002-2815-0399}{ORCID})
  \item Daniel Possenriede (\href{https://orcid.org/0000-0002-6738-9845}{ORCID})
}

Other contributors:
\itemize{
  \item rOpenSci (019jywm96) [funder]
}

}
\keyword{internal}
