% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{make_multiple_density_plot}
\alias{make_multiple_density_plot}
\title{Multiple densities plot}
\usage{
make_multiple_density_plot(densities, legend.title, title, x.axis.label,
  legend.size = 1)
}
\arguments{
\item{densities}{a list, each element holding the results from executing
the \code{\link{density}} function to a (different) vector. Note that you
need to provide a name for each list element for the legend (see example).}

\item{legend.title}{string. The legend title.}

\item{title}{string. The plot title.}

\item{x.axis.label}{string. The x-axis label.}

\item{legend.size}{numeric. Default value: 1.}
}
\description{
Combine many density distributions to one common plot.
}
\examples{
mat = matrix(rnorm(60), ncol=20)
densities = apply(mat, 1, density)
names(densities) = c("1st", "2nd", "3rd")
make_multiple_density_plot(densities, legend.title = "Samples",
  x.axis.label = "", title = "3 Normal Distribution Samples")

}
